/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.entities.report;

import com.google.common.collect.Sets;
import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.combined.CombinedReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.combined.CombinedReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.SingleProcessReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.rest.export.report.ReportDefinitionExportDto;
import io.camunda.optimize.rest.exceptions.ForbiddenException;
import io.camunda.optimize.rest.exceptions.NotFoundException;
import io.camunda.optimize.service.db.reader.ReportReader;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.security.AuthorizedCollectionService;
import io.camunda.optimize.service.security.ReportAuthorizationService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ReportExportService {
    private static final Logger LOG = LoggerFactory.getLogger(ReportExportService.class);
    private final ReportReader reportReader;
    private final ReportAuthorizationService reportAuthorizationService;
    private final AuthorizedCollectionService authorizedCollectionService;

    public ReportExportService(ReportReader reportReader, ReportAuthorizationService reportAuthorizationService, AuthorizedCollectionService authorizedCollectionService) {
        this.reportReader = reportReader;
        this.reportAuthorizationService = reportAuthorizationService;
        this.authorizedCollectionService = authorizedCollectionService;
    }

    public List<ReportDefinitionExportDto> getReportExportDtos(Set<String> reportIds) {
        LOG.debug("Exporting all reports with IDs {} for export via API.", reportIds);
        List<ReportDefinitionDto<?>> reportDefinitions = this.retrieveReportDefinitionsOrFailIfMissing(reportIds);
        return reportDefinitions.stream().map(ReportDefinitionExportDto::mapReportDefinitionToExportDto).toList();
    }

    public List<ReportDefinitionExportDto> getReportExportDtosAsUser(String userId, Set<String> reportIds) {
        LOG.debug("Exporting all reports with IDs {} as user {}.", reportIds, (Object)userId);
        List<ReportDefinitionDto<?>> reportDefinitions = this.retrieveReportDefinitionsOrFailIfMissing(reportIds);
        this.validateReportAuthorizationsOrFail(userId, reportDefinitions);
        return reportDefinitions.stream().map(ReportDefinitionExportDto::mapReportDefinitionToExportDto).toList();
    }

    public List<ReportDefinitionDto<?>> retrieveReportDefinitionsOrFailIfMissing(Set<String> reportIds) {
        HashSet notFoundReportIds = Sets.newHashSet();
        HashSet exportedReportIds = Sets.newHashSet();
        ArrayList reportDefinitions = new ArrayList();
        reportIds.forEach(reportId -> {
            reportDefinitions.addAll(this.retrieveRelevantReportDefinitionsOrFailIfMissing((String)reportId, exportedReportIds));
            if (!exportedReportIds.contains(reportId)) {
                notFoundReportIds.add(reportId);
            }
        });
        if (!notFoundReportIds.isEmpty()) {
            throw new NotFoundException("Could not find reports with IDs " + String.valueOf(reportIds));
        }
        return reportDefinitions;
    }

    private List<ReportDefinitionDto<?>> retrieveRelevantReportDefinitionsOrFailIfMissing(String reportIdToExport, Set<String> alreadyExportedIds) {
        if (alreadyExportedIds.contains(reportIdToExport)) {
            return Collections.emptyList();
        }
        ArrayList reportDefinitions = new ArrayList();
        Optional<ReportDefinitionDto> optionalReportDef = this.reportReader.getReport(reportIdToExport);
        if (optionalReportDef.isPresent()) {
            ReportDefinitionDto reportDef = optionalReportDef.get();
            reportDefinitions.add(reportDef);
            alreadyExportedIds.add(reportDef.getId());
            if (reportDef.isCombined()) {
                List singleReportIds = ((CombinedReportDataDto)((CombinedReportDefinitionRequestDto)reportDef).getData()).getReportIds();
                singleReportIds.removeAll(alreadyExportedIds);
                List<SingleProcessReportDefinitionRequestDto> singleReportDefs = this.reportReader.getAllSingleProcessReportsForIdsOmitXml(singleReportIds);
                if (singleReportDefs.size() != singleReportIds.size()) {
                    throw new OptimizeRuntimeException("Could not retrieve some reports required by combined report with ID " + reportIdToExport);
                }
                reportDefinitions.addAll(singleReportDefs);
                alreadyExportedIds.addAll(singleReportIds);
            }
        }
        return reportDefinitions;
    }

    public void validateReportAuthorizationsOrFail(String userId, List<ReportDefinitionDto<?>> reportDefinitions) {
        ArrayList notAuthorizedReportIds = new ArrayList();
        reportDefinitions.forEach(reportDef -> {
            if (!this.reportAuthorizationService.isAuthorizedToReport(userId, (ReportDefinitionDto<?>)reportDef)) {
                notAuthorizedReportIds.add(reportDef.getId());
            }
            Optional.ofNullable(reportDef.getCollectionId()).ifPresent(collectionId -> this.authorizedCollectionService.verifyUserAuthorizedToEditCollectionResources(userId, (String)collectionId));
        });
        if (!notAuthorizedReportIds.isEmpty()) {
            throw new ForbiddenException(String.format("User with ID [%s] is not authorized to access reports with IDs [%s]", userId, notAuthorizedReportIds));
        }
    }
}

