/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.entities.dashboard;

import io.camunda.optimize.dto.optimize.query.EntityIdResponseDto;
import io.camunda.optimize.dto.optimize.query.IdResponseDto;
import io.camunda.optimize.dto.optimize.query.dashboard.DashboardDefinitionRestDto;
import io.camunda.optimize.dto.optimize.query.entity.EntityType;
import io.camunda.optimize.dto.optimize.rest.ImportIndexMismatchDto;
import io.camunda.optimize.dto.optimize.rest.export.OptimizeEntityExportDto;
import io.camunda.optimize.dto.optimize.rest.export.dashboard.DashboardDefinitionExportDto;
import io.camunda.optimize.service.dashboard.DashboardService;
import io.camunda.optimize.service.db.schema.OptimizeIndexNameService;
import io.camunda.optimize.service.db.writer.DashboardWriter;
import io.camunda.optimize.service.exceptions.OptimizeImportFileInvalidException;
import io.camunda.optimize.service.exceptions.OptimizeImportIncorrectIndexVersionException;
import io.camunda.optimize.service.util.DataUtil;
import io.camunda.optimize.service.util.IdGenerator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DashboardImportService {
    private static final Logger LOG = LoggerFactory.getLogger(DashboardImportService.class);
    private final DashboardWriter dashboardWriter;
    private final DashboardService dashboardService;
    private final OptimizeIndexNameService optimizeIndexNameService;

    public DashboardImportService(DashboardWriter dashboardWriter, DashboardService dashboardService, OptimizeIndexNameService optimizeIndexNameService) {
        this.dashboardWriter = dashboardWriter;
        this.dashboardService = dashboardService;
        this.optimizeIndexNameService = optimizeIndexNameService;
    }

    public void validateAllDashboardsOrFail(List<DashboardDefinitionExportDto> dashboardsToImport) {
        this.validateAllDashboardsOrFail(null, dashboardsToImport);
    }

    public void validateAllDashboardsOrFail(String userId, List<DashboardDefinitionExportDto> dashboardsToImport) {
        HashSet<ImportIndexMismatchDto> indexMismatches = new HashSet<ImportIndexMismatchDto>();
        dashboardsToImport.stream().mapToInt(OptimizeEntityExportDto::getSourceIndexVersion).distinct().forEach(indexVersion -> {
            try {
                this.validateIndexVersionOrFail(indexVersion);
            }
            catch (OptimizeImportIncorrectIndexVersionException e) {
                indexMismatches.addAll(e.getMismatchingIndices());
            }
        });
        dashboardsToImport.forEach(exportedDto -> {
            this.dashboardService.validateDashboardDescription(exportedDto.getDescription());
            this.validateDashboardFiltersOrFail(userId, (DashboardDefinitionExportDto)exportedDto);
        });
        if (!indexMismatches.isEmpty()) {
            throw new OptimizeImportIncorrectIndexVersionException("Could not import because source and target index versions do not match for at least one dashboard.", indexMismatches);
        }
    }

    public void importDashboardsIntoCollection(String collectionId, List<DashboardDefinitionExportDto> dashboardsToImport, Map<String, EntityIdResponseDto> originalIdToNewIdMap) {
        this.importDashboardsIntoCollection(null, collectionId, dashboardsToImport, originalIdToNewIdMap);
    }

    public void importDashboardsIntoCollection(String userId, String collectionId, List<DashboardDefinitionExportDto> dashboardsToImport, Map<String, EntityIdResponseDto> originalIdToNewIdMap) {
        dashboardsToImport.forEach(exportedDto -> this.importDashboardIntoCollection(userId, collectionId, (DashboardDefinitionExportDto)exportedDto, originalIdToNewIdMap));
    }

    private void importDashboardIntoCollection(String userId, String collectionId, DashboardDefinitionExportDto dashboardToImport, Map<String, EntityIdResponseDto> originalIdToNewIdMap) {
        dashboardToImport.getTiles().stream().filter(reportLocationDto -> IdGenerator.isValidId((String)reportLocationDto.getId())).forEach(reportLocationDto -> reportLocationDto.setId(((EntityIdResponseDto)originalIdToNewIdMap.get(reportLocationDto.getId())).getId()));
        IdResponseDto idResponse = this.dashboardWriter.createNewDashboard(Optional.ofNullable(userId).orElse("System User"), this.createDashboardDefinition(collectionId, dashboardToImport));
        originalIdToNewIdMap.put(dashboardToImport.getId(), new EntityIdResponseDto(idResponse.getId(), EntityType.DASHBOARD));
    }

    private void validateIndexVersionOrFail(Integer sourceIndexVersion) {
        int targetIndexVersion = 8;
        if (8 != sourceIndexVersion) {
            throw new OptimizeImportIncorrectIndexVersionException("Could not import because source and target index versions do not match", DataUtil.newHashSet(ImportIndexMismatchDto.builder().indexName(OptimizeIndexNameService.getOptimizeIndexOrTemplateNameForAliasAndVersion((String)this.optimizeIndexNameService.getOptimizeIndexAliasForIndex("dashboard"), (String)String.valueOf(8))).sourceIndexVersion(sourceIndexVersion).targetIndexVersion(8).build()));
        }
    }

    private void validateDashboardFiltersOrFail(String userId, DashboardDefinitionExportDto dashboardToImport) {
        try {
            this.dashboardService.validateDashboardFilters(userId, dashboardToImport.getAvailableFilters(), dashboardToImport.getTiles());
        }
        catch (Exception e) {
            throw new OptimizeImportFileInvalidException("The provided file includes at least one dashboard with invalid filters. Error: " + e.getMessage());
        }
    }

    private DashboardDefinitionRestDto createDashboardDefinition(String collectionId, DashboardDefinitionExportDto dashboardToImport) {
        DashboardDefinitionRestDto dashboardDefinition = new DashboardDefinitionRestDto();
        dashboardDefinition.setName(dashboardToImport.getName());
        dashboardDefinition.setDescription(dashboardToImport.getDescription());
        dashboardDefinition.setCollectionId(collectionId);
        dashboardDefinition.setAvailableFilters(dashboardToImport.getAvailableFilters());
        dashboardDefinition.setTiles(dashboardToImport.getTiles());
        dashboardDefinition.setManagementDashboard(false);
        dashboardDefinition.setInstantPreviewDashboard(dashboardToImport.isInstantPreviewDashboard());
        return dashboardDefinition;
    }
}

