/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.entities.dashboard;

import io.camunda.optimize.dto.optimize.query.dashboard.BaseDashboardDefinitionDto;
import io.camunda.optimize.dto.optimize.query.dashboard.DashboardDefinitionRestDto;
import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.dto.optimize.rest.export.OptimizeEntityExportDto;
import io.camunda.optimize.dto.optimize.rest.export.dashboard.DashboardDefinitionExportDto;
import io.camunda.optimize.dto.optimize.rest.export.report.ReportDefinitionExportDto;
import io.camunda.optimize.rest.exceptions.ForbiddenException;
import io.camunda.optimize.rest.exceptions.NotFoundException;
import io.camunda.optimize.service.dashboard.DashboardService;
import io.camunda.optimize.service.entities.report.ReportExportService;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.security.AuthorizedCollectionService;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DashboardExportService {
    private static final Logger LOG = LoggerFactory.getLogger(DashboardExportService.class);
    private final DashboardService dashboardService;
    private final ReportExportService reportExportService;
    private final AuthorizedCollectionService collectionService;

    public DashboardExportService(DashboardService dashboardService, ReportExportService reportExportService, AuthorizedCollectionService collectionService) {
        this.dashboardService = dashboardService;
        this.reportExportService = reportExportService;
        this.collectionService = collectionService;
    }

    public List<OptimizeEntityExportDto> getCompleteDashboardExport(Set<String> dashboardIds) {
        LOG.debug("Exporting dashboards with IDs {} via API.", dashboardIds);
        List<DashboardDefinitionRestDto> dashboards = this.retrieveDashboardDefinitionsOrFailIfMissing(dashboardIds);
        List<ReportDefinitionDto<?>> reports = this.retrieveRelevantReportDefinitionsOrFailIfMissing(dashboards);
        List<OptimizeEntityExportDto> exportDtos = reports.stream().map(ReportDefinitionExportDto::mapReportDefinitionToExportDto).collect(Collectors.toList());
        exportDtos.addAll(dashboards.stream().map(DashboardDefinitionExportDto::new).toList());
        return exportDtos;
    }

    public List<OptimizeEntityExportDto> getCompleteDashboardExport(String userId, String dashboardId) {
        LOG.debug("Exporting dashboard with ID {} as user {}.", (Object)dashboardId, (Object)userId);
        List<DashboardDefinitionRestDto> dashboards = this.retrieveDashboardDefinitionsOrFailIfMissing(Set.of(dashboardId));
        this.validateUserAuthorizedToAccessDashboardsOrFail(userId, dashboards);
        List<ReportDefinitionDto<?>> reports = this.retrieveRelevantReportDefinitionsOrFailIfMissing(dashboards);
        this.reportExportService.validateReportAuthorizationsOrFail(userId, reports);
        List<OptimizeEntityExportDto> exportDtos = reports.stream().map(ReportDefinitionExportDto::mapReportDefinitionToExportDto).collect(Collectors.toList());
        exportDtos.addAll(dashboards.stream().map(DashboardDefinitionExportDto::new).toList());
        return exportDtos;
    }

    private List<DashboardDefinitionRestDto> retrieveDashboardDefinitionsOrFailIfMissing(Set<String> dashboardIds) {
        List<DashboardDefinitionRestDto> dashboardDefinitions = this.dashboardService.getDashboardDefinitionsAsService(dashboardIds);
        if (dashboardDefinitions.size() != dashboardIds.size()) {
            List<String> foundIds = dashboardDefinitions.stream().map(BaseDashboardDefinitionDto::getId).toList();
            HashSet<String> missingDashboardIds = new HashSet<String>(dashboardIds);
            foundIds.forEach(missingDashboardIds::remove);
            throw new NotFoundException("Could not find dashboards with IDs " + String.valueOf(missingDashboardIds));
        }
        return dashboardDefinitions;
    }

    private List<ReportDefinitionDto<?>> retrieveRelevantReportDefinitionsOrFailIfMissing(List<DashboardDefinitionRestDto> dashboards) {
        Set<String> reportIds = dashboards.stream().flatMap(d -> d.getTileIds().stream()).collect(Collectors.toSet());
        try {
            return this.reportExportService.retrieveReportDefinitionsOrFailIfMissing(reportIds);
        }
        catch (NotFoundException e) {
            throw new OptimizeRuntimeException("Could not retrieve some reports required by this dashboard.");
        }
    }

    private void validateUserAuthorizedToAccessDashboardsOrFail(String userId, List<DashboardDefinitionRestDto> dashboards) {
        HashSet unauthorizedCollectionIds = new HashSet();
        dashboards.stream().map(BaseDashboardDefinitionDto::getCollectionId).distinct().forEach(collectionId -> {
            try {
                this.collectionService.verifyUserAuthorizedToEditCollectionResources(userId, (String)collectionId);
            }
            catch (ForbiddenException e) {
                unauthorizedCollectionIds.add(collectionId);
            }
        });
        if (!unauthorizedCollectionIds.isEmpty()) {
            throw new ForbiddenException(String.format("The user with ID %s is not authorized to access collections with IDs %s.", userId, unauthorizedCollectionIds));
        }
    }
}

