/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.entities;

import io.camunda.optimize.dto.optimize.query.dashboard.DashboardDefinitionRestDto;
import io.camunda.optimize.dto.optimize.query.entity.EntitiesDeleteRequestDto;
import io.camunda.optimize.dto.optimize.query.entity.EntityNameRequestDto;
import io.camunda.optimize.dto.optimize.query.entity.EntityNameResponseDto;
import io.camunda.optimize.dto.optimize.query.entity.EntityResponseDto;
import io.camunda.optimize.dto.optimize.query.entity.EntityType;
import io.camunda.optimize.dto.optimize.rest.AuthorizedCollectionDefinitionDto;
import io.camunda.optimize.dto.optimize.rest.ConflictedItemDto;
import io.camunda.optimize.dto.optimize.rest.ConflictedItemType;
import io.camunda.optimize.rest.exceptions.NotFoundException;
import io.camunda.optimize.service.collection.CollectionService;
import io.camunda.optimize.service.dashboard.DashboardService;
import io.camunda.optimize.service.dashboard.InstantPreviewDashboardService;
import io.camunda.optimize.service.db.reader.EntitiesReader;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.report.ReportService;
import io.camunda.optimize.service.security.AuthorizedCollectionService;
import io.camunda.optimize.service.security.AuthorizedEntitiesService;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EntitiesService {
    private static final Logger LOG = LoggerFactory.getLogger(EntitiesService.class);
    private final CollectionService collectionService;
    private final AuthorizedEntitiesService authorizedEntitiesService;
    private final EntitiesReader entitiesReader;
    private final ReportService reportService;
    private final DashboardService dashboardService;
    private final AuthorizedCollectionService authorizedCollectionService;
    private final InstantPreviewDashboardService instantPreviewDashboardService;

    public EntitiesService(CollectionService collectionService, AuthorizedEntitiesService authorizedEntitiesService, EntitiesReader entitiesReader, ReportService reportService, DashboardService dashboardService, AuthorizedCollectionService authorizedCollectionService, InstantPreviewDashboardService instantPreviewDashboardService) {
        this.collectionService = collectionService;
        this.authorizedEntitiesService = authorizedEntitiesService;
        this.entitiesReader = entitiesReader;
        this.reportService = reportService;
        this.dashboardService = dashboardService;
        this.authorizedCollectionService = authorizedCollectionService;
        this.instantPreviewDashboardService = instantPreviewDashboardService;
    }

    public List<EntityResponseDto> getAllEntities(String userId) {
        List<AuthorizedCollectionDefinitionDto> collectionDefinitions = this.collectionService.getAllCollectionDefinitions(userId);
        Map<String, Map<EntityType, Long>> collectionEntityCounts = this.entitiesReader.countEntitiesForCollections(collectionDefinitions.stream().map(AuthorizedCollectionDefinitionDto::getDefinitionDto).collect(Collectors.toList()));
        List<EntityResponseDto> privateEntities = this.authorizedEntitiesService.getAuthorizedPrivateEntities(userId);
        return Stream.concat(collectionDefinitions.stream().map(AuthorizedCollectionDefinitionDto::toEntityDto).peek(entityDto -> entityDto.getData().setSubEntityCounts((Map)collectionEntityCounts.get(entityDto.getId()))), privateEntities.stream()).sorted(Comparator.comparing(EntityResponseDto::getEntityType).thenComparing(EntityResponseDto::getLastModified, Comparator.reverseOrder())).collect(Collectors.toList());
    }

    public EntityNameResponseDto getEntityNames(EntityNameRequestDto requestDto, String locale) {
        Optional<EntityNameResponseDto> entityNames = this.entitiesReader.getEntityNames(requestDto, locale);
        return entityNames.orElseThrow(() -> {
            String reason = String.format("Could not get entity names search request %s", requestDto);
            return new NotFoundException(reason);
        });
    }

    public boolean entitiesHaveConflicts(EntitiesDeleteRequestDto entities, String userId) {
        entities.getDashboards().forEach(dashboardId -> {
            DashboardDefinitionRestDto dashboardDefinitionRestDto = this.dashboardService.getDashboardDefinitionAsService((String)dashboardId);
            if (dashboardDefinitionRestDto.getCollectionId() != null) {
                this.dashboardService.verifyUserHasAccessToDashboardCollection(userId, this.dashboardService.getDashboardDefinitionAsService((String)dashboardId));
            }
        });
        entities.getCollections().forEach(collectionId -> this.authorizedCollectionService.verifyUserAuthorizedToEditCollectionResources(userId, (String)collectionId));
        return this.reportsHaveConflicts(entities, userId);
    }

    public void bulkDeleteEntities(EntitiesDeleteRequestDto entities, String userId) {
        for (String reportId : entities.getReports()) {
            try {
                this.reportService.deleteReportAsUser(userId, reportId, true);
            }
            catch (NotFoundException | OptimizeRuntimeException e) {
                LOG.debug("The report with id {} could not be deleted: {}", (Object)reportId, (Object)e);
            }
        }
        for (String dashboardId : entities.getDashboards()) {
            try {
                this.dashboardService.deleteDashboardAsUser(dashboardId, userId);
            }
            catch (NotFoundException | OptimizeRuntimeException e) {
                LOG.debug("The dashboard with id {} could not be deleted: {}", (Object)dashboardId, (Object)e);
            }
        }
        for (String collectionId : entities.getCollections()) {
            try {
                this.collectionService.deleteCollection(userId, collectionId, true);
            }
            catch (NotFoundException | OptimizeRuntimeException e) {
                LOG.debug("The collection with id {} could not be deleted: {}", (Object)collectionId, (Object)e);
            }
        }
    }

    private boolean conflictingItemIsUndeletedDashboard(ConflictedItemDto item, EntitiesDeleteRequestDto entitiesDeleteRequestDto) {
        return item.getType().equals((Object)ConflictedItemType.DASHBOARD) && !entitiesDeleteRequestDto.getDashboards().contains(item.getId());
    }

    private boolean conflictingItemIsUndeletedCombinedReport(ConflictedItemDto item, List<String> reportIds) {
        return item.getType().equals((Object)ConflictedItemType.COMBINED_REPORT) && !reportIds.contains(item.getId());
    }

    private boolean reportsHaveConflicts(EntitiesDeleteRequestDto entities, String userId) {
        List reportIds = entities.getReports();
        return reportIds.stream().anyMatch(entry -> {
            Set<ConflictedItemDto> conflictedItemDtos = this.reportService.getConflictedItemsFromReportDefinition(userId, (String)entry);
            return conflictedItemDtos.stream().anyMatch(conflictedItemDto -> this.conflictingItemIsUndeletedDashboard((ConflictedItemDto)conflictedItemDto, entities) || conflictedItemDto.getType().equals((Object)ConflictedItemType.ALERT) || this.conflictingItemIsUndeletedCombinedReport((ConflictedItemDto)conflictedItemDto, reportIds));
        });
    }
}

