/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.writer;

import io.camunda.optimize.dto.optimize.query.variable.DefinitionVariableLabelsDto;
import io.camunda.optimize.service.db.repository.VariableRepository;
import io.camunda.optimize.service.db.schema.ScriptData;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VariableLabelWriter {
    private static final Logger LOG = LoggerFactory.getLogger(VariableLabelWriter.class);
    private final VariableRepository variableRepository;

    public VariableLabelWriter(VariableRepository variableRepository) {
        this.variableRepository = variableRepository;
    }

    public void createVariableLabelUpsertRequest(DefinitionVariableLabelsDto definitionVariableLabelsDto) {
        HashMap<String, List> params = new HashMap<String, List>();
        params.put("labels", definitionVariableLabelsDto.getLabels());
        String query = "def existingLabels = ctx._source.labels;\nfor (label in params['labels']) {\n   existingLabels.removeIf(existingLabel -> existingLabel.variableName.equals(label.variableName)\n                                            && existingLabel.variableType.equals(label.variableType)\n   );\n   if(label.variableLabel != null && !label.variableLabel.trim().isEmpty()) {\n        existingLabels.add(label);\n   }\n}";
        ScriptData scriptData = new ScriptData(params, "def existingLabels = ctx._source.labels;\nfor (label in params['labels']) {\n   existingLabels.removeIf(existingLabel -> existingLabel.variableName.equals(label.variableName)\n                                            && existingLabel.variableType.equals(label.variableType)\n   );\n   if(label.variableLabel != null && !label.variableLabel.trim().isEmpty()) {\n        existingLabels.add(label);\n   }\n}");
        List labelsForIndexCreation = definitionVariableLabelsDto.getLabels().stream().filter(label -> StringUtils.isNotBlank((CharSequence)label.getVariableLabel())).collect(Collectors.toList());
        definitionVariableLabelsDto.setLabels(labelsForIndexCreation);
        this.variableRepository.upsertVariableLabel("variable-label", definitionVariableLabelsDto, scriptData);
    }

    public void deleteVariableLabelsForDefinition(String processDefinitionKey) {
        LOG.debug("Deleting variable label document with id [{}].", (Object)processDefinitionKey);
        this.variableRepository.deleteVariablesForDefinition("variable-label", processDefinitionKey);
    }
}

