/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.writer;

import io.camunda.optimize.dto.optimize.importing.DecisionInstanceDto;
import io.camunda.optimize.service.db.repository.DecisionInstanceRepository;
import io.camunda.optimize.service.db.repository.IndexRepository;
import io.camunda.optimize.service.db.repository.Repository;
import io.camunda.optimize.service.db.repository.TaskRepository;
import io.camunda.optimize.service.db.schema.index.IndexMappingCreatorBuilder;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DecisionInstanceWriter {
    private static final Logger LOG = LoggerFactory.getLogger(DecisionInstanceWriter.class);
    private final IndexRepository indexRepository;
    private final TaskRepository taskRepository;
    private final Repository repository;
    private final DecisionInstanceRepository decisionInstanceRepository;

    public DecisionInstanceWriter(IndexRepository indexRepository, TaskRepository taskRepository, Repository repository, DecisionInstanceRepository decisionInstanceRepository) {
        this.indexRepository = indexRepository;
        this.taskRepository = taskRepository;
        this.repository = repository;
        this.decisionInstanceRepository = decisionInstanceRepository;
    }

    public void importDecisionInstances(List<DecisionInstanceDto> decisionInstanceDtos) {
        String importItemName = "decision instances";
        LOG.debug("Writing [{}] {} to Database.", (Object)decisionInstanceDtos.size(), (Object)"decision instances");
        Set<String> decisionDefinitionKeys = decisionInstanceDtos.stream().map(DecisionInstanceDto::getDecisionDefinitionKey).collect(Collectors.toSet());
        this.indexRepository.createMissingIndices(IndexMappingCreatorBuilder.DECISION_INSTANCE_INDEX, Set.of("decision-instance"), decisionDefinitionKeys);
        this.decisionInstanceRepository.importDecisionInstances("decision instances", decisionInstanceDtos);
    }

    public void deleteDecisionInstancesByDefinitionKeyAndEvaluationDateOlderThan(String decisionDefinitionKey, OffsetDateTime evaluationDate) {
        if (!this.indexRepository.indexExists(IndexMappingCreatorBuilder.DECISION_INSTANCE_INDEX, decisionDefinitionKey)) {
            LOG.info("Aborting deletion of instances of definition with key {} because no instances exist for this definition.", (Object)decisionDefinitionKey);
            return;
        }
        this.taskRepository.executeWithTaskMonitoring(this.repository.getDeleteByQueryActionName(), () -> this.decisionInstanceRepository.deleteDecisionInstancesByDefinitionKeyAndEvaluationDateOlderThan(decisionDefinitionKey, evaluationDate), LOG);
    }
}

