/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.repository.es;

import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.query.processoverview.ProcessDigestResponseDto;
import io.camunda.optimize.dto.optimize.query.processoverview.ProcessOverviewDto;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeSearchRequestBuilderES;
import io.camunda.optimize.service.db.es.reader.ElasticsearchReaderUtil;
import io.camunda.optimize.service.db.repository.ProcessRepository;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class ProcessRepositoryES
implements ProcessRepository {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessRepositoryES.class);
    private final OptimizeElasticsearchClient esClient;
    private final ObjectMapper objectMapper;

    public ProcessRepositoryES(OptimizeElasticsearchClient esClient, ObjectMapper objectMapper) {
        this.esClient = esClient;
        this.objectMapper = objectMapper;
    }

    @Override
    public Map<String, ProcessOverviewDto> getProcessOverviewsByKey(Set<String> processDefinitionKeys) {
        SearchResponse searchResponse;
        LOG.debug("Fetching process overviews for [{}] processes", (Object)processDefinitionKeys.size());
        if (processDefinitionKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        SearchRequest searchRequest = OptimizeSearchRequestBuilderES.of(b -> b.optimizeIndex(this.esClient, new String[]{"process-overview"}).query(q -> q.ids(i -> i.values(processDefinitionKeys.stream().toList()))).size(Integer.valueOf(1000)));
        try {
            searchResponse = this.esClient.search(searchRequest, ProcessOverviewDto.class);
        }
        catch (IOException e) {
            String reason = String.format("Was not able to fetch overviews for processes [%s].", processDefinitionKeys);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        return ElasticsearchReaderUtil.mapHits(searchResponse.hits(), ProcessOverviewDto.class, this.objectMapper).stream().collect(Collectors.toMap(ProcessOverviewDto::getProcessDefinitionKey, Function.identity()));
    }

    @Override
    public Map<String, ProcessDigestResponseDto> getAllActiveProcessDigestsByKey() {
        SearchResponse searchResponse;
        LOG.debug("Fetching all available process overviews.");
        SearchRequest searchRequest = OptimizeSearchRequestBuilderES.of(b -> b.optimizeIndex(this.esClient, new String[]{"process-overview"}).query(q -> q.bool(bb -> bb.must(m -> m.term(t -> t.field("digest.enabled").value(true))))).size(Integer.valueOf(1000)));
        try {
            searchResponse = this.esClient.search(searchRequest, ProcessOverviewDto.class);
        }
        catch (IOException e) {
            String reason = "Was not able to fetch process overviews.";
            LOG.error("Was not able to fetch process overviews.", (Throwable)e);
            throw new OptimizeRuntimeException("Was not able to fetch process overviews.", (Throwable)e);
        }
        return ElasticsearchReaderUtil.mapHits(searchResponse.hits(), ProcessOverviewDto.class, this.objectMapper).stream().collect(Collectors.toMap(ProcessOverviewDto::getProcessDefinitionKey, ProcessOverviewDto::getDigest));
    }

    @Override
    public Map<String, ProcessOverviewDto> getProcessOverviewsWithPendingOwnershipData() {
        SearchResponse searchResponse;
        LOG.debug("Fetching pending process overviews");
        SearchRequest searchRequest = OptimizeSearchRequestBuilderES.of(b -> b.optimizeIndex(this.esClient, new String[]{"process-overview"}).query(q -> q.prefix(p -> p.field("processDefinitionKey").value("pendingauthcheck"))));
        try {
            searchResponse = this.esClient.search(searchRequest, ProcessOverviewDto.class);
        }
        catch (IOException e) {
            String reason = "Was not able to fetch pending processes";
            LOG.error("Was not able to fetch pending processes", (Throwable)e);
            throw new OptimizeRuntimeException("Was not able to fetch pending processes", (Throwable)e);
        }
        return ElasticsearchReaderUtil.mapHits(searchResponse.hits(), ProcessOverviewDto.class, this.objectMapper).stream().collect(Collectors.toMap(ProcessOverviewDto::getProcessDefinitionKey, Function.identity()));
    }
}

