/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.repository.es;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.bulk.BulkOperation;
import co.elastic.clients.elasticsearch.core.bulk.IndexOperation;
import co.elastic.clients.json.JsonData;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.importing.DecisionInstanceDto;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeIndexOperationBuilderES;
import io.camunda.optimize.service.db.repository.DecisionInstanceRepository;
import io.camunda.optimize.service.db.repository.es.TaskRepositoryES;
import io.camunda.optimize.service.util.InstanceIndexUtil;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class DecisionInstanceRepositoryES
implements DecisionInstanceRepository {
    private static final Logger LOG = LoggerFactory.getLogger(DecisionInstanceRepositoryES.class);
    private final OptimizeElasticsearchClient esClient;
    private final ConfigurationService configurationService;
    private final ObjectMapper objectMapper;
    private final DateTimeFormatter dateTimeFormatter;
    private final TaskRepositoryES taskRepositoryES;

    public DecisionInstanceRepositoryES(OptimizeElasticsearchClient esClient, ConfigurationService configurationService, ObjectMapper objectMapper, DateTimeFormatter dateTimeFormatter, TaskRepositoryES taskRepositoryES) {
        this.esClient = esClient;
        this.configurationService = configurationService;
        this.objectMapper = objectMapper;
        this.dateTimeFormatter = dateTimeFormatter;
        this.taskRepositoryES = taskRepositoryES;
    }

    @Override
    public void importDecisionInstances(String importItemName, List<DecisionInstanceDto> decisionInstanceDtos) {
        this.esClient.doImportBulkRequestWithList(importItemName, decisionInstanceDtos, this::addImportDecisionInstanceRequest, this.configurationService.getSkipDataAfterNestedDocLimitReached().booleanValue());
    }

    @Override
    public void deleteDecisionInstancesByDefinitionKeyAndEvaluationDateOlderThan(String decisionDefinitionKey, OffsetDateTime evaluationDate) {
        Query query = Query.of(q -> q.bool(b -> b.filter(f -> f.range(r -> r.field("evaluationDateTime").lt(JsonData.of((Object)this.dateTimeFormatter.format(evaluationDate)))))));
        this.taskRepositoryES.tryDeleteByQueryRequest(query, String.format("decision instances with definitionKey %s and evaluationDate past %s", decisionDefinitionKey, evaluationDate), true, InstanceIndexUtil.getDecisionInstanceIndexAliasName((String)decisionDefinitionKey));
    }

    private void addImportDecisionInstanceRequest(BulkRequest.Builder bulkRequestBuilder, DecisionInstanceDto decisionInstanceDto) {
        bulkRequestBuilder.operations(BulkOperation.of(b -> b.index(OptimizeIndexOperationBuilderES.of(ib -> ((IndexOperation.Builder)ib.optimizeIndex(this.esClient, InstanceIndexUtil.getDecisionInstanceIndexAliasName((String)decisionInstanceDto.getDecisionDefinitionKey())).id(decisionInstanceDto.getDecisionInstanceId())).document((Object)decisionInstanceDto)))), new BulkOperation[0]);
    }
}

