/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report.interpreter.plan.process;

import io.camunda.optimize.dto.optimize.query.report.CommandEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.TableColumnDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.export.CSVUtils;
import java.util.List;

public interface RawProcessInstanceDataGroupByNoneExecutionPlanInterpreter {
    default public void addNewVariablesAndDtoFieldsToTableColumnConfig(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> executionContext, CommandEvaluationResult<Object> result) {
        List rawDataProcessInstanceDtos;
        try {
            rawDataProcessInstanceDtos = (List)result.getFirstMeasureData();
        }
        catch (ClassCastException e) {
            throw new OptimizeRuntimeException("Unexpected report evaluation result type", (Throwable)e);
        }
        List<String> variableNames = rawDataProcessInstanceDtos.stream().flatMap(rawDataProcessInstanceDto -> rawDataProcessInstanceDto.getVariables().keySet().stream()).map(varKey -> "variable:" + varKey).toList();
        TableColumnDto tableColumns = executionContext.getReportData().getConfiguration().getTableColumns();
        tableColumns.addNewAndRemoveUnexpectedVariableColumns(variableNames);
        tableColumns.addNewAndRemoveUnexpectedFlowNodeDurationColumns(CSVUtils.extractAllPrefixedFlowNodeKeys(rawDataProcessInstanceDtos));
        tableColumns.addCountColumns(CSVUtils.extractAllPrefixedCountKeys());
        tableColumns.addDtoColumns(CSVUtils.extractAllProcessInstanceDtoFieldKeys());
    }
}

