/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report.interpreter.groupby.process.date;

import io.camunda.optimize.dto.optimize.query.report.single.group.AggregateByDateUnit;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.group.value.DateGroupByValueDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.group.value.ProcessGroupByValueDto;
import io.camunda.optimize.dto.optimize.query.sorting.ReportSortingDto;
import io.camunda.optimize.dto.optimize.query.sorting.SortOrder;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public interface ProcessGroupByProcessInstanceRunningDateInterpreter {
    public static Optional<MinMaxStatDto> getMinMaxStats(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Supplier<MinMaxStatDto> minMaxDateRangeForCrossFieldSupplier) {
        DateGroupByValueDto groupByDate;
        ProcessGroupByValueDto processGroupByValueDto = context.getReportData().getGroupBy().getValue();
        if (processGroupByValueDto instanceof DateGroupByValueDto && AggregateByDateUnit.AUTOMATIC.equals((Object)(groupByDate = (DateGroupByValueDto)processGroupByValueDto).getUnit())) {
            return Optional.of(minMaxDateRangeForCrossFieldSupplier.get());
        }
        return Optional.empty();
    }

    public static void addQueryResult(CompositeCommandResult result, List<CompositeCommandResult.GroupByResult> groups, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        result.setGroups(groups);
        result.setGroupBySorting(context.getReportConfiguration().getSorting().orElseGet(() -> new ReportSortingDto("key", SortOrder.ASC)));
    }

    public static AggregateByDateUnit getGroupByDateUnit(ProcessReportDataDto processReportData) {
        return ((DateGroupByValueDto)processReportData.getGroupBy().getValue()).getUnit();
    }
}

