/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report.interpreter.distributedby.process.model;

import io.camunda.optimize.dto.optimize.DefinitionOptimizeResponseDto;
import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.FlowNodeDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.operator.MembershipFilterOperator;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.AssigneeFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.CandidateGroupFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.ExecutedFlowNodeFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.FilterApplicationLevel;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.ProcessFilterDto;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.interpreter.view.ViewInterpreter;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class ProcessDistributedByModelElementInterpreterHelper {
    private final DefinitionService definitionService;

    public ProcessDistributedByModelElementInterpreterHelper(DefinitionService definitionService) {
        this.definitionService = definitionService;
    }

    public List<CompositeCommandResult.DistributedByResult> missingDistributions(Map<String, FlowNodeDataDto> modelElementNames, ViewInterpreter<ProcessReportDataDto, ProcessExecutionPlan> viewInterpreter, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        Set<String> excludedFlowNodes = this.getExcludedFlowNodes(context.getReportData(), modelElementNames);
        return modelElementNames.keySet().stream().filter(key -> !excludedFlowNodes.contains(key)).map(key -> CompositeCommandResult.DistributedByResult.createDistributedByResult(key, ((FlowNodeDataDto)modelElementNames.get(key)).getName(), viewInterpreter.createEmptyResult(context))).toList();
    }

    public Map<String, FlowNodeDataDto> getModelElementData(ProcessReportDataDto reportData, Function<DefinitionOptimizeResponseDto, Map<String, FlowNodeDataDto>> modelElementDataExtractor) {
        return reportData.getDefinitions().stream().map(definitionDto -> this.definitionService.getDefinition(DefinitionType.PROCESS, definitionDto.getKey(), definitionDto.getVersions(), definitionDto.getTenantIds())).filter(Optional::isPresent).map(Optional::get).map(modelElementDataExtractor).map(Map::entrySet).flatMap(Collection::stream).collect(HashMap::new, (map, entry) -> map.put((String)entry.getKey(), (FlowNodeDataDto)entry.getValue()), HashMap::putAll);
    }

    private Set<String> getExcludedFlowNodes(ProcessReportDataDto reportData, Map<String, FlowNodeDataDto> modelElementNames) {
        Set<String> excludedFlowNodes = reportData.getFilter().stream().filter(filter -> filter instanceof ExecutedFlowNodeFilterDto && FilterApplicationLevel.VIEW.equals((Object)filter.getFilterLevel())).map(ExecutedFlowNodeFilterDto.class::cast).map(ProcessFilterDto::getData).flatMap(data -> switch (data.getOperator()) {
            default -> throw new MatchException(null, null);
            case MembershipFilterOperator.IN -> modelElementNames.keySet().stream().filter(name -> !data.getValues().contains(name));
            case MembershipFilterOperator.NOT_IN -> data.getValues().stream();
        }).collect(Collectors.toSet());
        if (this.containsIdentityFilters(reportData)) {
            excludedFlowNodes.addAll(modelElementNames.values().stream().filter(flowNode -> !"userTask".equalsIgnoreCase(flowNode.getType())).map(FlowNodeDataDto::getId).collect(Collectors.toSet()));
        }
        return excludedFlowNodes;
    }

    private boolean containsIdentityFilters(ProcessReportDataDto reportData) {
        return reportData.getFilter().stream().anyMatch(filter -> filter instanceof AssigneeFilterDto || filter instanceof CandidateGroupFilterDto);
    }
}

