/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report.interpreter.distributedby.process;

import io.camunda.optimize.dto.optimize.query.report.single.ReportDataDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.AggregationDto;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.AggregationType;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.UserTaskDurationTime;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.view.ProcessViewEntity;
import io.camunda.optimize.service.db.reader.ProcessDefinitionReader;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessView;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.DefinitionVersionHandlingUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public interface ProcessDistributedByProcessInterpreter {
    public static final String PROC_DEF_KEY_AGG = "processDefKeyAgg";
    public static final String PROC_DEF_VERSION_AGG = "processDefVersionAgg";
    public static final String TENANT_AGG = "tenantAgg";
    public static final String MISSING_TENANT_KEY = "noTenant____";

    public ProcessDefinitionReader getProcessDefinitionReader();

    public CompositeCommandResult.ViewResult emptyViewResult(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> var1);

    default public String definitionKeyField(ExecutionContext<ProcessReportDataDto, ?> context) {
        return this.isProcessReport(context) ? "processDefinitionKey" : "flowNodeInstances.definitionKey";
    }

    default public String definitionVersionField(ExecutionContext<ProcessReportDataDto, ?> context) {
        return this.isProcessReport(context) ? "processDefinitionVersion" : "flowNodeInstances.definitionVersion";
    }

    default public String tenantField(ExecutionContext<ProcessReportDataDto, ?> context) {
        return this.isProcessReport(context) ? "tenantId" : "flowNodeInstances.tenantId";
    }

    default public List<CompositeCommandResult.DistributedByResult> emptyResult(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return context.getReportData().getDefinitions().stream().map(definitionSource -> CompositeCommandResult.DistributedByResult.createDistributedByResult(definitionSource.getIdentifier(), definitionSource.getDisplayName(), this.emptyViewResult(context))).toList();
    }

    default public List<CompositeCommandResult.DistributedByResult> retrieveResult(Map<String, List<ProcessBucket>> bucketsByDefKey, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return context.getReportData().getDefinitions().stream().map(definition -> {
            CompositeCommandResult.ViewResult result = bucketsByDefKey.containsKey(definition.getKey()) ? this.calculateMergedResult(bucketsByDefKey, (ReportDataDefinitionDto)definition, context) : this.emptyViewResult(context);
            return CompositeCommandResult.DistributedByResult.createDistributedByResult(definition.getIdentifier(), definition.getDisplayName(), result);
        }).toList();
    }

    private CompositeCommandResult.ViewResult calculateMergedResult(Map<String, List<ProcessBucket>> bucketsByDefKey, ReportDataDefinitionDto definition, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        List<ProcessBucket> processBuckets = this.extractResultsToMergeForDefinitionSource(bucketsByDefKey, definition);
        if (processBuckets.isEmpty()) {
            return this.emptyViewResult(context);
        }
        ArrayList<CompositeCommandResult.ViewMeasure> viewMeasures = new ArrayList<CompositeCommandResult.ViewMeasure>();
        if (context.getPlan().getView().isFrequency()) {
            Double totalCount = processBuckets.stream().map(ProcessBucket::result).mapToDouble(result -> result.getViewMeasures().get(0).getValue()).sum();
            viewMeasures.add(CompositeCommandResult.ViewMeasure.builder().value(totalCount).build());
        } else if (context.getPlan().getView() == ProcessView.PROCESS_VIEW_USER_TASK_DURATION) {
            for (UserTaskDurationTime userTaskDurationTime : context.getReportConfiguration().getUserTaskDurationTimes()) {
                for (AggregationDto aggregationType : context.getReportConfiguration().getAggregationTypes()) {
                    Double mergedAggResult = this.calculateMergedAggregationResult(processBuckets, aggregationType, userTaskDurationTime);
                    viewMeasures.add(CompositeCommandResult.ViewMeasure.builder().aggregationType(aggregationType).userTaskDurationTime(userTaskDurationTime).value(mergedAggResult).build());
                }
            }
        } else {
            for (AggregationDto aggregationType : context.getReportConfiguration().getAggregationTypes()) {
                Double mergedAggResult = this.calculateMergedAggregationResult(processBuckets, aggregationType, null);
                viewMeasures.add(CompositeCommandResult.ViewMeasure.builder().aggregationType(aggregationType).value(mergedAggResult).build());
            }
        }
        return CompositeCommandResult.ViewResult.builder().viewMeasures(viewMeasures).build();
    }

    private Double calculateMergedAggregationResult(List<ProcessBucket> processBuckets, AggregationDto aggregationType, UserTaskDurationTime userTaskDurationTime) {
        Map<AggregationDto, List<CompositeCommandResult.ViewMeasure>> measuresByAggType = processBuckets.stream().map(ProcessBucket::result).flatMap(results -> results.getViewMeasures().stream()).filter(measure -> measure.getUserTaskDurationTime() == userTaskDurationTime).collect(Collectors.groupingBy(CompositeCommandResult.ViewMeasure::getAggregationType));
        return switch (aggregationType.getType()) {
            case AggregationType.MAX -> measuresByAggType.getOrDefault(aggregationType, Collections.emptyList()).stream().mapToDouble(CompositeCommandResult.ViewMeasure::getValue).max().orElse(0.0);
            case AggregationType.MIN -> measuresByAggType.getOrDefault(aggregationType, Collections.emptyList()).stream().mapToDouble(CompositeCommandResult.ViewMeasure::getValue).min().orElse(0.0);
            case AggregationType.SUM -> measuresByAggType.getOrDefault(aggregationType, Collections.emptyList()).stream().mapToDouble(CompositeCommandResult.ViewMeasure::getValue).sum();
            case AggregationType.AVERAGE -> {
                double totalDocCount = processBuckets.stream().mapToDouble(ProcessBucket::docCount).sum();
                if (totalDocCount == 0.0) {
                    yield null;
                }
                double totalValueSum = processBuckets.stream().map(bucket -> {
                    Optional<CompositeCommandResult.ViewMeasure> avgMeasure = bucket.result.getViewMeasures().stream().filter(measure -> measure.getAggregationType().getType() == AggregationType.AVERAGE).findFirst();
                    return avgMeasure.map(measure -> Pair.of((Object)bucket, (Object)measure.getValue()));
                }).filter(Optional::isPresent).map(Optional::get).mapToDouble(pair -> (double)((ProcessBucket)pair.getLeft()).docCount * (Double)pair.getRight()).sum();
                yield totalValueSum / totalDocCount;
            }
            case AggregationType.PERCENTILE -> null;
            default -> throw new OptimizeRuntimeException(String.format("%s is not a valid Aggregation type", aggregationType));
        };
    }

    private List<ProcessBucket> extractResultsToMergeForDefinitionSource(Map<String, List<ProcessBucket>> bucketsByDefKey, ReportDataDefinitionDto definition) {
        boolean useAllVersions = DefinitionVersionHandlingUtil.isDefinitionVersionSetToAll(definition.getVersions());
        boolean useLatestVersion = DefinitionVersionHandlingUtil.isDefinitionVersionSetToLatest(definition.getVersions());
        Optional<String> latestVersion = this.getLatestVersionForDefinition(definition, useAllVersions, useLatestVersion);
        return bucketsByDefKey.get(definition.getKey()).stream().filter(bucketForKey -> {
            if (useAllVersions) {
                return true;
            }
            if (useLatestVersion && latestVersion.isPresent()) {
                return bucketForKey.version.equals(latestVersion.get());
            }
            return definition.getVersions().contains(bucketForKey.version);
        }).filter(bucketForKey -> definition.getTenantIds().contains(bucketForKey.tenant) || bucketForKey.tenant.equals(MISSING_TENANT_KEY) && definition.getTenantIds().contains(null)).collect(Collectors.toList());
    }

    private Optional<String> getLatestVersionForDefinition(ReportDataDefinitionDto definition, boolean useAllVersions, boolean useLatestVersion) {
        return !useAllVersions && useLatestVersion ? Optional.of(this.getProcessDefinitionReader().getLatestVersionToKey(definition.getKey())) : Optional.empty();
    }

    private boolean isProcessReport(ExecutionContext<ProcessReportDataDto, ?> context) {
        return context.getReportData().getView().getEntity() == ProcessViewEntity.PROCESS_INSTANCE;
    }

    public record ProcessBucket(String procDefKey, String version, String tenant, long docCount, CompositeCommandResult.ViewResult result) {
    }
}

