/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report;

import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.SingleReportDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.SingleReportEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.single.SingleReportDataDto;
import io.camunda.optimize.dto.optimize.rest.pagination.PaginationDto;
import io.camunda.optimize.dto.optimize.rest.pagination.PaginationScrollableDto;
import io.camunda.optimize.service.db.report.ExecutionContextFactory;
import io.camunda.optimize.service.db.report.ExecutionPlanExtractor;
import io.camunda.optimize.service.db.report.ReportEvaluationContext;
import io.camunda.optimize.service.db.report.interpreter.plan.ExecutionPlanInterpreterFacade;
import io.camunda.optimize.service.db.report.plan.ExecutionPlan;
import io.camunda.optimize.service.exceptions.OptimizeException;
import io.camunda.optimize.service.exceptions.OptimizeValidationException;
import io.camunda.optimize.service.export.CsvExportService;
import io.camunda.optimize.service.util.ValidationHelper;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.stereotype.Component;

@Component
public class SingleReportEvaluator {
    private final ConfigurationService configurationService;
    private final ExecutionPlanExtractor executionPlanExtractor;
    private final ExecutionPlanInterpreterFacade interpreter;

    public SingleReportEvaluator(ConfigurationService configurationService, ExecutionPlanExtractor executionPlanExtractor, ExecutionPlanInterpreterFacade interpreter) {
        this.configurationService = configurationService;
        this.executionPlanExtractor = executionPlanExtractor;
        this.interpreter = interpreter;
    }

    public <D extends SingleReportDataDto> SingleReportEvaluationResult<Object> evaluate(ReportEvaluationContext<? extends SingleReportDefinitionDto<D>> reportEvaluationContext) throws OptimizeException {
        List results = this.extractExecutionPlansWithValidation(reportEvaluationContext).map(plan -> ExecutionContextFactory.buildExecutionContext(plan, reportEvaluationContext)).map(this.interpreter::interpret).toList();
        return new SingleReportEvaluationResult<Object>((ReportDefinitionDto<?>)reportEvaluationContext.getReportDefinition(), results);
    }

    private <R extends ReportDefinitionDto<?>> Stream<ExecutionPlan> extractExecutionPlansWithValidation(ReportEvaluationContext<R> reportEvaluationContext) {
        R reportDefinition = reportEvaluationContext.getReportDefinition();
        ValidationHelper.validate(reportDefinition.getData());
        return this.executionPlanExtractor.extractExecutionPlans(reportDefinition).stream().peek(executionPlan -> this.validatePaginationValues(reportEvaluationContext, (ExecutionPlan)executionPlan));
    }

    private <T extends ReportDefinitionDto<?>> void validatePaginationValues(ReportEvaluationContext<T> reportEvaluationContext, ExecutionPlan executionPlan) {
        if (executionPlan.isRawDataReport()) {
            this.addDefaultMissingPaginationValues(reportEvaluationContext);
        } else {
            reportEvaluationContext.getPagination().ifPresent(pagination -> {
                if (pagination.getLimit() != null || pagination.getOffset() != null) {
                    throw new OptimizeValidationException("Pagination can only be applied to raw data reports");
                }
            });
        }
    }

    private <T extends ReportDefinitionDto<?>> void addDefaultMissingPaginationValues(ReportEvaluationContext<T> reportEvaluationContext) {
        PaginationDto completePagination;
        int limit;
        int offset;
        if (reportEvaluationContext.isCsvExport()) {
            offset = 0;
            limit = Optional.ofNullable(this.configurationService.getCsvConfiguration().getExportCsvLimit()).orElse(CsvExportService.DEFAULT_RECORD_LIMIT);
        } else {
            offset = reportEvaluationContext.getPagination().filter(pag -> pag.getOffset() != null).map(PaginationDto::getOffset).orElse(0);
            limit = reportEvaluationContext.getPagination().filter(pag -> pag.getLimit() != null).map(PaginationDto::getLimit).orElse(20);
        }
        PaginationDto pagData = reportEvaluationContext.getPagination().orElse(new PaginationDto());
        if (pagData instanceof PaginationScrollableDto) {
            PaginationScrollableDto paginationFromRequest = (PaginationScrollableDto)pagData;
            String scrollId = paginationFromRequest.getScrollId();
            Integer scrollTimeout = Optional.of(paginationFromRequest).filter(pag -> pag.getScrollTimeout() != null).map(PaginationScrollableDto::getScrollTimeout).orElse(60);
            completePagination = new PaginationScrollableDto();
            ((PaginationScrollableDto)completePagination).setScrollTimeout(scrollTimeout);
            ((PaginationScrollableDto)completePagination).setScrollId(scrollId);
        } else {
            completePagination = new PaginationDto();
        }
        completePagination.setOffset(Integer.valueOf(offset));
        completePagination.setLimit(Integer.valueOf(limit));
        reportEvaluationContext.setPagination(completePagination);
    }
}

