/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report;

import io.camunda.optimize.dto.optimize.query.report.AdditionalProcessReportEvaluationFilterDto;
import io.camunda.optimize.dto.optimize.query.report.ReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.rest.pagination.PaginationDto;
import io.camunda.optimize.service.report.ReportService;
import java.time.ZoneId;
import java.util.Optional;
import java.util.Set;

public final class ReportEvaluationInfo {
    private ReportDefinitionDto<?> report;
    private String reportId;
    private String userId;
    private AdditionalProcessReportEvaluationFilterDto additionalFilters = new AdditionalProcessReportEvaluationFilterDto();
    private ZoneId timezone = ZoneId.systemDefault();
    private PaginationDto pagination;
    private boolean isCsvExport;
    private boolean isJsonExport;
    private boolean isSharedReport;
    private Set<String> hiddenFlowNodeIds;

    private ReportEvaluationInfo() {
    }

    public void postFetchSavedReport(ReportService reportService) {
        if (this.reportId != null) {
            this.report = reportService.getReportDefinition(this.reportId);
        }
    }

    public void updateReportDefinitionXml(String definitionXml) {
        ReportDataDto reportDataDto = this.report.getData();
        if (reportDataDto instanceof ProcessReportDataDto) {
            ProcessReportDataDto reportData = (ProcessReportDataDto)reportDataDto;
            reportData.getConfiguration().setXml(definitionXml);
        }
    }

    public Optional<PaginationDto> getPagination() {
        return Optional.ofNullable(this.pagination);
    }

    protected void setPagination(PaginationDto pagination) {
        this.pagination = pagination;
    }

    public static ReportEvaluationInfoBuilder builder(ReportDefinitionDto<?> report) {
        ReportEvaluationInfo reportEvaluationInfo = new ReportEvaluationInfo();
        reportEvaluationInfo.setReport(report);
        return new ReportEvaluationInfoBuilder(reportEvaluationInfo);
    }

    public static ReportEvaluationInfoBuilder builder(String reportId) {
        ReportEvaluationInfo reportEvaluationInfo = new ReportEvaluationInfo();
        reportEvaluationInfo.setReportId(reportId);
        return new ReportEvaluationInfoBuilder(reportEvaluationInfo);
    }

    public ReportDefinitionDto<?> getReport() {
        return this.report;
    }

    protected void setReport(ReportDefinitionDto<?> report) {
        this.report = report;
    }

    public String getReportId() {
        return this.reportId;
    }

    protected void setReportId(String reportId) {
        this.reportId = reportId;
    }

    public String getUserId() {
        return this.userId;
    }

    protected void setUserId(String userId) {
        this.userId = userId;
    }

    public AdditionalProcessReportEvaluationFilterDto getAdditionalFilters() {
        return this.additionalFilters;
    }

    protected void setAdditionalFilters(AdditionalProcessReportEvaluationFilterDto additionalFilters) {
        this.additionalFilters = additionalFilters;
    }

    public ZoneId getTimezone() {
        return this.timezone;
    }

    protected void setTimezone(ZoneId timezone) {
        this.timezone = timezone;
    }

    public boolean isCsvExport() {
        return this.isCsvExport;
    }

    protected void setCsvExport(boolean isCsvExport) {
        this.isCsvExport = isCsvExport;
    }

    public boolean isJsonExport() {
        return this.isJsonExport;
    }

    protected void setJsonExport(boolean isJsonExport) {
        this.isJsonExport = isJsonExport;
    }

    public boolean isSharedReport() {
        return this.isSharedReport;
    }

    protected void setSharedReport(boolean isSharedReport) {
        this.isSharedReport = isSharedReport;
    }

    public Set<String> getHiddenFlowNodeIds() {
        return this.hiddenFlowNodeIds;
    }

    protected void setHiddenFlowNodeIds(Set<String> hiddenFlowNodeIds) {
        this.hiddenFlowNodeIds = hiddenFlowNodeIds;
    }

    public static class ReportEvaluationInfoBuilder {
        private final ReportEvaluationInfo reportEvaluationInfo;

        public ReportEvaluationInfoBuilder(ReportEvaluationInfo reportEvaluationInfo) {
            this.reportEvaluationInfo = reportEvaluationInfo;
        }

        public ReportEvaluationInfoBuilder userId(String userId) {
            this.reportEvaluationInfo.setUserId(userId);
            return this;
        }

        public ReportEvaluationInfoBuilder additionalFilters(AdditionalProcessReportEvaluationFilterDto additionalFilters) {
            this.reportEvaluationInfo.setAdditionalFilters(additionalFilters);
            return this;
        }

        public ReportEvaluationInfoBuilder timezone(ZoneId timezone) {
            this.reportEvaluationInfo.setTimezone(timezone);
            return this;
        }

        public ReportEvaluationInfoBuilder pagination(PaginationDto paginationDto) {
            this.reportEvaluationInfo.setPagination(paginationDto);
            return this;
        }

        public ReportEvaluationInfoBuilder isCsvExport(boolean isExport) {
            this.reportEvaluationInfo.setCsvExport(isExport);
            return this;
        }

        public ReportEvaluationInfoBuilder isJsonExport(boolean isExport) {
            this.reportEvaluationInfo.setJsonExport(isExport);
            return this;
        }

        public ReportEvaluationInfoBuilder isSharedReport(boolean isSharedReport) {
            this.reportEvaluationInfo.setSharedReport(isSharedReport);
            return this;
        }

        public ReportEvaluationInfo build() {
            return this.reportEvaluationInfo;
        }
    }
}

