/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report;

import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.single.SingleReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.SingleReportConfigurationDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.rest.pagination.PaginationDto;
import io.camunda.optimize.service.db.filter.FilterContext;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import io.camunda.optimize.service.db.report.ReportEvaluationContext;
import io.camunda.optimize.service.db.report.plan.ExecutionPlan;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ExecutionContext<D extends SingleReportDataDto, P extends ExecutionPlan> {
    private P plan;
    private D reportData;
    private ZoneId timezone;
    private long unfilteredTotalInstanceCount;
    private Optional<PaginationDto> pagination;
    private boolean isCsvExport;
    private boolean isJsonExport;
    private MinMaxStatDto combinedRangeMinMaxStats;
    private Map<String, String> allDistributedByKeysAndLabels = new HashMap<String, String>();
    private Set<String> allVariablesNames = new HashSet<String>();
    private Set<String> hiddenFlowNodeIds = new HashSet<String>();
    private FilterContext filterContext;
    private boolean multiIndexAlias = false;

    public <R extends ReportDefinitionDto<D>> ExecutionContext(ReportEvaluationContext<? extends R> reportEvaluationContext) {
        this(reportEvaluationContext, null);
    }

    public <R extends ReportDefinitionDto<D>> ExecutionContext(ReportEvaluationContext<? extends R> reportEvaluationContext, P plan) {
        this.plan = plan;
        this.reportData = (SingleReportDataDto)reportEvaluationContext.getReportDefinition().getData();
        this.timezone = reportEvaluationContext.getTimezone();
        this.combinedRangeMinMaxStats = reportEvaluationContext.getCombinedRangeMinMaxStats();
        this.pagination = reportEvaluationContext.getPagination();
        this.isCsvExport = reportEvaluationContext.isCsvExport();
        this.filterContext = this.createFilterContext(reportEvaluationContext);
        this.isJsonExport = reportEvaluationContext.isJsonExport();
        this.hiddenFlowNodeIds = reportEvaluationContext.getHiddenFlowNodeIds();
    }

    public SingleReportConfigurationDto getReportConfiguration() {
        return this.reportData.getConfiguration();
    }

    public Optional<MinMaxStatDto> getCombinedRangeMinMaxStats() {
        return Optional.ofNullable(this.combinedRangeMinMaxStats);
    }

    public void setAllDistributedByKeys(Set<String> allDistributedByKeys) {
        this.allDistributedByKeysAndLabels = allDistributedByKeys.stream().collect(Collectors.toMap(Function.identity(), Function.identity()));
    }

    private <R extends ReportDefinitionDto<D>> FilterContext createFilterContext(ReportEvaluationContext<R> reportEvaluationContext) {
        FilterContext.FilterContextBuilder builder = FilterContext.builder().timezone(reportEvaluationContext.getTimezone());
        SingleReportDataDto definitionReportData = (SingleReportDataDto)reportEvaluationContext.getReportDefinition().getData();
        if (definitionReportData instanceof ProcessReportDataDto) {
            builder.userTaskReport(((ProcessReportDataDto)definitionReportData).isUserTaskReport());
        }
        return builder.build();
    }

    public P getPlan() {
        return this.plan;
    }

    public D getReportData() {
        return this.reportData;
    }

    public ZoneId getTimezone() {
        return this.timezone;
    }

    public long getUnfilteredTotalInstanceCount() {
        return this.unfilteredTotalInstanceCount;
    }

    public Optional<PaginationDto> getPagination() {
        return this.pagination;
    }

    public boolean isCsvExport() {
        return this.isCsvExport;
    }

    public boolean isJsonExport() {
        return this.isJsonExport;
    }

    public Map<String, String> getAllDistributedByKeysAndLabels() {
        return this.allDistributedByKeysAndLabels;
    }

    public Set<String> getAllVariablesNames() {
        return this.allVariablesNames;
    }

    public Set<String> getHiddenFlowNodeIds() {
        return this.hiddenFlowNodeIds;
    }

    public FilterContext getFilterContext() {
        return this.filterContext;
    }

    public boolean isMultiIndexAlias() {
        return this.multiIndexAlias;
    }

    public void setPlan(P plan) {
        this.plan = plan;
    }

    public void setReportData(D reportData) {
        this.reportData = reportData;
    }

    public void setTimezone(ZoneId timezone) {
        this.timezone = timezone;
    }

    public void setUnfilteredTotalInstanceCount(long unfilteredTotalInstanceCount) {
        this.unfilteredTotalInstanceCount = unfilteredTotalInstanceCount;
    }

    public void setPagination(Optional<PaginationDto> pagination) {
        this.pagination = pagination;
    }

    public void setCsvExport(boolean isCsvExport) {
        this.isCsvExport = isCsvExport;
    }

    public void setJsonExport(boolean isJsonExport) {
        this.isJsonExport = isJsonExport;
    }

    public void setCombinedRangeMinMaxStats(MinMaxStatDto combinedRangeMinMaxStats) {
        this.combinedRangeMinMaxStats = combinedRangeMinMaxStats;
    }

    public void setAllDistributedByKeysAndLabels(Map<String, String> allDistributedByKeysAndLabels) {
        this.allDistributedByKeysAndLabels = allDistributedByKeysAndLabels;
    }

    public void setAllVariablesNames(Set<String> allVariablesNames) {
        this.allVariablesNames = allVariablesNames;
    }

    public void setHiddenFlowNodeIds(Set<String> hiddenFlowNodeIds) {
        this.hiddenFlowNodeIds = hiddenFlowNodeIds;
    }

    public void setFilterContext(FilterContext filterContext) {
        this.filterContext = filterContext;
    }

    public void setMultiIndexAlias(boolean multiIndexAlias) {
        this.multiIndexAlias = multiIndexAlias;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExecutionContext;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return "ExecutionContext(plan=" + String.valueOf(this.getPlan()) + ", reportData=" + String.valueOf(this.getReportData()) + ", timezone=" + String.valueOf(this.getTimezone()) + ", unfilteredTotalInstanceCount=" + this.getUnfilteredTotalInstanceCount() + ", pagination=" + String.valueOf(this.getPagination()) + ", isCsvExport=" + this.isCsvExport() + ", isJsonExport=" + this.isJsonExport() + ", combinedRangeMinMaxStats=" + String.valueOf(this.getCombinedRangeMinMaxStats()) + ", allDistributedByKeysAndLabels=" + String.valueOf(this.getAllDistributedByKeysAndLabels()) + ", allVariablesNames=" + String.valueOf(this.getAllVariablesNames()) + ", hiddenFlowNodeIds=" + String.valueOf(this.getHiddenFlowNodeIds()) + ", filterContext=" + String.valueOf(this.getFilterContext()) + ", multiIndexAlias=" + this.isMultiIndexAlias() + ")";
    }
}

