/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.reader;

import com.nimbusds.oauth2.sdk.util.CollectionUtils;
import io.camunda.optimize.dto.optimize.query.variable.DefinitionVariableLabelsDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessToQueryDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableNameRequestDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableNameResponseDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableSourceDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableValuesQueryDto;
import io.camunda.optimize.service.db.reader.VariableLabelReader;
import io.camunda.optimize.service.db.repository.VariableRepository;
import io.camunda.optimize.util.LogUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProcessVariableReader {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessVariableReader.class);
    private final VariableLabelReader variableLabelReader;
    private final VariableRepository variableRepository;

    public ProcessVariableReader(VariableLabelReader variableLabelReader, VariableRepository variableRepository) {
        this.variableLabelReader = variableLabelReader;
        this.variableRepository = variableRepository;
    }

    public List<ProcessVariableNameResponseDto> getVariableNames(ProcessVariableNameRequestDto variableNameRequest) {
        HashMap logEntries = new HashMap();
        variableNameRequest.getProcessesToQuery().forEach(processToQuery -> logEntries.put(LogUtil.sanitizeLogMessage((String)processToQuery.getProcessDefinitionKey()), processToQuery.getProcessDefinitionVersions().stream().map(LogUtil::sanitizeLogMessage).collect(Collectors.toList())));
        LOG.debug("Fetching variable names for {definitionKey=[versions]}: [{}]", logEntries);
        List<ProcessToQueryDto> validNameRequests = variableNameRequest.getProcessesToQuery().stream().filter(request -> request.getProcessDefinitionKey() != null).filter(request -> !CollectionUtils.isEmpty((Collection)request.getProcessDefinitionVersions())).toList();
        if (validNameRequests.isEmpty()) {
            LOG.debug("Cannot fetch variable names as no valid variable requests are provided. Variable requests must include definition key and version.");
            return Collections.emptyList();
        }
        List<String> processDefinitionKeys = validNameRequests.stream().map(ProcessToQueryDto::getProcessDefinitionKey).distinct().toList();
        Map<String, DefinitionVariableLabelsDto> definitionLabelsDtos = this.variableLabelReader.getVariableLabelsByKey(processDefinitionKeys);
        return this.variableRepository.getVariableNames(variableNameRequest, validNameRequests, processDefinitionKeys, definitionLabelsDtos);
    }

    public List<String> getVariableValues(ProcessVariableValuesQueryDto requestDto) {
        List<ProcessVariableSourceDto> processVariableSources = requestDto.getProcessVariableSources().stream().filter(source -> !CollectionUtils.isEmpty((Collection)source.getProcessDefinitionVersions())).collect(Collectors.toList());
        if (processVariableSources.isEmpty()) {
            LOG.debug("Cannot fetch variable values for process definition with missing versions.");
            return Collections.emptyList();
        }
        LOG.debug("Fetching input variable values from sources [{}]", processVariableSources);
        return this.variableRepository.getVariableValues(requestDto, processVariableSources);
    }
}

