/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.reader;

import io.camunda.optimize.dto.optimize.query.analysis.DurationChartEntryDto;
import io.camunda.optimize.dto.optimize.query.analysis.FindingsDto;
import io.camunda.optimize.dto.optimize.query.analysis.FlowNodeOutlierParametersDto;
import io.camunda.optimize.dto.optimize.query.analysis.FlowNodeOutlierVariableParametersDto;
import io.camunda.optimize.dto.optimize.query.analysis.OutlierAnalysisServiceParameters;
import io.camunda.optimize.dto.optimize.query.analysis.ProcessDefinitionParametersDto;
import io.camunda.optimize.dto.optimize.query.analysis.ProcessInstanceIdDto;
import io.camunda.optimize.dto.optimize.query.analysis.VariableTermDto;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.math3.stat.inference.TestUtils;

public interface DurationOutliersReader {
    public static final String AGG_HISTOGRAM = "histogram";
    public static final String AGG_STATS = "stats";
    public static final String AGG_FILTERED_FLOW_NODES = "filteredFlowNodes";
    public static final String AGG_NESTED = "nested";
    public static final String AGG_REVERSE_NESTED_PROCESS_INSTANCE = "processInstance";
    public static final String AGG_VARIABLES = "variables";
    public static final String AGG_VARIABLE_VALUE_TERMS = "variableValueTerms";
    public static final String LOWER_DURATION_AGG = "lowerDurationAgg";
    public static final String HIGHER_DURATION_AGG = "higherDurationAgg";
    public static final String FLOW_NODE_ID_AGG = "flowNodeId";
    public static final String FLOW_NODE_TYPE_FILTER = "flowNodeTypeFilter";

    public List<DurationChartEntryDto> getCountByDurationChart(OutlierAnalysisServiceParameters<FlowNodeOutlierParametersDto> var1);

    public Map<String, FindingsDto> getFlowNodeOutlierMap(OutlierAnalysisServiceParameters<ProcessDefinitionParametersDto> var1);

    public List<VariableTermDto> getSignificantOutlierVariableTerms(OutlierAnalysisServiceParameters<FlowNodeOutlierParametersDto> var1);

    public List<ProcessInstanceIdDto> getSignificantOutlierVariableTermsInstanceIds(OutlierAnalysisServiceParameters<FlowNodeOutlierVariableParametersDto> var1);

    default public List<VariableTermDto> mapToVariableTermList(Map<String, Map<String, Long>> outlierSignificantVariableTerms, Map<String, Map<String, Long>> nonOutlierVariableTermOccurrence, long outlierProcessInstanceCount, long nonOutlierProcessInstanceCount, long totalProcessInstanceCount) {
        return outlierSignificantVariableTerms.entrySet().stream().flatMap(significantVariableTerms -> ((Map)significantVariableTerms.getValue()).entrySet().stream().map(termAndCount -> {
            String variableName = (String)significantVariableTerms.getKey();
            Long outlierTermOccurrence = (Long)termAndCount.getValue();
            return new VariableTermDto(variableName, (String)termAndCount.getKey(), outlierTermOccurrence, this.getRatio(outlierProcessInstanceCount, outlierTermOccurrence), Optional.ofNullable((Map)nonOutlierVariableTermOccurrence.get(variableName)).flatMap(entry -> Optional.ofNullable((Long)entry.get(termAndCount.getKey()))).map(nonOutlierTermOccurrence -> this.getRatio(nonOutlierProcessInstanceCount, (long)nonOutlierTermOccurrence)).orElse(0.0), this.getRatio(totalProcessInstanceCount, outlierTermOccurrence));
        })).sorted(Comparator.comparing(VariableTermDto::getInstanceCount).reversed()).collect(Collectors.toList());
    }

    default public double getRatio(long totalCount, long observedCount) {
        return (double)observedCount / (double)totalCount;
    }

    default public String getFilteredFlowNodeAggregationName(String flowNodeId) {
        return AGG_FILTERED_FLOW_NODES + flowNodeId;
    }

    default public boolean isOutlier(Long lowerOutlierBound, Long higherOutlierBound, Long durationValue) {
        return Optional.ofNullable(lowerOutlierBound).map(value -> durationValue < value).orElse(false) != false || Optional.ofNullable(higherOutlierBound).map(value -> durationValue > value).orElse(false) != false;
    }

    default public Map<String, Map<String, Long>> filterSignificantOutlierVariableTerms(Map<String, Map<String, Long>> outlierVariableTermOccurrences, Map<String, Map<String, Long>> nonOutlierVariableTermOccurrence, long outlierProcessInstanceCount, long nonOutlierProcessInstanceCount) {
        return outlierVariableTermOccurrences.entrySet().stream().map(outlierVariableTermOccurrence -> {
            String variableName = (String)outlierVariableTermOccurrence.getKey();
            Map outlierTermOccurrences = (Map)outlierVariableTermOccurrence.getValue();
            Map nonOutlierTermOccurrences = nonOutlierVariableTermOccurrence.getOrDefault(variableName, Collections.emptyMap());
            Map<String, Long> significantTerms = outlierTermOccurrences.entrySet().stream().filter(outlierTermAndCount -> {
                String term = (String)outlierTermAndCount.getKey();
                Long outlierTermCount = (Long)outlierTermAndCount.getValue();
                Long nonOutlierTermCount = nonOutlierTermOccurrences.getOrDefault(term, 0L);
                boolean isMoreFrequentInOutlierSet = this.getRatio(outlierProcessInstanceCount, outlierTermCount) > this.getRatio(nonOutlierProcessInstanceCount, nonOutlierTermCount);
                boolean isSignificant = TestUtils.chiSquareTestDataSetsComparison((long[])new long[]{nonOutlierTermCount, nonOutlierProcessInstanceCount}, (long[])new long[]{outlierTermCount, outlierProcessInstanceCount}, (double)0.001);
                return isMoreFrequentInOutlierSet && isSignificant;
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return new AbstractMap.SimpleEntry<String, Map<String, Long>>(variableName, significantTerms);
        }).filter(stringMapSimpleEntry -> !((Map)stringMapSimpleEntry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    default public List<String> generateListOfHumanTasks() {
        return List.of("userTask", "manualTask");
    }

    default public List<String> generateListOfStandardExcludedFlowNodeTypes() {
        return List.of("exclusiveGateway", "inclusiveGateway", "parallelGateway", "complexGateway", "eventBasedGateway", "callActivity", "boundaryTimer", "boundaryMessage", "boundarySignal", "compensationBoundaryCatch", "boundaryError", "boundaryEscalation", "cancelBoundaryCatch", "boundaryConditional", "startEvent", "startTimerEvent", "messageStartEvent", "signalStartEvent", "escalationStartEvent", "compensationStartEvent", "errorStartEvent", "conditionalStartEvent", "intermediateCatchEvent", "intermediateMessageCatch", "intermediateTimer", "intermediateLinkCatch", "intermediateSignalCatch", "intermediateConditional", "intermediateThrowEvent", "intermediateSignalThrow", "intermediateCompensationThrowEvent", "intermediateMessageThrowEvent", "intermediateNoneThrowEvent", "intermediateEscalationThrowEvent", "errorEndEvent", "cancelEndEvent", "terminateEndEvent", "messageEndEvent", "signalEndEvent", "compensationEndEvent", "escalationEndEvent", "noneEndEvent");
    }
}

