/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.reader;

import com.google.common.collect.Sets;
import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.ProcessDefinitionOptimizeDto;
import io.camunda.optimize.dto.optimize.ReportConstants;
import io.camunda.optimize.dto.optimize.query.analysis.BranchAnalysisOutcomeDto;
import io.camunda.optimize.dto.optimize.query.analysis.BranchAnalysisRequestDto;
import io.camunda.optimize.dto.optimize.query.analysis.BranchAnalysisResponseDto;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.util.LogUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.FlowNode;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BranchAnalysisReader {
    private static final Logger LOG = LoggerFactory.getLogger(BranchAnalysisReader.class);
    private final DefinitionService definitionService;

    protected BranchAnalysisReader(DefinitionService definitionService) {
        this.definitionService = definitionService;
    }

    public BranchAnalysisResponseDto branchAnalysis(BranchAnalysisRequestDto request, ZoneId timezone) {
        String logMsg = LogUtil.sanitizeLogMessage((String)String.format("Performing branch analysis on process definition with key [%s] and versions [%s]", request.getProcessDefinitionKey(), request.getProcessDefinitionVersions()));
        LOG.debug(logMsg);
        BranchAnalysisResponseDto result = new BranchAnalysisResponseDto();
        this.getBpmnModelInstance(request.getProcessDefinitionKey(), request.getProcessDefinitionVersions(), request.getTenantIds()).ifPresent(bpmnModelInstance -> {
            List<FlowNode> gatewayOutcomes = this.fetchGatewayOutcomes((BpmnModelInstance)bpmnModelInstance, request.getGateway());
            Set<String> flowNodeIdsWithMultipleIncomingSequenceFlows = this.extractFlowNodesWithMultipleIncomingSequenceFlows((BpmnModelInstance)bpmnModelInstance);
            FlowNode gateway = (FlowNode)bpmnModelInstance.getModelElementById(request.getGateway());
            FlowNode end = (FlowNode)bpmnModelInstance.getModelElementById(request.getEnd());
            boolean canReachEndFromGateway = this.isPathPossible(gateway, end, Sets.newHashSet());
            for (FlowNode flowNode : gatewayOutcomes) {
                Set<String> flowNodesToExcludeFromBranchAnalysis = this.extractActivitiesToExclude(gatewayOutcomes, flowNodeIdsWithMultipleIncomingSequenceFlows, flowNode.getId(), request.getEnd());
                BranchAnalysisOutcomeDto branchAnalysis = new BranchAnalysisOutcomeDto();
                if (canReachEndFromGateway) {
                    branchAnalysis = this.branchAnalysis(flowNode, request, flowNodesToExcludeFromBranchAnalysis, timezone);
                } else {
                    branchAnalysis.setActivityId(flowNode.getId());
                    branchAnalysis.setActivitiesReached(0L);
                    branchAnalysis.setActivityCount(this.calculateFlowNodeCount(flowNode.getId(), request, flowNodesToExcludeFromBranchAnalysis, timezone));
                }
                result.getFollowingNodes().put(branchAnalysis.getActivityId(), branchAnalysis);
            }
            result.setEndEvent(request.getEnd());
            result.setTotal(this.calculateFlowNodeCount(request.getEnd(), request, Collections.emptySet(), timezone));
        });
        return result;
    }

    protected abstract long calculateFlowNodeCount(String var1, BranchAnalysisRequestDto var2, Set<String> var3, ZoneId var4);

    protected abstract long calculateReachedEndEventFlowNodeCount(String var1, BranchAnalysisRequestDto var2, Set<String> var3, ZoneId var4);

    private Optional<BpmnModelInstance> getBpmnModelInstance(String definitionKey, List<String> definitionVersions, List<String> tenantIds) {
        Optional processDefinitionXml = tenantIds.stream().map(tenantId -> this.getDefinitionXml(definitionKey, definitionVersions, Collections.singletonList(tenantId))).filter(Optional::isPresent).findFirst().orElseGet(() -> this.getDefinitionXml(definitionKey, definitionVersions, ReportConstants.DEFAULT_TENANT_IDS));
        return processDefinitionXml.map(xml -> Bpmn.readModelFromStream((InputStream)new ByteArrayInputStream(xml.getBytes())));
    }

    private List<FlowNode> fetchGatewayOutcomes(BpmnModelInstance bpmnModelInstance, String gatewayFlowNodeId) {
        ArrayList<FlowNode> result = new ArrayList<FlowNode>();
        FlowNode flowNode = (FlowNode)bpmnModelInstance.getModelElementById(gatewayFlowNodeId);
        for (SequenceFlow sequence : flowNode.getOutgoing()) {
            result.add(sequence.getTarget());
        }
        return result;
    }

    private Set<String> extractFlowNodesWithMultipleIncomingSequenceFlows(BpmnModelInstance bpmnModelInstance) {
        Collection sequenceFlowCollection = bpmnModelInstance.getModelElementsByType(SequenceFlow.class);
        HashSet<String> flowNodesWithOneIncomingSequenceFlow = new HashSet<String>();
        HashSet<String> flowNodeIdsWithMultipleIncomingSequenceFlows = new HashSet<String>();
        for (SequenceFlow sequenceFlow : sequenceFlowCollection) {
            String targetFlowNodeId = sequenceFlow.getTarget().getId();
            if (flowNodesWithOneIncomingSequenceFlow.contains(targetFlowNodeId)) {
                flowNodeIdsWithMultipleIncomingSequenceFlows.add(targetFlowNodeId);
                continue;
            }
            flowNodesWithOneIncomingSequenceFlow.add(targetFlowNodeId);
        }
        return flowNodeIdsWithMultipleIncomingSequenceFlows;
    }

    private boolean isPathPossible(FlowNode currentNode, FlowNode targetNode, Set<FlowNode> visitedNodes) {
        FlowNode succeedingNode;
        visitedNodes.add(currentNode);
        List succeedingNodes = currentNode.getSucceedingNodes().list();
        boolean pathFound = false;
        Iterator iterator = succeedingNodes.iterator();
        while (iterator.hasNext() && (visitedNodes.contains(succeedingNode = (FlowNode)iterator.next()) || !(pathFound = succeedingNode.equals((Object)targetNode) || this.isPathPossible(succeedingNode, targetNode, visitedNodes)))) {
        }
        return pathFound;
    }

    private Set<String> extractActivitiesToExclude(List<FlowNode> gatewayOutcomes, Set<String> flowNodeIdsWithMultipleIncomingSequenceFlows, String currentFlowNodeId, String endEventFlowNodeId) {
        HashSet<String> flowNodesToExcludeFromBranchAnalysis = new HashSet<String>();
        for (FlowNode gatewayOutgoingNode : gatewayOutcomes) {
            String flowNodeId = gatewayOutgoingNode.getId();
            if (flowNodeIdsWithMultipleIncomingSequenceFlows.contains(flowNodeId)) continue;
            flowNodesToExcludeFromBranchAnalysis.add(gatewayOutgoingNode.getId());
        }
        flowNodesToExcludeFromBranchAnalysis.remove(currentFlowNodeId);
        flowNodesToExcludeFromBranchAnalysis.remove(endEventFlowNodeId);
        return flowNodesToExcludeFromBranchAnalysis;
    }

    private BranchAnalysisOutcomeDto branchAnalysis(FlowNode flowNode, BranchAnalysisRequestDto request, Set<String> activitiesToExclude, ZoneId timezone) {
        BranchAnalysisOutcomeDto result = new BranchAnalysisOutcomeDto();
        result.setActivityId(flowNode.getId());
        result.setActivityCount(this.calculateFlowNodeCount(flowNode.getId(), request, activitiesToExclude, timezone));
        result.setActivitiesReached(this.calculateReachedEndEventFlowNodeCount(flowNode.getId(), request, activitiesToExclude, timezone));
        return result;
    }

    private Optional<String> getDefinitionXml(String definitionKey, List<String> definitionVersions, List<String> tenants) {
        Optional<ProcessDefinitionOptimizeDto> definitionWithXmlAsService = this.definitionService.getDefinitionWithXmlAsService(DefinitionType.PROCESS, definitionKey, definitionVersions, tenants);
        return definitionWithXmlAsService.map(ProcessDefinitionOptimizeDto::getBpmn20Xml);
    }
}

