/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.writer;

import io.camunda.optimize.dto.optimize.query.IdResponseDto;
import io.camunda.optimize.dto.optimize.query.dashboard.DashboardDefinitionRestDto;
import io.camunda.optimize.dto.optimize.query.dashboard.DashboardDefinitionUpdateDto;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.writer.OpenSearchWriterUtil;
import io.camunda.optimize.service.db.writer.DashboardWriter;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.camunda.optimize.service.util.IdGenerator;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.Collections;
import java.util.Optional;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.Refresh;
import org.opensearch.client.opensearch._types.Result;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.query_dsl.ChildScoreMode;
import org.opensearch.client.opensearch._types.query_dsl.NestedQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.DeleteRequest;
import org.opensearch.client.opensearch.core.DeleteResponse;
import org.opensearch.client.opensearch.core.IndexRequest;
import org.opensearch.client.opensearch.core.IndexResponse;
import org.opensearch.client.opensearch.core.UpdateRequest;
import org.opensearch.client.opensearch.core.UpdateResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class DashboardWriterOS
implements DashboardWriter {
    private static final Logger LOG = LoggerFactory.getLogger(DashboardWriterOS.class);
    private final OptimizeOpenSearchClient osClient;

    public DashboardWriterOS(OptimizeOpenSearchClient osClient) {
        this.osClient = osClient;
    }

    @Override
    public IdResponseDto createNewDashboard(String userId, DashboardDefinitionRestDto dashboardDefinitionDto) {
        if (userId == null) {
            throw new OptimizeRuntimeException("userId cannot be null");
        }
        if (dashboardDefinitionDto == null) {
            throw new OptimizeRuntimeException("dashboardDefinitionDto cannot be null");
        }
        return this.createNewDashboard(userId, dashboardDefinitionDto, IdGenerator.getNextId());
    }

    @Override
    public IdResponseDto createNewDashboard(String userId, DashboardDefinitionRestDto dashboardDefinitionDto, String id) {
        if (userId == null) {
            throw new OptimizeRuntimeException("userId cannot be null");
        }
        if (dashboardDefinitionDto == null) {
            throw new OptimizeRuntimeException("dashboardDefinitionDto cannot be null");
        }
        if (id == null) {
            throw new OptimizeRuntimeException("id cannot be null");
        }
        LOG.debug("Writing new dashboard to OpenSearch");
        dashboardDefinitionDto.setOwner(userId);
        dashboardDefinitionDto.setName(Optional.ofNullable(dashboardDefinitionDto.getName()).orElse("New Dashboard"));
        dashboardDefinitionDto.setLastModifier(userId);
        dashboardDefinitionDto.setId(id);
        return this.saveDashboard(dashboardDefinitionDto);
    }

    @Override
    public IdResponseDto saveDashboard(DashboardDefinitionRestDto dashboardDefinitionDto) {
        if (dashboardDefinitionDto == null) {
            throw new OptimizeRuntimeException("dashboardDefinitionDto cannot be null");
        }
        dashboardDefinitionDto.setCreated(LocalDateUtil.getCurrentDateTime());
        dashboardDefinitionDto.setLastModified(LocalDateUtil.getCurrentDateTime());
        String dashboardId = dashboardDefinitionDto.getId();
        IndexRequest.Builder request = new IndexRequest.Builder().index("dashboard").id(dashboardId).document((Object)dashboardDefinitionDto).refresh(Refresh.True);
        IndexResponse indexResponse = this.osClient.index(request);
        if (!indexResponse.result().equals((Object)Result.Created)) {
            String message = "Could not write dashboard to OpenSearch. Maybe the connection to OpenSearch was lost?";
            LOG.error("Could not write dashboard to OpenSearch. Maybe the connection to OpenSearch was lost?");
            throw new OptimizeRuntimeException("Could not write dashboard to OpenSearch. Maybe the connection to OpenSearch was lost?");
        }
        LOG.debug("Dashboard with id [{}] has successfully been created.", (Object)dashboardId);
        return new IdResponseDto(dashboardId);
    }

    @Override
    public void updateDashboard(DashboardDefinitionUpdateDto dashboard, String id) {
        LOG.debug("Updating dashboard with id [{}] in OpenSearch", (Object)id);
        UpdateRequest.Builder request = new UpdateRequest.Builder().index("dashboard").id(id).doc((Object)dashboard).refresh(Refresh.True).retryOnConflict(Integer.valueOf(5));
        String errorMessage = String.format("Was not able to update dashboard with id [%s] and name [%s].", id, dashboard.getName());
        UpdateResponse updateResponse = this.osClient.update(request, errorMessage);
        if (updateResponse.shards().failed().intValue() > 0) {
            LOG.error("Was not able to update dashboard with id [{}] and name [{}].", (Object)id, (Object)dashboard.getName());
            throw new OptimizeRuntimeException("Was not able to update dashboard!");
        }
    }

    @Override
    public void removeReportFromDashboards(String reportId) {
        String updateItem = String.format("report from dashboard with report ID [%s]", reportId);
        LOG.info("Removing {}}.", (Object)updateItem);
        Script removeReportFromDashboardScript = OpenSearchWriterUtil.createDefaultScriptWithPrimitiveParams("ctx._source.tiles.removeIf(report -> report.id.equals(params.idToRemove))", Collections.singletonMap("idToRemove", JsonData.of((Object)reportId)));
        Query query = new NestedQuery.Builder().path("tiles").query(QueryDSL.term((String)"tiles.id", (String)reportId)).scoreMode(ChildScoreMode.None).build().toQuery();
        this.osClient.updateByQuery("dashboard", query, removeReportFromDashboardScript);
    }

    @Override
    public void deleteDashboardsOfCollection(String collectionId) {
        Query query = QueryDSL.term((String)"collectionId", (String)collectionId);
        this.osClient.deleteByQuery(query, true, new String[]{"dashboard"});
    }

    @Override
    public void deleteDashboard(String dashboardId) {
        LOG.debug("Deleting dashboard with id [{}]", (Object)dashboardId);
        DeleteRequest.Builder request = new DeleteRequest.Builder().index("dashboard").id(dashboardId).refresh(Refresh.True);
        String reason = String.format("Could not delete dashboard with id [%s].", dashboardId);
        DeleteResponse deleteResponse = this.osClient.delete(request, reason);
        if (!deleteResponse.result().equals((Object)Result.Deleted)) {
            String message = String.format("Could not delete dashboard with id [%s]. Dashboard does not exist.", dashboardId);
            LOG.error(message);
            throw new OptimizeRuntimeException(message);
        }
    }

    @Override
    public void deleteManagementDashboard() {
        Query query = QueryDSL.term((String)"managementDashboard", (boolean)true);
        this.osClient.deleteByQuery(query, true, new String[]{"dashboard"});
    }
}

