/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.service;

import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.service.db.os.report.context.VariableAggregationContextOS;
import io.camunda.optimize.service.db.os.report.interpreter.util.NumberHistogramAggregationUtilOS;
import io.camunda.optimize.service.db.report.interpreter.service.AbstractNumberVariableAggregationService;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.springframework.stereotype.Component;

@Component
public class NumberVariableAggregationServiceOS
extends AbstractNumberVariableAggregationService {
    public Optional<Pair<String, Aggregation>> createNumberVariableAggregation(VariableAggregationContextOS context) {
        if (context.getVariableRangeMinMaxStats().isEmpty()) {
            return Optional.empty();
        }
        Optional<Double> min = this.getBaselineForNumberVariableAggregation(context);
        if (min.isEmpty()) {
            return Optional.empty();
        }
        double intervalSize = this.getIntervalSize(context, min.get());
        double max = context.getMaxVariableValue();
        String digitFormat = VariableType.DOUBLE.equals((Object)context.getVariableType()) ? "0.00" : "0";
        return Optional.of(NumberHistogramAggregationUtilOS.generateHistogramWithField("numberVariableHistogram", intervalSize, min.get(), max, context.getNestedVariableValueFieldLabel(), digitFormat, context.getSubAggregations()));
    }
}

