/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.view.process;

import io.camunda.optimize.dto.optimize.query.report.single.ViewProperty;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.view.VariableViewPropertyDto;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.rest.exceptions.BadRequestException;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.report.interpreter.RawResult;
import io.camunda.optimize.service.db.os.report.interpreter.view.process.AbstractProcessViewMultiAggregationInterpreterOS;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.interpreter.view.process.ProcessViewVariableInterpreterHelper;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessView;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.db.util.ProcessVariableHelper;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import io.camunda.optimize.util.types.MapUtil;
import java.util.Map;
import java.util.Set;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.FilterAggregate;
import org.opensearch.client.opensearch._types.aggregations.NestedAggregate;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class ProcessViewVariableInterpreterOS
extends AbstractProcessViewMultiAggregationInterpreterOS {
    private static final String NESTED_VARIABLE_AGGREGATION = "nestedVariableAggregation";
    private static final String FILTERED_VARIABLES_AGGREGATION = "filteredVariables";

    @Override
    public Set<ProcessView> getSupportedViews() {
        return Set.of(ProcessView.PROCESS_VIEW_VARIABLE);
    }

    @Override
    public ViewProperty getViewProperty(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        VariableViewPropertyDto variableViewDto = ProcessViewVariableInterpreterHelper.getVariableViewDto(context);
        return ViewProperty.variable((String)variableViewDto.getName(), (VariableType)variableViewDto.getType());
    }

    @Override
    public Map<String, Aggregation> createAggregations(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        VariableViewPropertyDto variableViewDto = ProcessViewVariableInterpreterHelper.getVariableViewDto(context);
        VariableType variableType = variableViewDto.getType();
        if (!VariableType.getNumericTypes().contains(variableType)) {
            throw new BadRequestException("Only numeric variable types are supported for reports with view on variables!");
        }
        Map aggs = (Map)this.getAggregationStrategies(context.getReportData()).stream().map(strategy -> strategy.createAggregation(null, ProcessVariableHelper.getNestedVariableValueFieldForType(variableType))).collect(MapUtil.pairCollector());
        Aggregation filteredVariablesAggregation = new Aggregation.Builder().filter(QueryDSL.and((Query[])new Query[]{QueryDSL.term((String)ProcessVariableHelper.getNestedVariableNameField(), (String)variableViewDto.getName()), QueryDSL.term((String)ProcessVariableHelper.getNestedVariableTypeField(), (String)variableType.getId()), QueryDSL.exists((String)ProcessVariableHelper.getNestedVariableValueFieldForType(variableType))})).aggregations(aggs).build();
        Aggregation aggregation = new Aggregation.Builder().nested(n -> n.path("variables")).aggregations(FILTERED_VARIABLES_AGGREGATION, filteredVariablesAggregation).build();
        return Map.of(NESTED_VARIABLE_AGGREGATION, aggregation);
    }

    @Override
    public CompositeCommandResult.ViewResult retrieveResult(SearchResponse<RawResult> response, Map<String, Aggregate> aggs, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        NestedAggregate nested = ((Aggregate)response.aggregations().get(NESTED_VARIABLE_AGGREGATION)).nested();
        FilterAggregate filterVariables = ((Aggregate)nested.aggregations().get(FILTERED_VARIABLES_AGGREGATION)).filter();
        CompositeCommandResult.ViewResult.ViewResultBuilder viewResultBuilder = CompositeCommandResult.ViewResult.builder();
        this.getAggregationStrategies(context.getReportData()).forEach(aggregationStrategy -> {
            Double measureResult = aggregationStrategy.getValue(filterVariables.aggregations());
            viewResultBuilder.viewMeasure(CompositeCommandResult.ViewMeasure.builder().aggregationType(aggregationStrategy.getAggregationType()).value(measureResult).build());
        });
        return viewResultBuilder.build();
    }
}

