/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.util;

import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.query_dsl.Query;

public final class FilterLimitedAggregationUtilOS {
    public static final String FILTER_LIMITED_AGGREGATION = "filterLimitedAggregation";

    private FilterLimitedAggregationUtilOS() {
    }

    public static Pair<String, Aggregation> wrapWithFilterLimitedParentAggregation(Query limitFilterQuery, Pair<String, Aggregation> subAggregationToLimit) {
        return FilterLimitedAggregationUtilOS.wrapWithFilterLimitedParentAggregation(FILTER_LIMITED_AGGREGATION, limitFilterQuery, subAggregationToLimit);
    }

    public static Pair<String, Aggregation> wrapWithFilterLimitedParentAggregation(String filterParentAggregationName, Query limitFilterQuery, Pair<String, Aggregation> subAggregation) {
        return Pair.of((Object)filterParentAggregationName, (Object)new Aggregation.Builder().filter(limitFilterQuery).aggregations((String)subAggregation.getKey(), (Aggregation)subAggregation.getValue()).build());
    }

    public static Optional<Map<String, Aggregate>> unwrapFilterLimitedAggregations(Map<String, Aggregate> aggregations) {
        return FilterLimitedAggregationUtilOS.unwrapFilterLimitedAggregations(FILTER_LIMITED_AGGREGATION, aggregations);
    }

    public static Optional<Map<String, Aggregate>> unwrapFilterLimitedAggregations(String filterParentAggregationName, Map<String, Aggregate> aggregations) {
        return aggregations.containsKey(filterParentAggregationName) ? Optional.ofNullable(aggregations.get(filterParentAggregationName).filter().aggregations()) : Optional.empty();
    }
}

