/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.util;

import io.camunda.optimize.dto.optimize.query.report.single.process.filter.data.DurationFilterDataDto;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.writer.OpenSearchWriterUtil;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.Script;

public final class DurationScriptUtilOS {
    private DurationScriptUtilOS() {
    }

    public static Script getDurationScript(long currRequestDateInMs, String durationFieldName, String referenceDateFieldName) {
        HashMap<String, JsonData> params = new HashMap<String, JsonData>();
        return OpenSearchWriterUtil.createDefaultScriptWithPrimitiveParams(DurationScriptUtilOS.getDurationCalculationScriptPart(params, currRequestDateInMs, durationFieldName, referenceDateFieldName) + " return result;", params);
    }

    public static Script getUserTaskDurationScript(long currRequestDateInMs, String durationFieldName) {
        Map<String, JsonData> params = Map.of("currRequestDateInMs", QueryDSL.json((Object)currRequestDateInMs), "startDateFieldName", QueryDSL.json((Object)"flowNodeInstances.startDate"), "endDateFieldName", QueryDSL.json((Object)"flowNodeInstances.endDate"), "assigneeFieldName", QueryDSL.json((Object)"flowNodeInstances.assignee"), "totalDurationFieldName", QueryDSL.json((Object)"flowNodeInstances.totalDurationInMs"), "idleDurationFieldName", QueryDSL.json((Object)"flowNodeInstances.idleDurationInMs"), "workDurationFieldName", QueryDSL.json((Object)"flowNodeInstances.workDurationInMs"));
        return OpenSearchWriterUtil.createDefaultScriptWithPrimitiveParams(DurationScriptUtilOS.getUserTaskDurationCalculationScriptPart(durationFieldName) + " return result;", params);
    }

    private static String getUserTaskDurationCalculationScriptPart(String durationFieldName) {
        String variableDefinitionScript = DurationScriptUtilOS.getUserTaskDurationCalculationVariableDefinitionScriptPart();
        if (durationFieldName.contains("totalDurationInMs")) {
            return DurationScriptUtilOS.getUserTaskTotalDurationCalculationScriptPart(variableDefinitionScript);
        }
        if (durationFieldName.contains("idleDurationInMs")) {
            return DurationScriptUtilOS.getUserTaskIdleDurationCalculationScriptPart(variableDefinitionScript);
        }
        return DurationScriptUtilOS.getUserTaskWorkDurationCalculationScriptPart(variableDefinitionScript);
    }

    private static String getUserTaskDurationCalculationVariableDefinitionScriptPart() {
        return "def result = 0;\ndef hasStarted = !doc[params.startDateFieldName].empty && doc[params.startDateFieldName].value != null;\ndef hasEnded = !doc[params.endDateFieldName].empty && doc[params.endDateFieldName].value != null;\ndef isRunning = hasStarted && !hasEnded;\ndef isCurrentlyIdle = doc[params.assigneeFieldName].empty || doc[params.assigneeFieldName].value == null;\ndef hasTotalDuration = !doc[params.totalDurationFieldName].empty && doc[params.totalDurationFieldName].value != null;\ndef hasIdleDuration = !doc[params.idleDurationFieldName].empty && doc[params.idleDurationFieldName].value != null;\ndef hasWorkDuration = !doc[params.workDurationFieldName].empty && doc[params.workDurationFieldName].value != null;\ndef startTimeInMs = hasStarted ? doc[params.startDateFieldName].value.toInstant().toEpochMilli(): 0;\ndef endTimeInMs = hasEnded ? doc[params.endDateFieldName].value.toInstant().toEpochMilli(): 0;\ndef currTotalDuration = 0;\nif(hasEnded) {\n  if(hasTotalDuration) {\n    currTotalDuration = doc[params.totalDurationFieldName].value;\n  } else {\n    currTotalDuration = endTimeInMs - startTimeInMs;\n  }\n} else if(isRunning) {\n  currTotalDuration = params.currRequestDateInMs - startTimeInMs;\n}\n";
    }

    private static String getUserTaskTotalDurationCalculationScriptPart(String variableDefinitionScript) {
        return variableDefinitionScript + "result = currTotalDuration;";
    }

    private static String getUserTaskIdleDurationCalculationScriptPart(String variableDefinitionScript) {
        return variableDefinitionScript + "if(hasIdleDuration && (hasEnded || !isCurrentlyIdle)){\n  result = doc[params.idleDurationFieldName].value;}\nelse {\n  def durationToAdd = 0;\n  def currentIdleDuration = hasIdleDuration ? doc[params.idleDurationFieldName].value : 0;\n  def workDuration = hasWorkDuration ? doc[params.workDurationFieldName].value : 0;\n  durationToAdd = currTotalDuration - workDuration;\n  result = currentIdleDuration + durationToAdd;\n}\n";
    }

    private static String getUserTaskWorkDurationCalculationScriptPart(String variableDefinitionScript) {
        return variableDefinitionScript + "if(hasWorkDuration && hasEnded){\n  result = doc[params.workDurationFieldName].value;}\nelse if (isCurrentlyIdle) {\n  if (hasWorkDuration) {\n    result = doc[params.workDurationFieldName].value;\n  } else {\n    result = null ;\n  }\n} else {\n  def durationToAdd = 0;\n  def currentWorkDuration = hasWorkDuration ? doc[params.workDurationFieldName].value : 0;\n  def idleDuration = hasIdleDuration ? doc[params.idleDurationFieldName].value : 0;\n  durationToAdd = currTotalDuration - idleDuration;\n  result = currentWorkDuration + durationToAdd;\n}\n";
    }

    public static Script getDurationFilterScript(long currRequestDateInMs, String durationFieldName, String referenceDateFieldName, DurationFilterDataDto durationFilterDto) {
        HashMap<String, JsonData> params = new HashMap<String, JsonData>();
        params.put("filterDuration", JsonData.of((Object)DurationScriptUtilOS.getFilterDuration(durationFilterDto)));
        return OpenSearchWriterUtil.createDefaultScriptWithPrimitiveParams(DurationScriptUtilOS.getDurationCalculationScriptPart(params, currRequestDateInMs, durationFieldName, referenceDateFieldName) + " return (result != null && result " + durationFilterDto.getOperator().getId() + " params['filterDuration']) || (" + durationFilterDto.isIncludeNull() + " && result == null)", params);
    }

    private static long getFilterDuration(DurationFilterDataDto durationFilterDto) {
        return ChronoUnit.valueOf(durationFilterDto.getUnit().name()).getDuration().toMillis() * durationFilterDto.getValue();
    }

    private static String getDurationCalculationScriptPart(Map<String, JsonData> params, long currRequestDateInMs, String durationFieldName, String referenceDateFieldName) {
        params.put("currRequestDateInMs", JsonData.of((Object)currRequestDateInMs));
        params.put("durFieldName", JsonData.of((Object)durationFieldName));
        params.put("refDateFieldName", JsonData.of((Object)referenceDateFieldName));
        return "Long result;\nif (doc[params.durFieldName].empty && !doc[params.refDateFieldName].empty) {\n  result = params.currRequestDateInMs - doc[params.refDateFieldName].value.toInstant().toEpochMilli()\n} else {\n  result = !doc[params.durFieldName].empty ? doc[params.durFieldName].value : null\n}\n";
    }
}

