/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.plan;

import io.camunda.optimize.dto.optimize.query.report.CommandEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.single.SingleReportDataDto;
import io.camunda.optimize.dto.optimize.rest.pagination.PaginationDto;
import io.camunda.optimize.dto.optimize.rest.pagination.PaginationScrollableDto;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.client.dsl.RequestDSL;
import io.camunda.optimize.service.db.os.client.dsl.UnitDSL;
import io.camunda.optimize.service.db.os.report.interpreter.RawResult;
import io.camunda.optimize.service.db.os.report.interpreter.groupby.GroupByInterpreterOS;
import io.camunda.optimize.service.db.os.report.interpreter.view.ViewInterpreterOS;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.interpreter.plan.ExecutionPlanInterpreter;
import io.camunda.optimize.service.db.report.interpreter.result.ResultInterpreter;
import io.camunda.optimize.service.db.report.plan.ExecutionPlan;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.ExceptionUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExecutionPlanInterpreterOS<DATA extends SingleReportDataDto, PLAN extends ExecutionPlan>
implements ExecutionPlanInterpreter<DATA, PLAN> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractExecutionPlanInterpreterOS.class);

    @Override
    public CommandEvaluationResult<Object> interpret(ExecutionContext<DATA, PLAN> executionContext) {
        SearchResponse<?> response;
        try {
            response = this.executeRequests(executionContext, this.createBaseQuerySearchRequest(executionContext));
        }
        catch (RuntimeException e) {
            if (ExceptionUtil.isInstanceIndexNotFoundException((RuntimeException)e)) {
                if (executionContext.getReportData().getDefinitions().size() > 1) {
                    LOG.info("Could not evaluate report because at least one required instance index {} does not exist. Retrying with index multi alias", Arrays.asList(this.getIndexNames(executionContext)));
                    executionContext.setMultiIndexAlias(true);
                    SearchRequest.Builder searchRequestBuilder = this.createBaseQuerySearchRequest(executionContext);
                    try {
                        response = this.executeRequests(executionContext, searchRequestBuilder);
                    }
                    catch (RuntimeException ex) {
                        if (ExceptionUtil.isInstanceIndexNotFoundException((RuntimeException)e)) {
                            return this.returnEmptyResult(executionContext);
                        }
                        throw ex;
                    }
                    catch (IOException ex) {
                        throw e;
                    }
                }
                return this.returnEmptyResult(executionContext);
            }
            throw e;
        }
        catch (IOException e) {
            String reason = String.format("Could not evaluate %s report for definitions [%s]", executionContext.getPlan(), executionContext.getReportData().getDefinitions());
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        return this.retrieveQueryResult(response, executionContext);
    }

    protected abstract GroupByInterpreterOS<DATA, PLAN> getGroupByInterpreter();

    protected abstract ViewInterpreterOS<DATA, PLAN> getViewInterpreter();

    protected abstract OptimizeOpenSearchClient getOsClient();

    protected abstract BoolQuery.Builder baseQueryBuilder(ExecutionContext<DATA, PLAN> var1);

    protected abstract String[] getIndexNames(ExecutionContext<DATA, PLAN> var1);

    protected abstract String[] getMultiIndexAlias();

    protected abstract BoolQuery.Builder unfilteredBaseQueryBuilder(ExecutionContext<DATA, PLAN> var1);

    private SearchRequest.Builder createBaseQuerySearchRequest(ExecutionContext<DATA, PLAN> executionContext) {
        Query query = this.getGroupByInterpreter().adjustQuery(this.baseQueryBuilder(executionContext), executionContext).build().toQuery();
        SearchRequest.Builder searchRequestBuilder = new SearchRequest.Builder().index(Arrays.asList(this.getIndexNames(executionContext))).query(query).trackTotalHits(b -> b.enabled(Boolean.valueOf(true))).source(s -> s.fetch(Boolean.valueOf(false)));
        executionContext.getPagination().ifPresent(pagination -> {
            Optional.ofNullable(pagination.getOffset()).ifPresent(arg_0 -> ((SearchRequest.Builder)searchRequestBuilder).from(arg_0));
            Optional.ofNullable(pagination.getLimit()).ifPresent(arg_0 -> ((SearchRequest.Builder)searchRequestBuilder).size(arg_0));
        });
        searchRequestBuilder.aggregations(this.getGroupByInterpreter().createAggregation(query, executionContext));
        this.getGroupByInterpreter().adjustSearchRequest(searchRequestBuilder, query, executionContext);
        return searchRequestBuilder;
    }

    private SearchResponse<?> executeRequests(ExecutionContext<DATA, PLAN> executionContext, SearchRequest.Builder searchRequestBuilder) throws IOException {
        SearchResponse<?> response = this.executeSearch(executionContext, searchRequestBuilder);
        String[] indices = this.getIndexNames(executionContext);
        Query countQuery = this.unfilteredBaseQueryBuilder(executionContext).build().toQuery();
        executionContext.setUnfilteredTotalInstanceCount(this.getOsClient().count(indices, countQuery));
        return response;
    }

    private SearchResponse<?> executeSearch(ExecutionContext<DATA, PLAN> executionContext, SearchRequest.Builder searchRequestBuilder) throws IOException {
        PaginationDto paginationInfo = executionContext.getPagination().orElse(new PaginationDto());
        String errorMsg = "Failed to execute search request";
        if (paginationInfo instanceof PaginationScrollableDto) {
            PaginationScrollableDto scrollableDto = (PaginationScrollableDto)paginationInfo;
            String scrollId = scrollableDto.getScrollId();
            Integer timeout = scrollableDto.getScrollTimeout();
            if (scrollId != null && !scrollId.isEmpty()) {
                return this.getOsClient().scroll(RequestDSL.scrollRequest((String)scrollId, (String)UnitDSL.seconds((long)timeout.intValue()).time()), Object.class);
            }
            return this.getOsClient().search(searchRequestBuilder.scroll(UnitDSL.seconds((long)timeout.intValue())), Object.class, "Failed to execute search request");
        }
        return this.getOsClient().searchWithFixedAggregations(searchRequestBuilder, Object.class, "Failed to execute search request");
    }

    private CommandEvaluationResult<Object> returnEmptyResult(ExecutionContext<DATA, PLAN> executionContext) {
        LOG.info("Could not evaluate report. Returning empty result instead");
        return ResultInterpreter.interpret(executionContext, new CompositeCommandResult((SingleReportDataDto)executionContext.getReportData(), this.getViewInterpreter().getViewProperty(executionContext), this.getViewInterpreter().createEmptyResult(executionContext).getViewMeasures().stream().findFirst().map(CompositeCommandResult.ViewMeasure::getValue).orElse(null)));
    }

    private CommandEvaluationResult<Object> retrieveQueryResult(SearchResponse<RawResult> response, ExecutionContext<DATA, PLAN> executionContext) {
        CompositeCommandResult result = this.getGroupByInterpreter().retrieveQueryResult(response, executionContext);
        CommandEvaluationResult reportResult = ResultInterpreter.interpret(executionContext, result);
        reportResult.setInstanceCount(response.hits().total().value());
        reportResult.setInstanceCountWithoutFilters(executionContext.getUnfilteredTotalInstanceCount());
        executionContext.getPagination().ifPresent(plainPagination -> {
            PaginationScrollableDto scrollablePagination = PaginationScrollableDto.fromPaginationDto((PaginationDto)plainPagination);
            scrollablePagination.setScrollId(response.scrollId());
            reportResult.setPagination((PaginationDto)scrollablePagination);
        });
        return reportResult;
    }
}

