/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.groupby.process.usertask;

import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.os.report.filter.util.ModelElementFilterQueryUtilOS;
import io.camunda.optimize.service.db.os.report.interpreter.RawResult;
import io.camunda.optimize.service.db.os.report.interpreter.groupby.process.AbstractProcessGroupByInterpreterOS;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.interpreter.groupby.usertask.ProcessGroupByUserTaskInterpreterHelper;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import java.util.Map;
import java.util.Optional;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.FilterAggregate;
import org.opensearch.client.opensearch._types.aggregations.SingleBucketAggregateBase;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchResponse;

public abstract class AbstractGroupByUserTaskInterpreterOS
extends AbstractProcessGroupByInterpreterOS {
    private static final String USER_TASKS_AGGREGATION = "userTasks";
    private static final String FLOW_NODE_AGGREGATION = "flowNodes";
    private static final String FILTERED_USER_TASKS_AGGREGATION = "filteredUserTasks";

    protected abstract DefinitionService getDefinitionService();

    protected abstract ProcessGroupByUserTaskInterpreterHelper getHelper();

    protected Map<String, Aggregation> createFilteredUserTaskAggregation(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Query baseQuery, String name, Aggregation subAggregation) {
        Aggregation.Builder.ContainerBuilder builder = new Aggregation.Builder().nested(n -> n.path("flowNodeInstances"));
        builder.aggregations(USER_TASKS_AGGREGATION, Aggregation.of(a -> {
            Aggregation.Builder.ContainerBuilder aggregations = a.filter(f -> f.bool(ModelElementFilterQueryUtilOS.createUserTaskFlowNodeTypeFilter().build())).aggregations(FILTERED_USER_TASKS_AGGREGATION, Aggregation.of(aa -> aa.filter(f -> f.bool(ModelElementFilterQueryUtilOS.createModelElementAggregationFilter((ProcessReportDataDto)context.getReportData(), context.getFilterContext(), this.getDefinitionService()).build())).aggregations(name, subAggregation)));
            this.getDistributedByInterpreter().createAggregations(context, baseQuery).forEach((arg_0, arg_1) -> ((Aggregation.Builder.ContainerBuilder)aggregations).aggregations(arg_0, arg_1));
            return aggregations;
        }));
        return Map.of(FLOW_NODE_AGGREGATION, builder.build());
    }

    protected Optional<FilterAggregate> getFilteredUserTaskAggregation(SearchResponse<RawResult> response) {
        return this.getUserTasksAggregation(response).map(SingleBucketAggregateBase::aggregations).map(aggs -> ((Aggregate)aggs.get(FILTERED_USER_TASKS_AGGREGATION)).filter());
    }

    protected Optional<FilterAggregate> getUserTasksAggregation(SearchResponse<RawResult> response) {
        return Optional.ofNullable(response.aggregations()).filter(f -> !f.isEmpty()).map(aggs -> ((Aggregate)aggs.get(FLOW_NODE_AGGREGATION)).nested()).map(flowNodeAgg -> ((Aggregate)flowNodeAgg.aggregations().get(USER_TASKS_AGGREGATION)).filter());
    }
}

