/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.groupby.process.flownode;

import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.os.report.interpreter.RawResult;
import io.camunda.optimize.service.db.os.report.interpreter.distributedby.process.ProcessDistributedByInterpreterFacadeOS;
import io.camunda.optimize.service.db.os.report.interpreter.groupby.process.flownode.AbstractGroupByFlowNodeInterpreterOS;
import io.camunda.optimize.service.db.os.report.interpreter.util.DurationScriptUtilOS;
import io.camunda.optimize.service.db.os.report.interpreter.view.process.ProcessViewInterpreterFacadeOS;
import io.camunda.optimize.service.db.os.report.service.DurationAggregationServiceOS;
import io.camunda.optimize.service.db.os.report.service.MinMaxStatsServiceOS;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import io.camunda.optimize.util.types.MapUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class ProcessGroupByFlowNodeDurationInterpreterOS
extends AbstractGroupByFlowNodeInterpreterOS {
    private final MinMaxStatsServiceOS minMaxStatsService;
    private final DefinitionService definitionService;
    private final ProcessDistributedByInterpreterFacadeOS distributedByInterpreter;
    private final DurationAggregationServiceOS durationAggregationService;
    private final ProcessViewInterpreterFacadeOS viewInterpreter;

    public ProcessGroupByFlowNodeDurationInterpreterOS(MinMaxStatsServiceOS minMaxStatsService, DefinitionService definitionService, ProcessDistributedByInterpreterFacadeOS distributedByInterpreter, DurationAggregationServiceOS durationAggregationService, ProcessViewInterpreterFacadeOS viewInterpreter) {
        this.minMaxStatsService = minMaxStatsService;
        this.definitionService = definitionService;
        this.distributedByInterpreter = distributedByInterpreter;
        this.durationAggregationService = durationAggregationService;
        this.viewInterpreter = viewInterpreter;
    }

    @Override
    public DefinitionService getDefinitionService() {
        return this.definitionService;
    }

    @Override
    public Set<ProcessGroupBy> getSupportedGroupBys() {
        return Set.of(ProcessGroupBy.PROCESS_GROUP_BY_FLOW_NODE_DURATION);
    }

    @Override
    public Map<String, Aggregation> createAggregation(Query query, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return this.durationAggregationService.createLimitedGroupByScriptedEventDurationAggregation(query, context, this.getDurationScript()).map(MapUtil::createFromPair).map(durationAggregation -> this.createFilteredFlowNodeAggregation(context, (Map<String, Aggregation>)durationAggregation)).orElse(Map.of());
    }

    @Override
    public Optional<MinMaxStatDto> getMinMaxStats(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Query baseQuery) {
        return Optional.of(this.retrieveMinMaxDurationStats(context, baseQuery));
    }

    @Override
    public void addQueryResult(CompositeCommandResult compositeCommandResult, SearchResponse<RawResult> response, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        compositeCommandResult.setGroupByKeyOfNumericType(true);
        compositeCommandResult.setDistributedByKeyOfNumericType(this.distributedByInterpreter.isKeyOfNumericType(context));
        this.getFilteredFlowNodesAggregation(response).ifPresent(filteredFlowNodes -> {
            List<CompositeCommandResult.GroupByResult> durationHistogramData = this.durationAggregationService.mapGroupByDurationResults(response, filteredFlowNodes.aggregations(), context);
            compositeCommandResult.setGroups(durationHistogramData);
        });
    }

    public ProcessDistributedByInterpreterFacadeOS getDistributedByInterpreter() {
        return this.distributedByInterpreter;
    }

    public ProcessViewInterpreterFacadeOS getViewInterpreter() {
        return this.viewInterpreter;
    }

    private MinMaxStatDto retrieveMinMaxDurationStats(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Query baseQuery) {
        return this.minMaxStatsService.getScriptedMinMaxStats(baseQuery, this.getIndexNames(context), "flowNodeInstances", this.getDurationScript());
    }

    private Script getDurationScript() {
        return DurationScriptUtilOS.getDurationScript(LocalDateUtil.getCurrentDateTime().toInstant().toEpochMilli(), "flowNodeInstances.totalDurationInMs", "flowNodeInstances.startDate");
    }
}

