/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.groupby.process.date;

import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.db.os.report.interpreter.RawResult;
import io.camunda.optimize.service.db.os.report.interpreter.distributedby.process.ProcessDistributedByInterpreterFacadeOS;
import io.camunda.optimize.service.db.os.report.interpreter.groupby.process.AbstractProcessGroupByInterpreterOS;
import io.camunda.optimize.service.db.os.report.interpreter.util.DurationScriptUtilOS;
import io.camunda.optimize.service.db.os.report.interpreter.view.process.ProcessViewInterpreterFacadeOS;
import io.camunda.optimize.service.db.os.report.service.DurationAggregationServiceOS;
import io.camunda.optimize.service.db.os.report.service.MinMaxStatsServiceOS;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class ProcessGroupByDurationInterpreterOS
extends AbstractProcessGroupByInterpreterOS {
    private final DurationAggregationServiceOS durationAggregationService;
    private final MinMaxStatsServiceOS minMaxStatsService;
    private final ProcessDistributedByInterpreterFacadeOS distributedByInterpreter;
    private final ProcessViewInterpreterFacadeOS viewInterpreter;

    public ProcessGroupByDurationInterpreterOS(DurationAggregationServiceOS durationAggregationService, MinMaxStatsServiceOS minMaxStatsService, ProcessDistributedByInterpreterFacadeOS distributedByInterpreter, ProcessViewInterpreterFacadeOS viewInterpreter) {
        this.durationAggregationService = durationAggregationService;
        this.minMaxStatsService = minMaxStatsService;
        this.distributedByInterpreter = distributedByInterpreter;
        this.viewInterpreter = viewInterpreter;
    }

    @Override
    public Set<ProcessGroupBy> getSupportedGroupBys() {
        return Set.of(ProcessGroupBy.PROCESS_GROUP_BY_DURATION);
    }

    @Override
    public Map<String, Aggregation> createAggregation(Query baseQuery, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        Script durationScript = this.getDurationScript();
        return this.durationAggregationService.createLimitedGroupByScriptedDurationAggregation(baseQuery, context, durationScript).stream().collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    @Override
    public void addQueryResult(CompositeCommandResult compositeCommandResult, SearchResponse<RawResult> response, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        List<CompositeCommandResult.GroupByResult> durationHistogramData = this.durationAggregationService.mapGroupByDurationResults(response, response.aggregations(), context);
        compositeCommandResult.setGroups(durationHistogramData);
        compositeCommandResult.setGroupByKeyOfNumericType(true);
        compositeCommandResult.setDistributedByKeyOfNumericType(this.distributedByInterpreter.isKeyOfNumericType(context));
    }

    @Override
    public Optional<MinMaxStatDto> getMinMaxStats(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Query baseQuery) {
        return Optional.of(this.retrieveMinMaxDurationStats(context, baseQuery));
    }

    private MinMaxStatDto retrieveMinMaxDurationStats(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Query baseQuery) {
        return this.minMaxStatsService.getScriptedMinMaxStats(baseQuery, this.getIndexNames(context), null, this.getDurationScript());
    }

    private Script getDurationScript() {
        return DurationScriptUtilOS.getDurationScript(LocalDateUtil.getCurrentDateTime().toInstant().toEpochMilli(), "duration", "startDate");
    }

    public ProcessDistributedByInterpreterFacadeOS getDistributedByInterpreter() {
        return this.distributedByInterpreter;
    }

    public ProcessViewInterpreterFacadeOS getViewInterpreter() {
        return this.viewInterpreter;
    }
}

