/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.distributedby.process;

import io.camunda.optimize.dto.optimize.query.report.single.group.AggregateByDateUnit;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.distributed.VariableDistributedByDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.distributed.value.VariableDistributedByValueDto;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.service.db.os.client.dsl.AggregationDSL;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.report.context.VariableAggregationContextOS;
import io.camunda.optimize.service.db.os.report.interpreter.RawResult;
import io.camunda.optimize.service.db.os.report.interpreter.distributedby.process.AbstractProcessDistributedByInterpreterOS;
import io.camunda.optimize.service.db.os.report.interpreter.view.process.ProcessViewInterpreterFacadeOS;
import io.camunda.optimize.service.db.os.report.service.DateAggregationServiceOS;
import io.camunda.optimize.service.db.os.report.service.VariableAggregationServiceOS;
import io.camunda.optimize.service.db.os.util.ProcessVariableHelperOS;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.context.VariableAggregationContext;
import io.camunda.optimize.service.db.report.plan.process.ProcessDistributedBy;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.db.util.ProcessVariableHelper;
import io.camunda.optimize.service.util.InstanceIndexUtil;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.FilterAggregate;
import org.opensearch.client.opensearch._types.aggregations.NestedAggregate;
import org.opensearch.client.opensearch._types.aggregations.NestedAggregation;
import org.opensearch.client.opensearch._types.aggregations.ReverseNestedAggregation;
import org.opensearch.client.opensearch._types.aggregations.StringTermsAggregate;
import org.opensearch.client.opensearch._types.aggregations.StringTermsBucket;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class ProcessDistributedByVariableInterpreterOS
extends AbstractProcessDistributedByInterpreterOS {
    private static final String PARENT_FILTER_AGGREGATION = "matchAllFilter";
    private final ProcessViewInterpreterFacadeOS viewInterpreter;
    private final DateAggregationServiceOS dateAggregationService;
    private final VariableAggregationServiceOS variableAggregationService;

    public ProcessDistributedByVariableInterpreterOS(ProcessViewInterpreterFacadeOS viewInterpreter, DateAggregationServiceOS dateAggregationService, VariableAggregationServiceOS variableAggregationService) {
        this.viewInterpreter = viewInterpreter;
        this.dateAggregationService = dateAggregationService;
        this.variableAggregationService = variableAggregationService;
    }

    @Override
    public Set<ProcessDistributedBy> getSupportedDistributedBys() {
        return Set.of(ProcessDistributedBy.PROCESS_DISTRIBUTED_BY_VARIABLE);
    }

    @Override
    public boolean isKeyOfNumericType(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return VariableType.getNumericTypes().contains(this.getVariableType(context));
    }

    @Override
    public Map<String, Aggregation> createAggregations(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Query baseQuery) {
        Map<String, Aggregation> subAggregations = Map.of("instCount", AggregationDSL.withSubaggregations((ReverseNestedAggregation)new ReverseNestedAggregation.Builder().build(), this.viewInterpreter.createAggregations(context)));
        VariableAggregationContext varAggContext = ((VariableAggregationContextOS.VariableAggregationContextOSBuilder)((VariableAggregationContextOS.VariableAggregationContextOSBuilder)((VariableAggregationContext.VariableAggregationContextBuilder)((VariableAggregationContextOS.VariableAggregationContextOSBuilder)((VariableAggregationContextOS.VariableAggregationContextOSBuilder)((VariableAggregationContextOS.VariableAggregationContextOSBuilder)((VariableAggregationContextOS.VariableAggregationContextOSBuilder)((VariableAggregationContextOS.VariableAggregationContextOSBuilder)((VariableAggregationContextOS.VariableAggregationContextOSBuilder)((VariableAggregationContextOS.VariableAggregationContextOSBuilder)((VariableAggregationContextOS.VariableAggregationContextOSBuilder)((VariableAggregationContextOS.VariableAggregationContextOSBuilder)((VariableAggregationContextOS.VariableAggregationContextOSBuilder)VariableAggregationContextOS.builder().variableName(this.getVariableName(context))).variableType(this.getVariableType(context))).variablePath("variables")).nestedVariableNameField(ProcessVariableHelper.getNestedVariableNameField())).nestedVariableValueFieldLabel(this.getNestedVariableValueFieldLabel(this.getVariableType(context)))).indexNames(InstanceIndexUtil.getProcessInstanceIndexAliasNames((ProcessReportDataDto)context.getReportData()))).timezone(context.getTimezone())).customBucketDto(context.getReportData().getConfiguration().getDistributeByCustomBucket())).dateUnit(this.getDistributeByDateUnit(context))).baseQueryForMinMaxStats(baseQuery)).subAggregations(subAggregations)).combinedRangeMinMaxStats(context.getCombinedRangeMinMaxStats().orElse(null))).filterContext(context.getFilterContext())).build();
        Optional<Pair<String, Aggregation>> variableSubAggregation = this.variableAggregationService.createVariableSubAggregation((VariableAggregationContextOS)varAggContext);
        if (variableSubAggregation.isEmpty()) {
            return this.viewInterpreter.createAggregations(context);
        }
        Pair<String, Aggregation> undefinedOrNullVariableAggregation = this.createUndefinedOrNullVariableAggregation(context);
        Aggregation filterVariablesAggregation = AggregationDSL.withSubaggregations((Aggregation)AggregationDSL.filterAggregation((Query)QueryDSL.and((Query[])new Query[]{QueryDSL.term((String)ProcessVariableHelper.getNestedVariableNameField(), (String)this.getVariableName(context)), QueryDSL.term((String)ProcessVariableHelper.getNestedVariableTypeField(), (String)this.getVariableType(context).getId()), QueryDSL.exists((String)this.getNestedVariableValueFieldLabel(VariableType.STRING))})), Map.of((String)variableSubAggregation.get().getKey(), (Aggregation)variableSubAggregation.get().getValue(), "filteredInstCount", new ReverseNestedAggregation.Builder().build()._toAggregation()));
        Aggregation nestedVariableAggregation = AggregationDSL.withSubaggregations((NestedAggregation)new NestedAggregation.Builder().path("variables").build(), Map.of("filteredVariables", filterVariablesAggregation));
        return Map.of(PARENT_FILTER_AGGREGATION, AggregationDSL.withSubaggregations((Aggregation)AggregationDSL.filterAggregation((Query)QueryDSL.matchAll()), Map.of((String)undefinedOrNullVariableAggregation.getKey(), (Aggregation)undefinedOrNullVariableAggregation.getValue(), "nestedVariables", nestedVariableAggregation)));
    }

    @Override
    public List<CompositeCommandResult.DistributedByResult> retrieveResult(SearchResponse<RawResult> response, Map<String, Aggregate> aggregations, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        if (!aggregations.containsKey(PARENT_FILTER_AGGREGATION)) {
            return Collections.emptyList();
        }
        FilterAggregate parentFilterAgg = aggregations.get(PARENT_FILTER_AGGREGATION).filter();
        NestedAggregate nested = ((Aggregate)parentFilterAgg.aggregations().get("nestedVariables")).nested();
        FilterAggregate filteredVariables = ((Aggregate)nested.aggregations().get("filteredVariables")).filter();
        FilterAggregate filteredParentAgg = filteredVariables.aggregations().containsKey("filterLimitedAggregation") ? ((Aggregate)filteredVariables.aggregations().get("filterLimitedAggregation")).filter() : filteredVariables;
        Map<String, Map<String, Aggregate>> bucketMap = filteredParentAgg.aggregations().containsKey("variables") ? this.variableAggregationService.resultBucketMap((Aggregate)filteredParentAgg.aggregations().get("variables")) : this.variableAggregationService.resultBucketMap((Aggregate)filteredParentAgg.aggregations().get("numberVariableHistogram"));
        Map<String, Map<String, Aggregate>> bucketAggregations = this.variableAggregationService.retrieveResultBucketMap(filteredParentAgg, bucketMap, this.getVariableType(context), context.getTimezone());
        ArrayList<CompositeCommandResult.DistributedByResult> distributedByResults = new ArrayList<CompositeCommandResult.DistributedByResult>();
        for (Map.Entry<String, Map<String, Aggregate>> keyToAggregationEntry : bucketAggregations.entrySet()) {
            CompositeCommandResult.ViewResult viewResult = this.viewInterpreter.retrieveResult(response, this.variableAggregationService.retrieveSubAggregationFromBucketMapEntry(keyToAggregationEntry), context);
            distributedByResults.add(CompositeCommandResult.DistributedByResult.createDistributedByResult(keyToAggregationEntry.getKey(), null, viewResult));
        }
        this.addMissingVariableBuckets(distributedByResults, response, aggregations, context);
        this.addEmptyMissingDistributedByResults(distributedByResults, context);
        return distributedByResults;
    }

    @Override
    public void enrichContextWithAllExpectedDistributedByKeys(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Map<String, Aggregate> aggregations) {
        FilterAggregate missingVarAgg;
        Aggregate parentFilterAgg = aggregations.get(PARENT_FILTER_AGGREGATION);
        if (parentFilterAgg == null) {
            context.setAllDistributedByKeysAndLabels(new HashMap<String, String>());
            return;
        }
        Set<String> allDistributedByKeys = new HashSet<String>();
        VariableType type = this.getVariableType(context);
        if (!VariableType.getNumericTypes().contains(type)) {
            NestedAggregate nestedAgg = ((Aggregate)parentFilterAgg.filter().aggregations().get("nestedVariables")).nested();
            FilterAggregate filteredVarAgg = ((Aggregate)nestedAgg.aggregations().get("filteredVariables")).filter();
            if (VariableType.DATE.equals((Object)type)) {
                Aggregate filterLimitedAgg = (Aggregate)filteredVarAgg.aggregations().get("filterLimitedAggregation");
                allDistributedByKeys = this.dateAggregationService.mapDateAggregationsToKeyAggregationMap(filterLimitedAgg == null ? filteredVarAgg.aggregations() : filterLimitedAgg.filter().aggregations(), context.getTimezone(), "variables").keySet();
            } else {
                StringTermsAggregate varNamesAgg = ((Aggregate)filteredVarAgg.aggregations().get("variables")).sterms();
                allDistributedByKeys = varNamesAgg.buckets().array().stream().map(StringTermsBucket::key).collect(Collectors.toSet());
            }
        }
        if ((missingVarAgg = ((Aggregate)parentFilterAgg.filter().aggregations().get("missingVariables")).filter()).docCount() > 0L) {
            allDistributedByKeys.add("missing");
        }
        context.setAllDistributedByKeys(allDistributedByKeys);
    }

    private Pair<String, Aggregation> createUndefinedOrNullVariableAggregation(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return Pair.of((Object)"missingVariables", (Object)AggregationDSL.withSubaggregations((Aggregation)AggregationDSL.filterAggregation((Query)ProcessVariableHelperOS.createFilterForUndefinedOrNullQuery(this.getVariableName(context), this.getVariableType(context))), this.viewInterpreter.createAggregations(context)));
    }

    private void addEmptyMissingDistributedByResults(List<CompositeCommandResult.DistributedByResult> distributedByResults, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        context.getAllDistributedByKeysAndLabels().entrySet().stream().filter(entry -> distributedByResults.stream().noneMatch(distributedByResult -> distributedByResult.getKey().equals(entry.getKey()))).map(entry -> CompositeCommandResult.DistributedByResult.createDistributedByResult((String)entry.getKey(), (String)entry.getValue(), this.viewInterpreter.createEmptyResult(context))).forEach(distributedByResults::add);
    }

    private void addMissingVariableBuckets(List<CompositeCommandResult.DistributedByResult> distributedByResults, SearchResponse<RawResult> response, Map<String, Aggregate> aggregations, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        FilterAggregate parentFilterAgg = aggregations.get(PARENT_FILTER_AGGREGATION).filter();
        FilterAggregate missingVarAgg = ((Aggregate)parentFilterAgg.aggregations().get("missingVariables")).filter();
        if (missingVarAgg.docCount() > 0L) {
            CompositeCommandResult.ViewResult viewResult = this.viewInterpreter.retrieveResult(response, (Map<String, Aggregate>)missingVarAgg.aggregations(), context);
            distributedByResults.add(CompositeCommandResult.DistributedByResult.createDistributedByResult("missing", null, viewResult));
        }
    }

    private String getVariableName(ExecutionContext<ProcessReportDataDto, ?> context) {
        return this.getVariableDistributedByValueDto(context).getName();
    }

    private VariableType getVariableType(ExecutionContext<ProcessReportDataDto, ?> context) {
        return this.getVariableDistributedByValueDto(context).getType();
    }

    private String getNestedVariableValueFieldLabel(VariableType type) {
        return ProcessVariableHelper.getNestedVariableValueFieldForType(type);
    }

    private VariableDistributedByValueDto getVariableDistributedByValueDto(ExecutionContext<ProcessReportDataDto, ?> context) {
        return (VariableDistributedByValueDto)((VariableDistributedByDto)context.getReportData().getDistributedBy()).getValue();
    }

    private AggregateByDateUnit getDistributeByDateUnit(ExecutionContext<ProcessReportDataDto, ?> context) {
        return context.getReportData().getConfiguration().getDistributeByDateVariableUnit();
    }

    public ProcessViewInterpreterFacadeOS getViewInterpreter() {
        return this.viewInterpreter;
    }
}

