/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.filter.util;

import com.nimbusds.oauth2.sdk.util.CollectionUtils;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.flownode.FlowNodeDateFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.operator.MembershipFilterOperator;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.AssigneeFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.CanceledFlowNodesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.CandidateGroupFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.CompletedFlowNodesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.CompletedOrCanceledFlowNodesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.ExecutedFlowNodeFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.FilterApplicationLevel;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.FlowNodeDurationFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.FlowNodeEndDateFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.FlowNodeStartDateFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.ProcessFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.RunningFlowNodesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.data.ExecutedFlowNodeFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.data.FlowNodeDurationFiltersDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.data.IdentityLinkFilterDataDto;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.filter.FilterContext;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.report.filter.util.DateFilterQueryUtilOS;
import io.camunda.optimize.service.db.os.report.filter.util.NestedDefinitionQueryBuilderOS;
import io.camunda.optimize.service.db.os.report.interpreter.util.DurationScriptUtilOS;
import io.camunda.optimize.service.db.report.filter.util.ModelElementFilterQueryUtil;
import io.camunda.optimize.service.exceptions.OptimizeValidationException;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.ChildScoreMode;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.ScriptQuery;
import org.opensearch.client.util.TriFunction;

public final class ModelElementFilterQueryUtilOS {
    private static final Map<Class<? extends ProcessFilterDto<?>>, Function<BoolQuery.Builder, BoolQuery.Builder>> FLOW_NODE_STATUS_VIEW_FILTER_INSTANCE_QUERIES = Map.of(RunningFlowNodesOnlyFilterDto.class, ModelElementFilterQueryUtilOS::createRunningFlowNodesOnlyFilterQuery, CompletedFlowNodesOnlyFilterDto.class, ModelElementFilterQueryUtilOS::createCompletedFlowNodesOnlyFilterQuery, CompletedOrCanceledFlowNodesOnlyFilterDto.class, ModelElementFilterQueryUtilOS::createCompletedOrCanceledFlowNodesOnlyFilterQuery, CanceledFlowNodesOnlyFilterDto.class, ModelElementFilterQueryUtilOS::createCanceledFlowNodesOnlyFilterQuery);
    private static final NestedDefinitionQueryBuilderOS NESTED_DEFINITION_QUERY_BUILDER = new NestedDefinitionQueryBuilderOS("flowNodeInstances", "definitionKey", "definitionVersion", "tenantId");
    private static final Map<Class<? extends ProcessFilterDto<?>>, TriFunction<FlowNodeDateFilterDataDto<?>, ZoneId, BoolQuery.Builder, BoolQuery.Builder>> FLOW_NODE_DATE_VIEW_FILTER_INSTANCE_QUERIES = Map.of(FlowNodeStartDateFilterDto.class, ModelElementFilterQueryUtilOS::createFlowNodeStartDateFilterQuery, FlowNodeEndDateFilterDto.class, ModelElementFilterQueryUtilOS::createFlowNodeEndDateFilterQuery);

    private ModelElementFilterQueryUtilOS() {
    }

    public static Optional<Query> instanceFilterForRelevantViewLevelFiltersQuery(List<ProcessFilterDto<?>> filters, FilterContext filterContext) {
        List<ProcessFilterDto<?>> viewLevelFiltersForInstanceMatch = ModelElementFilterQueryUtil.getViewLevelFiltersForInstanceMatch(filters);
        if (!viewLevelFiltersForInstanceMatch.isEmpty()) {
            BoolQuery.Builder viewFilterInstanceQueryBuilder = ModelElementFilterQueryUtilOS.createFlowNodeTypeFilterQuery(filterContext.isUserTaskReport());
            viewLevelFiltersForInstanceMatch.forEach(filter -> {
                if (filter instanceof FlowNodeDurationFilterDto) {
                    FlowNodeDurationFiltersDataDto filterData = (FlowNodeDurationFiltersDataDto)filter.getData();
                    ModelElementFilterQueryUtilOS.createFlowNodeDurationFilterQuery(filterData, viewFilterInstanceQueryBuilder);
                } else if (filter instanceof CandidateGroupFilterDto) {
                    IdentityLinkFilterDataDto filterData = (IdentityLinkFilterDataDto)filter.getData();
                    ModelElementFilterQueryUtilOS.createCandidateGroupFilterQuery(filterData, viewFilterInstanceQueryBuilder);
                } else if (filter instanceof AssigneeFilterDto) {
                    IdentityLinkFilterDataDto filterData = (IdentityLinkFilterDataDto)filter.getData();
                    ModelElementFilterQueryUtilOS.createAssigneeFilterQuery(filterData, viewFilterInstanceQueryBuilder);
                } else if (filter instanceof ExecutedFlowNodeFilterDto) {
                    ExecutedFlowNodeFilterDataDto filterData = (ExecutedFlowNodeFilterDataDto)filter.getData();
                    ModelElementFilterQueryUtilOS.createExecutedFlowNodeFilterQuery(filterData, viewFilterInstanceQueryBuilder);
                } else if (FLOW_NODE_DATE_VIEW_FILTER_INSTANCE_QUERIES.containsKey(filter.getClass())) {
                    FLOW_NODE_DATE_VIEW_FILTER_INSTANCE_QUERIES.get(filter.getClass()).apply((Object)((FlowNodeDateFilterDataDto)filter.getData()), (Object)filterContext.getTimezone(), (Object)viewFilterInstanceQueryBuilder);
                } else {
                    FLOW_NODE_STATUS_VIEW_FILTER_INSTANCE_QUERIES.get(filter.getClass()).apply(viewFilterInstanceQueryBuilder);
                }
            });
            return Optional.of(QueryDSL.nested((String)"flowNodeInstances", (Query)viewFilterInstanceQueryBuilder.build().toQuery(), (ChildScoreMode)ChildScoreMode.None));
        }
        return Optional.empty();
    }

    public static BoolQuery.Builder createModelElementAggregationFilter(ProcessReportDataDto reportData, FilterContext filterContext, DefinitionService definitionService) {
        BoolQuery.Builder filterBoolQueryBuilder = ModelElementFilterQueryUtilOS.createFlowNodeTypeFilterQuery(reportData).minimumShouldMatch("1");
        Map filtersByDefinition = reportData.groupFiltersByDefinitionIdentifier();
        reportData.getDefinitions().forEach(definitionDto -> {
            BoolQuery.Builder flowNodeDefinitionQueryBuilder = NESTED_DEFINITION_QUERY_BUILDER.createNestedDocDefinitionQuery(definitionDto.getKey(), definitionDto.getVersions(), definitionDto.getTenantIds(), definitionService);
            ModelElementFilterQueryUtilOS.addModelElementFilters(flowNodeDefinitionQueryBuilder, filterContext, filtersByDefinition.getOrDefault(definitionDto.getIdentifier(), List.of()));
            filterBoolQueryBuilder.should(flowNodeDefinitionQueryBuilder.build().toQuery(), new Query[0]);
        });
        ModelElementFilterQueryUtilOS.addModelElementFilters(filterBoolQueryBuilder, filterContext, filtersByDefinition.getOrDefault("all", List.of()));
        return filterBoolQueryBuilder;
    }

    private static void addModelElementFilters(BoolQuery.Builder filterBoolQueryBuilder, FilterContext filterContext, List<ProcessFilterDto<?>> filters) {
        if (filters.isEmpty()) {
            return;
        }
        ModelElementFilterQueryUtilOS.addFlowNodeStatusFilter(filterBoolQueryBuilder, filters);
        ModelElementFilterQueryUtilOS.addFlowNodeDurationFilter(filterBoolQueryBuilder, filters);
        ModelElementFilterQueryUtilOS.addFlowNodeIdFilter(filterBoolQueryBuilder, filters);
        ModelElementFilterQueryUtilOS.addFlowNodeStartDateFilter(filterBoolQueryBuilder, filterContext.getTimezone(), filters);
        ModelElementFilterQueryUtilOS.addFlowNodeEndDateFilter(filterBoolQueryBuilder, filterContext.getTimezone(), filters);
        ModelElementFilterQueryUtilOS.addAssigneeFilter(filterBoolQueryBuilder, filters);
        ModelElementFilterQueryUtilOS.addCandidateGroupFilter(filterBoolQueryBuilder, filters);
    }

    public static BoolQuery.Builder createUserTaskFlowNodeTypeFilter() {
        return new BoolQuery.Builder().must(QueryDSL.term((String)ModelElementFilterQueryUtilOS.nestedFieldReference("flowNodeType"), (String)"userTask"), new Query[0]);
    }

    public static Query createInclusiveFlowNodeIdFilterQuery(ProcessReportDataDto reportDataDto, Set<String> flowNodeIds, FilterContext filterContext, DefinitionService definitionService) {
        return ModelElementFilterQueryUtilOS.createExecutedFlowNodeFilterQuery(ModelElementFilterQueryUtilOS.createModelElementAggregationFilter(reportDataDto, filterContext, definitionService), ModelElementFilterQueryUtilOS.nestedFieldReference("flowNodeId"), new ArrayList<String>(flowNodeIds), MembershipFilterOperator.IN).build().toQuery();
    }

    public static BoolQuery.Builder createExecutedFlowNodeFilterQuery(ExecutedFlowNodeFilterDataDto executedFlowNodeFilterData, BoolQuery.Builder boolQuery) {
        return ModelElementFilterQueryUtilOS.createExecutedFlowNodeFilterQuery(boolQuery, ModelElementFilterQueryUtilOS.nestedFieldReference("flowNodeId"), executedFlowNodeFilterData.getValues(), executedFlowNodeFilterData.getOperator());
    }

    public static Query createExecutedFlowNodeFilterQuery(ExecutedFlowNodeFilterDataDto executedFlowNodeFilterData, String nestedFieldReference, BoolQuery.Builder boolQueryBuilder) {
        return ModelElementFilterQueryUtilOS.createExecutedFlowNodeFilterQuery(boolQueryBuilder, nestedFieldReference, executedFlowNodeFilterData.getValues(), executedFlowNodeFilterData.getOperator()).build().toQuery();
    }

    public static BoolQuery.Builder createExecutedFlowNodeFilterQuery(BoolQuery.Builder boolQuery, String nestedFieldReference, List<String> flowNodeIds, MembershipFilterOperator operator) {
        Query termsQuery = QueryDSL.stringTerms((String)nestedFieldReference, flowNodeIds);
        if (MembershipFilterOperator.IN.equals((Object)operator)) {
            boolQuery.filter(termsQuery, new Query[0]);
        } else {
            boolQuery.filter(QueryDSL.not((Query[])new Query[]{termsQuery}), new Query[0]);
        }
        return boolQuery;
    }

    public static Query createFlowNodeDurationFilterQuery(FlowNodeDurationFiltersDataDto durationFilterData) {
        return ModelElementFilterQueryUtilOS.createFlowNodeDurationFilterQuery(durationFilterData, new BoolQuery.Builder()).build().toQuery();
    }

    public static BoolQuery.Builder createRunningFlowNodesOnlyFilterQuery(BoolQuery.Builder boolQueryBuilder) {
        return boolQueryBuilder.mustNot(QueryDSL.term((String)ModelElementFilterQueryUtilOS.nestedFieldReference("flowNodeType"), (String)"multiInstanceBody"), new Query[0]).mustNot(QueryDSL.exists((String)ModelElementFilterQueryUtilOS.nestedFieldReference("endDate")), new Query[0]);
    }

    public static BoolQuery.Builder createCompletedFlowNodesOnlyFilterQuery(BoolQuery.Builder boolQueryBuilder) {
        return boolQueryBuilder.mustNot(QueryDSL.term((String)ModelElementFilterQueryUtilOS.nestedFieldReference("flowNodeType"), (String)"multiInstanceBody"), new Query[0]).must(QueryDSL.term((String)ModelElementFilterQueryUtilOS.nestedFieldReference("canceled"), (boolean)false), new Query[0]).must(QueryDSL.exists((String)ModelElementFilterQueryUtilOS.nestedFieldReference("endDate")), new Query[0]);
    }

    public static BoolQuery.Builder createCanceledFlowNodesOnlyFilterQuery(BoolQuery.Builder boolQueryBuilder) {
        return boolQueryBuilder.mustNot(QueryDSL.term((String)ModelElementFilterQueryUtilOS.nestedFieldReference("flowNodeType"), (String)"multiInstanceBody"), new Query[0]).must(QueryDSL.term((String)ModelElementFilterQueryUtilOS.nestedFieldReference("canceled"), (boolean)true), new Query[0]);
    }

    public static BoolQuery.Builder createCompletedOrCanceledFlowNodesOnlyFilterQuery(BoolQuery.Builder boolQueryBuilder) {
        return boolQueryBuilder.mustNot(QueryDSL.term((String)ModelElementFilterQueryUtilOS.nestedFieldReference("flowNodeType"), (String)"multiInstanceBody"), new Query[0]).must(QueryDSL.exists((String)ModelElementFilterQueryUtilOS.nestedFieldReference("endDate")), new Query[0]);
    }

    public static BoolQuery.Builder createFlowNodeStartDateFilterQuery(FlowNodeDateFilterDataDto<?> filterData, ZoneId timezone) {
        return ModelElementFilterQueryUtilOS.createFlowNodeStartDateFilterQuery(filterData, timezone, new BoolQuery.Builder());
    }

    public static BoolQuery.Builder createFlowNodeStartDateFilterQuery(FlowNodeDateFilterDataDto<?> filterData, ZoneId timezone, BoolQuery.Builder queryBuilder) {
        return ModelElementFilterQueryUtilOS.createFlowNodeDateFilterQuery(filterData, timezone, queryBuilder, ModelElementFilterQueryUtilOS.nestedFieldReference("startDate"));
    }

    public static BoolQuery.Builder createFlowNodeEndDateFilterQuery(FlowNodeDateFilterDataDto<?> filterData, ZoneId timezone) {
        return ModelElementFilterQueryUtilOS.createFlowNodeDateFilterQuery(filterData, timezone, new BoolQuery.Builder(), ModelElementFilterQueryUtilOS.nestedFieldReference("endDate"));
    }

    public static BoolQuery.Builder createFlowNodeEndDateFilterQuery(FlowNodeDateFilterDataDto<?> filterData, ZoneId timezone, BoolQuery.Builder queryBuilder) {
        return ModelElementFilterQueryUtilOS.createFlowNodeDateFilterQuery(filterData, timezone, queryBuilder, ModelElementFilterQueryUtilOS.nestedFieldReference("endDate"));
    }

    private static BoolQuery.Builder createFlowNodeDateFilterQuery(FlowNodeDateFilterDataDto<?> filterData, ZoneId timezone, BoolQuery.Builder queryBuilder, String nestedDateField) {
        Optional<Query> optionalDateRangeQuery = DateFilterQueryUtilOS.createRangeQuery(filterData, nestedDateField, timezone);
        optionalDateRangeQuery.ifPresent(dateRangeQuery -> {
            if (CollectionUtils.isEmpty((Collection)filterData.getFlowNodeIds())) {
                queryBuilder.filter(dateRangeQuery, new Query[0]);
            } else {
                queryBuilder.minimumShouldMatch("1");
                filterData.getFlowNodeIds().forEach(flowNodeId -> queryBuilder.should(QueryDSL.and((Query[])new Query[]{QueryDSL.term((String)ModelElementFilterQueryUtilOS.nestedFieldReference("flowNodeId"), (String)flowNodeId), dateRangeQuery}), new Query[0]));
            }
        });
        return queryBuilder;
    }

    public static Query createAssigneeFilterQuery(IdentityLinkFilterDataDto assigneeFilter) {
        return ModelElementFilterQueryUtilOS.createIdentityLinkFilterQuery(assigneeFilter, "assignee", new BoolQuery.Builder()).build().toQuery();
    }

    private static BoolQuery.Builder createAssigneeFilterQuery(IdentityLinkFilterDataDto assigneeFilter, BoolQuery.Builder queryBuilder) {
        return ModelElementFilterQueryUtilOS.createIdentityLinkFilterQuery(assigneeFilter, "assignee", queryBuilder);
    }

    public static Query createCandidateGroupFilterQuery(IdentityLinkFilterDataDto candidateGroupFilter) {
        return ModelElementFilterQueryUtilOS.createIdentityLinkFilterQuery(candidateGroupFilter, "candidateGroups", new BoolQuery.Builder()).build().toQuery();
    }

    private static BoolQuery.Builder createCandidateGroupFilterQuery(IdentityLinkFilterDataDto candidateGroupFilter, BoolQuery.Builder queryBuilder) {
        return ModelElementFilterQueryUtilOS.createIdentityLinkFilterQuery(candidateGroupFilter, "candidateGroups", queryBuilder);
    }

    private static BoolQuery.Builder createIdentityLinkFilterQuery(IdentityLinkFilterDataDto identityFilter, String valueField, BoolQuery.Builder queryBuilder) {
        if (CollectionUtils.isEmpty((Collection)identityFilter.getValues())) {
            throw new OptimizeValidationException("Filter values are not allowed to be empty.");
        }
        AtomicBoolean includeNull = new AtomicBoolean(false);
        Set nonNullValues = identityFilter.getValues().stream().peek(value -> {
            if (value == null) {
                includeNull.set(true);
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        queryBuilder.must(ModelElementFilterQueryUtilOS.createUserTaskFlowNodeTypeFilter().build().toQuery(), new Query[0]);
        BoolQuery.Builder identityQueryBuilder = new BoolQuery.Builder().minimumShouldMatch("1");
        if (!nonNullValues.isEmpty()) {
            identityQueryBuilder.should(QueryDSL.stringTerms((String)ModelElementFilterQueryUtilOS.nestedFieldReference(valueField), nonNullValues), new Query[0]);
        }
        if (includeNull.get()) {
            identityQueryBuilder.should(QueryDSL.not((Query[])new Query[]{QueryDSL.exists((String)ModelElementFilterQueryUtilOS.nestedFieldReference(valueField))}), new Query[0]);
        }
        Query identityQuery = identityQueryBuilder.build().toQuery();
        if (MembershipFilterOperator.NOT_IN.equals((Object)identityFilter.getOperator())) {
            queryBuilder.mustNot(identityQuery, new Query[0]);
        } else {
            queryBuilder.must(identityQuery, new Query[0]);
        }
        return queryBuilder;
    }

    private static BoolQuery.Builder createFlowNodeDurationFilterQuery(FlowNodeDurationFiltersDataDto durationFilterData, BoolQuery.Builder queryBuilder) {
        queryBuilder.minimumShouldMatch("1");
        durationFilterData.forEach((flowNodeId, durationFilter) -> {
            Query particularFlowNodeQuery = QueryDSL.and((Query[])new Query[]{QueryDSL.term((String)ModelElementFilterQueryUtilOS.nestedFieldReference("flowNodeId"), (String)flowNodeId), new ScriptQuery.Builder().script(DurationScriptUtilOS.getDurationFilterScript(LocalDateUtil.getCurrentDateTime().toInstant().toEpochMilli(), ModelElementFilterQueryUtilOS.nestedFieldReference("totalDurationInMs"), ModelElementFilterQueryUtilOS.nestedFieldReference("startDate"), durationFilter)).build().toQuery()});
            queryBuilder.should(particularFlowNodeQuery, new Query[0]);
        });
        return queryBuilder;
    }

    private static void addFlowNodeStatusFilter(BoolQuery.Builder boolQueryBuilder, List<ProcessFilterDto<?>> filters) {
        filters.stream().filter(filter -> FilterApplicationLevel.VIEW.equals((Object)filter.getFilterLevel())).filter(filter -> FLOW_NODE_STATUS_VIEW_FILTER_INSTANCE_QUERIES.containsKey(filter.getClass())).forEach(filter -> boolQueryBuilder.filter(FLOW_NODE_STATUS_VIEW_FILTER_INSTANCE_QUERIES.get(filter.getClass()).apply(new BoolQuery.Builder()).build().toQuery(), new Query[0]));
    }

    private static void addFlowNodeDurationFilter(BoolQuery.Builder boolQueryBuilder, List<ProcessFilterDto<?>> filters) {
        ModelElementFilterQueryUtilOS.findAllViewLevelFiltersOfType(filters, FlowNodeDurationFilterDto.class).map(ProcessFilterDto::getData).forEach(durationFilterData -> boolQueryBuilder.filter(ModelElementFilterQueryUtilOS.createFlowNodeDurationFilterQuery(durationFilterData), new Query[0]));
    }

    private static void addAssigneeFilter(BoolQuery.Builder userTaskFilterBoolQuery, List<ProcessFilterDto<?>> filters) {
        ModelElementFilterQueryUtilOS.findAllViewLevelFiltersOfType(filters, AssigneeFilterDto.class).map(ProcessFilterDto::getData).forEach(assigneeFilterData -> userTaskFilterBoolQuery.filter(ModelElementFilterQueryUtilOS.createAssigneeFilterQuery(assigneeFilterData, new BoolQuery.Builder()).build().toQuery(), new Query[0]));
    }

    private static void addCandidateGroupFilter(BoolQuery.Builder userTaskFilterBoolQuery, List<ProcessFilterDto<?>> filters) {
        ModelElementFilterQueryUtilOS.findAllViewLevelFiltersOfType(filters, CandidateGroupFilterDto.class).map(ProcessFilterDto::getData).forEach(candidateFilterData -> userTaskFilterBoolQuery.filter(ModelElementFilterQueryUtilOS.createCandidateGroupFilterQuery(candidateFilterData, new BoolQuery.Builder()).build().toQuery(), new Query[0]));
    }

    private static void addFlowNodeIdFilter(BoolQuery.Builder boolQuery, List<ProcessFilterDto<?>> filters) {
        ModelElementFilterQueryUtilOS.findAllViewLevelFiltersOfType(filters, ExecutedFlowNodeFilterDto.class).map(ProcessFilterDto::getData).forEach(executedFlowNodeFilterData -> boolQuery.filter(ModelElementFilterQueryUtilOS.createExecutedFlowNodeFilterQuery(executedFlowNodeFilterData, new BoolQuery.Builder()).build().toQuery(), new Query[0]));
    }

    private static void addFlowNodeStartDateFilter(BoolQuery.Builder boolQueryBuilder, ZoneId timezone, List<ProcessFilterDto<?>> filters) {
        ModelElementFilterQueryUtilOS.findAllViewLevelFiltersOfType(filters, FlowNodeStartDateFilterDto.class).map(ProcessFilterDto::getData).forEach(flowNodeStartDateFilterData -> ModelElementFilterQueryUtilOS.createFlowNodeStartDateFilterQuery(flowNodeStartDateFilterData, timezone, boolQueryBuilder));
    }

    private static void addFlowNodeEndDateFilter(BoolQuery.Builder boolQuery, ZoneId timezone, List<ProcessFilterDto<?>> filters) {
        ModelElementFilterQueryUtilOS.findAllViewLevelFiltersOfType(filters, FlowNodeEndDateFilterDto.class).map(ProcessFilterDto::getData).forEach(flowNodeEndDateFilterData -> ModelElementFilterQueryUtilOS.createFlowNodeEndDateFilterQuery(flowNodeEndDateFilterData, timezone, boolQuery));
    }

    private static <T extends ProcessFilterDto<?>> Stream<T> findAllViewLevelFiltersOfType(List<ProcessFilterDto<?>> filters, Class<T> filterClass) {
        return filters.stream().filter(filter -> FilterApplicationLevel.VIEW.equals((Object)filter.getFilterLevel())).filter(filterClass::isInstance).map(filterClass::cast);
    }

    private static String nestedFieldReference(String fieldName) {
        return "flowNodeInstances." + fieldName;
    }

    private static BoolQuery.Builder createFlowNodeTypeFilterQuery(ProcessReportDataDto reportDataDto) {
        return ModelElementFilterQueryUtilOS.createFlowNodeTypeFilterQuery(reportDataDto.isUserTaskReport());
    }

    private static BoolQuery.Builder createFlowNodeTypeFilterQuery(boolean isUserTaskReport) {
        return isUserTaskReport ? ModelElementFilterQueryUtilOS.createUserTaskFlowNodeTypeFilter() : new BoolQuery.Builder();
    }
}

