/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.filter.util;

import io.camunda.optimize.dto.optimize.query.report.single.decision.filter.EvaluationDateFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.DateFilterDataDto;
import io.camunda.optimize.service.db.filter.FilterContext;
import io.camunda.optimize.service.db.os.client.dsl.AggregationDSL;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.report.context.DateAggregationContextOS;
import io.camunda.optimize.service.db.os.report.filter.QueryFilterOS;
import io.camunda.optimize.service.db.report.filter.util.DateHistogramFilterUtil;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import org.opensearch.client.opensearch._types.aggregations.ExtendedBounds;
import org.opensearch.client.opensearch._types.aggregations.FieldDateMath;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.RangeQuery;

public final class DateHistogramFilterUtilOS {
    private DateHistogramFilterUtilOS() {
    }

    public static Query createModelElementDateHistogramLimitingFilterQueryFor(DateAggregationContextOS context, DateTimeFormatter dateTimeFormatter) {
        return QueryDSL.filter((Query[])new Query[]{new RangeQuery.Builder().field(context.getDateField()).gte(QueryDSL.json((Object)dateTimeFormatter.format(context.getEarliestDate()))).lte(QueryDSL.json((Object)dateTimeFormatter.format(context.getLatestDate()))).format("yyyy-MM-dd'T'HH:mm:ss.SSSZ").build().toQuery()});
    }

    public static List<Query> createDecisionDateHistogramLimitingFilter(DateAggregationContextOS context) {
        return context.getDecisionQueryFilterEnhancer().getEvaluationDateQueryFilter().filterQueries(DateHistogramFilterUtilOS.evaluationDateFilter(context), context.getFilterContext());
    }

    private static List<DateFilterDataDto<?>> evaluationDateFilter(DateAggregationContextOS context) {
        return context.getDecisionQueryFilterEnhancer().extractFilters(context.getDecisionFilters(), EvaluationDateFilterDto.class);
    }

    public static Optional<ExtendedBounds<FieldDateMath>> extendBounds(DateAggregationContextOS context, DateTimeFormatter dateFormatter) {
        return DateHistogramFilterUtilOS.getExtendedBoundsFromDateFilters(DateHistogramFilterUtilOS.evaluationDateFilter(context), dateFormatter, context);
    }

    public static List<Query> createFilterBoolQueryBuilder(List<DateFilterDataDto<?>> filters, QueryFilterOS<DateFilterDataDto<?>> queryFilter, FilterContext filterContext) {
        return queryFilter.filterQueries(filters, filterContext);
    }

    public static Optional<ExtendedBounds<FieldDateMath>> getExtendedBoundsFromDateFilters(List<DateFilterDataDto<?>> dateFilters, DateTimeFormatter dateFormatter, DateAggregationContextOS context) {
        if (dateFilters.isEmpty()) {
            return Optional.empty();
        }
        Optional<OffsetDateTime> filterStart = DateHistogramFilterUtil.getMinDateFilterOffsetDateTime(dateFilters);
        OffsetDateTime filterEnd = DateHistogramFilterUtil.getMaxDateFilterOffsetDateTime(dateFilters);
        return filterStart.map(start -> new ExtendedBounds.Builder().min((Object)AggregationDSL.fieldDateMath((String)dateFormatter.format(start.atZoneSameInstant(context.getTimezone())))).max((Object)AggregationDSL.fieldDateMath((String)dateFormatter.format(filterEnd.atZoneSameInstant(context.getTimezone())))).build());
    }
}

