/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.filter;

import io.camunda.optimize.dto.optimize.query.report.single.process.filter.data.ExecutingFlowNodeFilterDataDto;
import io.camunda.optimize.service.db.filter.FilterContext;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.report.filter.QueryFilterOS;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.List;
import org.opensearch.client.opensearch._types.query_dsl.ChildScoreMode;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class ExecutingFlowNodeQueryFilterOS
implements QueryFilterOS<ExecutingFlowNodeFilterDataDto> {
    @Override
    public List<Query> filterQueries(List<ExecutingFlowNodeFilterDataDto> flowNodeFilter, FilterContext filterContext) {
        return flowNodeFilter.stream().map(this::createFilterQueryBuilder).toList();
    }

    private Query createFilterQueryBuilder(ExecutingFlowNodeFilterDataDto flowNodeFilter) {
        List<Query> queries = flowNodeFilter.getValues().stream().map(flowNodeId -> QueryDSL.nested((String)"flowNodeInstances", (Query)QueryDSL.and((Query[])new Query[]{QueryDSL.term((String)this.nestedActivityIdFieldLabel(), (String)flowNodeId), QueryDSL.not((Query[])new Query[]{QueryDSL.exists((String)this.nestedEndDateFieldLabel())})}), (ChildScoreMode)ChildScoreMode.None)).toList();
        return QueryDSL.or(queries);
    }

    private String nestedActivityIdFieldLabel() {
        return "flowNodeInstances.flowNodeId";
    }

    private String nestedEndDateFieldLabel() {
        return "flowNodeInstances.endDate";
    }
}

