/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.filter;

import io.camunda.optimize.dto.optimize.query.report.single.filter.data.FilterOperator;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.OperatorMultipleValuesFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.DateFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.BooleanVariableFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.DateVariableFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.OperatorMultipleValuesVariableFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.StringVariableFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.VariableFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.data.BooleanVariableFilterSubDataDto;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.service.db.filter.FilterContext;
import io.camunda.optimize.service.db.filter.util.OperatorMultipleValuesVariableFilterDataDtoUtil;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.report.filter.AbstractVariableQueryFilterOS;
import io.camunda.optimize.service.db.os.report.filter.QueryFilterOS;
import io.camunda.optimize.service.db.os.report.filter.util.DateFilterQueryUtilOS;
import io.camunda.optimize.service.util.DecisionVariableHelper;
import io.camunda.optimize.service.util.ValidationHelper;
import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.ChildScoreMode;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DecisionVariableQueryFilterOS
extends AbstractVariableQueryFilterOS
implements QueryFilterOS<VariableFilterDataDto<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(DecisionVariableQueryFilterOS.class);
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    abstract String getVariablePath();

    @Override
    public List<Query> filterQueries(List<VariableFilterDataDto<?>> variableFilters, FilterContext filterContext) {
        return variableFilters == null ? List.of() : variableFilters.stream().map(variable -> this.createFilterQuery((VariableFilterDataDto<?>)variable, filterContext.getTimezone())).toList();
    }

    private Query createFilterQuery(VariableFilterDataDto<?> dto, ZoneId timezone) {
        ValidationHelper.ensureNotNull("Variable filter data", dto.getData());
        switch (dto.getType()) {
            case BOOLEAN: {
                BooleanVariableFilterDataDto booleanVarDto = (BooleanVariableFilterDataDto)dto;
                return this.createBooleanQuery(booleanVarDto);
            }
            case STRING: {
                StringVariableFilterDataDto stringVarDto = (StringVariableFilterDataDto)dto;
                return this.createStringQuery(stringVarDto);
            }
            case INTEGER: 
            case DOUBLE: 
            case SHORT: 
            case LONG: {
                OperatorMultipleValuesVariableFilterDataDto numericVarDto = (OperatorMultipleValuesVariableFilterDataDto)dto;
                return this.createNumericQuery(numericVarDto);
            }
            case DATE: {
                DateVariableFilterDataDto dateVarDto = (DateVariableFilterDataDto)dto;
                return this.createDateQuery(dateVarDto, timezone);
            }
        }
        this.logger.warn("Could not filter for variables! Type [{}] is not supported for variable filters. Ignoring filter.", (Object)dto.getType());
        return QueryDSL.matchAll();
    }

    @Override
    protected Query createContainsOneOfTheGivenStringsQuery(StringVariableFilterDataDto dto) {
        Query containOneOfTheGivenStrings = this.createContainsOneOfTheGivenStringsQuery(dto.getName(), ((OperatorMultipleValuesFilterDataDto)dto.getData()).getValues());
        if (FilterOperator.NOT_CONTAINS.equals((Object)((OperatorMultipleValuesFilterDataDto)dto.getData()).getOperator())) {
            return QueryDSL.not((Query[])new Query[]{containOneOfTheGivenStrings});
        }
        return containOneOfTheGivenStrings;
    }

    @Override
    protected Query createContainsOneOfTheGivenStringsQuery(String variableId, List<String> values) {
        BoolQuery.Builder variableFilterBuilder = new BoolQuery.Builder().minimumShouldMatch("1");
        values.stream().filter(Objects::nonNull).forEach(stringVal -> variableFilterBuilder.should(this.createContainsGivenStringQuery(variableId, (String)stringVal), new Query[0]));
        boolean hasNullValues = values.stream().anyMatch(Objects::isNull);
        if (hasNullValues) {
            variableFilterBuilder.should(this.createFilterForUndefinedOrNullQuery(variableId), new Query[0]);
        }
        return variableFilterBuilder.build().toQuery();
    }

    @Override
    protected Query createContainsGivenStringQuery(String variableId, String valueToContain) {
        String lowerCaseValue = valueToContain.toLowerCase();
        Query filter = lowerCaseValue.length() > 10 ? QueryDSL.wildcardQuery((String)DecisionVariableHelper.getValueSearchField(this.getVariablePath(), "lowercaseField"), (String)DecisionVariableHelper.buildWildcardQuery(lowerCaseValue)) : QueryDSL.term((String)DecisionVariableHelper.getValueSearchField(this.getVariablePath(), "nGramField"), (String)lowerCaseValue);
        Query containsVariableString = QueryDSL.and((Query[])new Query[]{filter, QueryDSL.term((String)this.getVariableIdField(), (String)variableId)});
        return QueryDSL.nested((String)this.getVariablePath(), (Query)containsVariableString, (ChildScoreMode)ChildScoreMode.None);
    }

    @Override
    protected Query createEqualsOneOrMoreValuesQuery(OperatorMultipleValuesVariableFilterDataDto dto) {
        Query variableFilterBuilder = this.createMultiValueVariableFilterQuery(this.getVariableId((VariableFilterDataDto<?>)dto), dto.getType(), ((OperatorMultipleValuesFilterDataDto)dto.getData()).getValues(), QueryDSL::stringTerms);
        if (FilterOperator.NOT_IN.equals((Object)((OperatorMultipleValuesFilterDataDto)dto.getData()).getOperator())) {
            return QueryDSL.not((Query[])new Query[]{variableFilterBuilder});
        }
        return variableFilterBuilder;
    }

    @Override
    protected Query createBooleanQuery(BooleanVariableFilterDataDto dto) {
        ValidationHelper.ensureCollectionNotEmpty("boolean filter value", ((BooleanVariableFilterSubDataDto)dto.getData()).getValues());
        return this.createMultiValueVariableFilterQuery(this.getVariableId((VariableFilterDataDto<?>)dto), dto.getType(), ((BooleanVariableFilterSubDataDto)dto.getData()).getValues(), QueryDSL::boolTerms);
    }

    private <A> Query createMultiValueVariableFilterQuery(String variableId, VariableType variableType, List<A> values, BiFunction<String, List<A>, Query> termsQuery) {
        BoolQuery.Builder variableFilterBuilder = new BoolQuery.Builder().minimumShouldMatch("1");
        String nestedVariableIdFieldLabel = this.getVariableIdField();
        String nestedVariableValueFieldLabel = this.getVariableValueFieldForType(variableType);
        List<Object> nonNullValues = values.stream().filter(Objects::nonNull).toList();
        if (!nonNullValues.isEmpty()) {
            variableFilterBuilder.should(QueryDSL.nested((String)this.getVariablePath(), (Query)QueryDSL.and((Query[])new Query[]{QueryDSL.term((String)nestedVariableIdFieldLabel, (String)variableId), termsQuery.apply(nestedVariableValueFieldLabel, nonNullValues)}), (ChildScoreMode)ChildScoreMode.None), new Query[0]);
        }
        if (nonNullValues.size() < values.size()) {
            variableFilterBuilder.should(this.createFilterForUndefinedOrNullQuery(variableId), new Query[0]);
        }
        return variableFilterBuilder.build().toQuery();
    }

    @Override
    protected Query createNumericQuery(OperatorMultipleValuesVariableFilterDataDto dto) {
        OperatorMultipleValuesVariableFilterDataDtoUtil.validateMultipleValuesFilterDataDto(dto);
        String nestedVariableValueFieldLabel = this.getVariableValueFieldForType(dto.getType());
        OperatorMultipleValuesFilterDataDto data = (OperatorMultipleValuesFilterDataDto)dto.getData();
        Query basicQuery = QueryDSL.term((String)this.getVariableIdField(), (String)this.getVariableId((VariableFilterDataDto<?>)dto));
        if (data.getValues().isEmpty()) {
            this.logger.warn("Could not filter for variables! No values provided for operator [{}] and type [{}]. Ignoring filter.", (Object)data.getOperator(), (Object)dto.getType());
            return basicQuery;
        }
        Function<Query, Query> nestedAnd = query -> QueryDSL.nested((String)this.getVariablePath(), (Query)QueryDSL.and((Query[])new Query[]{query, basicQuery}), (ChildScoreMode)ChildScoreMode.None);
        Object value = OperatorMultipleValuesVariableFilterDataDtoUtil.retrieveValue(dto);
        return switch (data.getOperator()) {
            case FilterOperator.IN, FilterOperator.NOT_IN -> this.createEqualsOneOrMoreValuesQuery(dto);
            case FilterOperator.LESS_THAN -> nestedAnd.apply(QueryDSL.lt((String)nestedVariableValueFieldLabel, (Object)value));
            case FilterOperator.GREATER_THAN -> nestedAnd.apply(QueryDSL.gt((String)nestedVariableValueFieldLabel, (Object)value));
            case FilterOperator.LESS_THAN_EQUALS -> nestedAnd.apply(QueryDSL.lte((String)nestedVariableValueFieldLabel, (Object)value));
            case FilterOperator.GREATER_THAN_EQUALS -> nestedAnd.apply(QueryDSL.gte((String)nestedVariableValueFieldLabel, (Object)value));
            default -> {
                this.logger.warn("Could not filter for variables! Operator [{}] is not supported for type [{}]. Ignoring filter.", (Object)data.getOperator(), (Object)dto.getType());
                yield QueryDSL.nested((String)this.getVariablePath(), (Query)basicQuery, (ChildScoreMode)ChildScoreMode.None);
            }
        };
    }

    @Override
    protected Query createDateQuery(DateVariableFilterDataDto dto, ZoneId timezone) {
        BoolQuery.Builder dateFilterBuilder = new BoolQuery.Builder().minimumShouldMatch("1");
        if (((DateFilterDataDto)dto.getData()).isIncludeUndefined()) {
            dateFilterBuilder.should(this.createFilterForUndefinedOrNullQuery(this.getVariableId((VariableFilterDataDto<?>)dto)), new Query[0]);
        } else if (((DateFilterDataDto)dto.getData()).isExcludeUndefined()) {
            dateFilterBuilder.should(this.createExcludeUndefinedOrNullQuery(this.getVariableId((VariableFilterDataDto<?>)dto)), new Query[0]);
        }
        List<Query> rangeQueries = DateFilterQueryUtilOS.createRangeQueries(Collections.singletonList((DateFilterDataDto)dto.getData()), this.getVariableValueFieldForType(dto.getType()), timezone);
        if (!rangeQueries.isEmpty()) {
            Query dateValueFilterQuery = new BoolQuery.Builder().must(QueryDSL.term((String)this.getVariableIdField(), (String)this.getVariableId((VariableFilterDataDto<?>)dto)), new Query[0]).must(rangeQueries).build().toQuery();
            dateFilterBuilder.should(QueryDSL.nested((String)this.getVariablePath(), (Query)dateValueFilterQuery, (ChildScoreMode)ChildScoreMode.None), new Query[0]);
        }
        return dateFilterBuilder.build().toQuery();
    }

    private Query createFilterForUndefinedOrNullQuery(String variableId) {
        return new BoolQuery.Builder().should(QueryDSL.not((Query[])new Query[]{QueryDSL.nested((String)this.getVariablePath(), (Query)QueryDSL.term((String)this.getVariableIdField(), (String)variableId), (ChildScoreMode)ChildScoreMode.None)}), new Query[0]).should(QueryDSL.nested((String)this.getVariablePath(), (Query)new BoolQuery.Builder().must(QueryDSL.term((String)this.getVariableIdField(), (String)variableId), new Query[0]).mustNot(QueryDSL.exists((String)DecisionVariableHelper.getVariableStringValueField(this.getVariablePath())), new Query[0]).build().toQuery(), (ChildScoreMode)ChildScoreMode.None), new Query[0]).minimumShouldMatch("1").build().toQuery();
    }

    private Query createExcludeUndefinedOrNullQuery(String variableId) {
        return QueryDSL.nested((String)this.getVariablePath(), (Query)QueryDSL.and((Query[])new Query[]{QueryDSL.term((String)this.getVariableIdField(), (String)variableId), QueryDSL.exists((String)DecisionVariableHelper.getVariableStringValueField(this.getVariablePath()))}), (ChildScoreMode)ChildScoreMode.None);
    }

    private String getVariableId(VariableFilterDataDto<?> dto) {
        return dto.getName();
    }

    private String getVariableValueFieldForType(VariableType type) {
        return DecisionVariableHelper.getVariableValueFieldForType(this.getVariablePath(), type);
    }

    private String getVariableIdField() {
        return DecisionVariableHelper.getVariableClauseIdField(this.getVariablePath());
    }
}

