/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.aggregations;

import io.camunda.optimize.dto.optimize.query.report.single.configuration.AggregationDto;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.AggregationType;
import io.camunda.optimize.service.db.os.report.aggregations.AggregationStrategyOS;
import io.camunda.optimize.service.db.report.interpreter.util.AggregationResultMappingUtil;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.PercentilesAggregation;
import org.opensearch.client.opensearch._types.aggregations.TDigestPercentilesAggregate;

public class PercentileAggregationOS
extends AggregationStrategyOS {
    private static final String PERCENTILE_AGGREGATION = "percentileAggregation";
    private Double percentileValue;

    public PercentileAggregationOS(Double percentileValue) {
        this.percentileValue = percentileValue;
    }

    public PercentileAggregationOS() {
    }

    @Override
    public AggregationDto getAggregationType() {
        return new AggregationDto(AggregationType.PERCENTILE, this.percentileValue);
    }

    @Override
    public Double getValueForAggregation(String customIdentifier, Map<String, Aggregate> aggs) {
        String aggregationName = this.createAggregationName(customIdentifier, String.valueOf(this.percentileValue), PERCENTILE_AGGREGATION);
        TDigestPercentilesAggregate percentiles = aggs.get(aggregationName).tdigestPercentiles();
        return this.mapToDoubleOrNull(percentiles, this.percentileValue);
    }

    @Override
    public Pair<String, Aggregation> createAggregation(String customIdentifier, Script script, String ... fields) {
        PercentilesAggregation.Builder builder = ((PercentilesAggregation.Builder)new PercentilesAggregation.Builder().script(script)).tdigest(b -> b.compression(Integer.valueOf(9999))).percents(this.percentileValue, new Double[0]);
        AggregationResultMappingUtil.firstField(fields).ifPresent(x$0 -> {
            PercentilesAggregation.Builder cfr_ignored_0 = (PercentilesAggregation.Builder)builder.field(x$0);
        });
        return Pair.of((Object)this.createAggregationName(customIdentifier, String.valueOf(this.percentileValue), PERCENTILE_AGGREGATION), (Object)builder.build()._toAggregation());
    }

    private Double mapToDoubleOrNull(TDigestPercentilesAggregate aggregation, double percentileValue) {
        Double percentile = Optional.ofNullable(aggregation.values()).filter(h -> h.keyed().get(Double.toString(percentileValue)) != null).map(h -> Double.parseDouble((String)h.keyed().get(Double.toString(percentileValue)))).orElse(null);
        return percentile == null || Double.isNaN(percentile) || Double.isInfinite(percentile) ? null : percentile;
    }
}

