/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.reader;

import io.camunda.optimize.dto.optimize.query.alert.AlertDefinitionDto;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.client.dsl.RequestDSL;
import io.camunda.optimize.service.db.reader.AlertReader;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.List;
import java.util.Optional;
import org.opensearch.client.opensearch.core.GetResponse;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class AlertReaderOS
implements AlertReader {
    private static final Logger LOG = LoggerFactory.getLogger(AlertReaderOS.class);
    private final OptimizeOpenSearchClient osClient;
    private final ConfigurationService configurationService;

    public AlertReaderOS(OptimizeOpenSearchClient osClient, ConfigurationService configurationService) {
        this.osClient = osClient;
        this.configurationService = configurationService;
    }

    @Override
    public long getAlertCount() {
        return this.osClient.count("alert", "Was not able to retrieve alert count!");
    }

    @Override
    public List<AlertDefinitionDto> getStoredAlerts() {
        LOG.debug("getting all stored alerts");
        SearchRequest.Builder requestBuilder = RequestDSL.searchRequestBuilder((String[])new String[]{"alert"}).query(QueryDSL.matchAll()).size(Integer.valueOf(1000));
        return this.osClient.scrollValues(requestBuilder, AlertDefinitionDto.class);
    }

    @Override
    public Optional<AlertDefinitionDto> getAlert(String alertId) {
        LOG.debug("Fetching alert with id [{}]", (Object)alertId);
        String errorMsg = String.format("Could not fetch alert with id [%s]", alertId);
        GetResponse result = this.osClient.get("alert", alertId, AlertDefinitionDto.class, errorMsg);
        return result.found() ? Optional.ofNullable((AlertDefinitionDto)result.source()) : Optional.empty();
    }

    @Override
    public List<AlertDefinitionDto> getAlertsForReport(String reportId) {
        LOG.debug("Fetching first {} alerts using report with id {}", (Object)1000, (Object)reportId);
        SearchRequest.Builder requestBuilder = RequestDSL.searchRequestBuilder((String[])new String[]{"alert"}).query(QueryDSL.term((String)"reportId", (String)reportId)).size(Integer.valueOf(1000));
        return this.osClient.searchValues(requestBuilder, AlertDefinitionDto.class);
    }

    @Override
    public List<AlertDefinitionDto> getAlertsForReports(List<String> reportIds) {
        LOG.debug("Fetching first {} alerts using reports with ids {}", (Object)1000, reportIds);
        SearchRequest.Builder requestBuilder = RequestDSL.searchRequestBuilder((String[])new String[]{"alert"}).query(QueryDSL.stringTerms((String)"reportId", reportIds)).size(Integer.valueOf(1000));
        return this.osClient.searchValues(requestBuilder, AlertDefinitionDto.class);
    }
}

