/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os;

import io.camunda.optimize.service.db.os.ExtendedOpenSearchClient;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.schema.OpenSearchSchemaManager;
import io.camunda.optimize.service.db.schema.OptimizeIndexNameService;
import io.camunda.optimize.service.util.BackoffCalculator;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import io.camunda.optimize.upgrade.os.OpenSearchClientBuilder;
import io.camunda.search.connect.plugin.PluginRepository;
import java.io.IOException;
import org.opensearch.client.opensearch.OpenSearchAsyncClient;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;

@Conditional(value={OpenSearchCondition.class})
public final class OptimizeOpenSearchClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(OptimizeOpenSearchClientFactory.class);

    private OptimizeOpenSearchClientFactory() {
    }

    public static OptimizeOpenSearchClient create(ConfigurationService configurationService, OptimizeIndexNameService optimizeIndexNameService, OpenSearchSchemaManager openSearchSchemaManager, BackoffCalculator backoffCalculator, PluginRepository pluginRepository) throws IOException {
        LOG.info("Creating OpenSearch connection...");
        ExtendedOpenSearchClient openSearchClient = OpenSearchClientBuilder.buildOpenSearchClientFromConfig((ConfigurationService)configurationService, (PluginRepository)pluginRepository);
        OpenSearchAsyncClient openSearchAsyncClient = OpenSearchClientBuilder.buildOpenSearchAsyncClientFromConfig((ConfigurationService)configurationService, (PluginRepository)pluginRepository);
        OptimizeOpenSearchClientFactory.waitForOpenSearch((OpenSearchClient)openSearchClient, backoffCalculator);
        LOG.info("OpenSearch cluster successfully started");
        OptimizeOpenSearchClient osClient = new OptimizeOpenSearchClient(openSearchClient, openSearchAsyncClient, optimizeIndexNameService);
        openSearchSchemaManager.validateDatabaseMetadata(osClient);
        openSearchSchemaManager.initializeSchema(osClient);
        return osClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForOpenSearch(OpenSearchClient osClient, BackoffCalculator backoffCalculator) throws IOException {
        boolean isConnected = false;
        int connectionAttempts = 0;
        while (!isConnected) {
            ++connectionAttempts;
            try {
                isConnected = OptimizeOpenSearchClientFactory.getNumberOfClusterNodes(osClient) > 0;
            }
            catch (Exception e) {
                String errorMessage = "Can't connect to any OpenSearch node {}. Please check the connection!";
                if (connectionAttempts < 10) {
                    LOG.warn("Can't connect to any OpenSearch node {}. Please check the connection!", (Object)osClient.nodes());
                    continue;
                }
                LOG.error("Can't connect to any OpenSearch node {}. Please check the connection!", (Object)osClient.nodes(), (Object)e);
            }
            finally {
                if (isConnected) continue;
                long sleepTime = backoffCalculator.calculateSleepTime();
                LOG.info("No OpenSearch nodes available, waiting [{}] ms to retry connecting", (Object)sleepTime);
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    LOG.warn("Got interrupted while waiting to retry connecting to OpenSearch.", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private static int getNumberOfClusterNodes(OpenSearchClient openSearchClient) throws IOException {
        return openSearchClient.cluster().health().numberOfNodes();
    }
}

