/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.writer.usertask;

import com.google.common.collect.ImmutableMap;
import io.camunda.optimize.dto.optimize.importing.UserTaskIdentityOperationType;
import java.util.Map;
import org.apache.commons.text.StringSubstitutor;

public final class UserTaskDurationScriptUtil {
    private UserTaskDurationScriptUtil() {
    }

    public static String createUpdateUserTaskMetricsScript() {
        StringSubstitutor substitutor = new StringSubstitutor((Map)ImmutableMap.builder().put((Object)"flowNodesField", (Object)"flowNodeInstances").put((Object)"flowNodeTypeField", (Object)"flowNodeType").put((Object)"userTaskInstanceIdField", (Object)"userTaskInstanceId").put((Object)"userTaskFlowNodeType", (Object)"userTask").put((Object)"assigneeOperationsField", (Object)"assigneeOperations").put((Object)"startDateField", (Object)"startDate").put((Object)"endDateField", (Object)"endDate").put((Object)"idleDurationInMsField", (Object)"idleDurationInMs").put((Object)"workDurationInMsField", (Object)"workDurationInMs").put((Object)"totalDurationInMsField", (Object)"totalDurationInMs").put((Object)"canceledField", (Object)"canceled").put((Object)"operationTypeClaim", (Object)UserTaskIdentityOperationType.CLAIM_OPERATION_TYPE.getId()).put((Object)"operationTypeUnclaim", (Object)UserTaskIdentityOperationType.UNCLAIM_OPERATION_TYPE.getId()).put((Object)"dateFormatPattern", (Object)"yyyy-MM-dd'T'HH:mm:ss.SSSZ").build());
        return substitutor.replace("def updatedUserTaskIds = params.${flowNodesField}.stream() .filter(flowNode -> flowNode.${flowNodeTypeField}.equalsIgnoreCase(\"${userTaskFlowNodeType}\")) .map(flowNode -> flowNode.${userTaskInstanceIdField}) .collect(Collectors.toList());\nif (!updatedUserTaskIds.isEmpty() && ctx._source.${flowNodesField} != null) {\n def dateFormatter = new SimpleDateFormat(\"${dateFormatPattern}\");\n for (def currentTask : ctx._source.${flowNodesField}) {\n if (!currentTask.${flowNodeTypeField}.equalsIgnoreCase(\"${userTaskFlowNodeType}\")   || (currentTask.${flowNodeTypeField}.equalsIgnoreCase(\"${userTaskFlowNodeType}\")   && !updatedUserTaskIds.contains(currentTask.${userTaskInstanceIdField}))) {\n   continue;\n }\n def totalWorkTimeInMs = 0;\n def totalIdleTimeInMs = 0;\n def workTimeHasChanged = false;\n def idleTimeHasChanged = false;\n if (currentTask.${assigneeOperationsField} != null && !currentTask.${assigneeOperationsField}.isEmpty()) {\n   def allUnclaimTimestamps = currentTask.${assigneeOperationsField}.stream()\n     .filter(operation -> \"${operationTypeUnclaim}\".equals(operation.operationType))\n     .map(operation -> operation.timestamp)\n     .map(dateFormatter::parse)     .collect(Collectors.toList());\n   Optional.ofNullable(currentTask.${startDateField})     .map(dateFormatter::parse)\n     .ifPresent(startDate -> allUnclaimTimestamps.add(startDate));\n   Optional.ofNullable(currentTask.${endDateField})     .map(dateFormatter::parse)\n     .ifPresent(endDate -> allUnclaimTimestamps.add(endDate));\n   allUnclaimTimestamps.sort(Comparator.naturalOrder());\n   def allClaimTimestamps = currentTask.${assigneeOperationsField}.stream()\n     .filter(operation -> \"${operationTypeClaim}\".equals(operation.operationType))\n     .map(operation -> operation.timestamp)\n     .map(dateFormatter::parse)\n     .sorted(Comparator.naturalOrder())\n     .collect(Collectors.toList());\n   for (def i = 0; i < allUnclaimTimestamps.size() &&  i < allClaimTimestamps.size(); i++) {\n     def unclaimDate = allUnclaimTimestamps.get(i);\n     def claimDate= allClaimTimestamps.get(i);\n     def idleTimeToAdd = claimDate.getTime() - unclaimDate.getTime();\n     totalIdleTimeInMs = totalIdleTimeInMs + idleTimeToAdd;\n     idleTimeHasChanged = true;\n   }\n   for (def i = 0; i < allUnclaimTimestamps.size() - 1 &&  i < allClaimTimestamps.size(); i++) {\n     def claimDate = allClaimTimestamps.get(i);\n     def unclaimDate = allUnclaimTimestamps.get(i + 1);\n     def workTimeToAdd = unclaimDate.getTime() - claimDate.getTime();\n     totalWorkTimeInMs = totalWorkTimeInMs + workTimeToAdd;\n     workTimeHasChanged = true;\n   }\n   if (allUnclaimTimestamps.size() - allClaimTimestamps.size() == 2) {\n     def lastUnclaim = allUnclaimTimestamps.get(allUnclaimTimestamps.size() - 1);\n     def secondToLastUnclaim = allUnclaimTimestamps.get(allUnclaimTimestamps.size() - 2);\n     totalIdleTimeInMs = totalIdleTimeInMs + (lastUnclaim.getTime() - secondToLastUnclaim.getTime());\n     idleTimeHasChanged = true;\n   }\n }\n else if (currentTask.${totalDurationInMsField} != null) {\n   def wasCanceled = Boolean.TRUE.equals(currentTask.${canceledField});\n   if (wasCanceled) {\n     totalIdleTimeInMs = currentTask.${totalDurationInMsField};\n     totalWorkTimeInMs = 0;\n   } else {\n     totalIdleTimeInMs = 0;\n     totalWorkTimeInMs = currentTask.${totalDurationInMsField};\n   }\n   workTimeHasChanged = true;\n   idleTimeHasChanged = true;\n }\n if (idleTimeHasChanged) {\n   currentTask.${idleDurationInMsField} = totalIdleTimeInMs;\n }\n if (workTimeHasChanged) {\n   currentTask.${workDurationInMsField} = totalWorkTimeInMs;\n }\n }\n}\n");
    }
}

