/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.writer;

import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.json.JsonData;
import io.camunda.optimize.dto.optimize.query.TerminatedUserSessionDto;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeIndexRequestBuilderES;
import io.camunda.optimize.service.db.repository.es.TaskRepositoryES;
import io.camunda.optimize.service.db.writer.TerminatedUserSessionWriter;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.io.IOException;
import java.time.OffsetDateTime;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class TerminatedUserSessionWriterES
extends TerminatedUserSessionWriter {
    private final OptimizeElasticsearchClient esClient;
    private final TaskRepositoryES taskRepositoryES;

    public TerminatedUserSessionWriterES(OptimizeElasticsearchClient esClient, TaskRepositoryES taskRepositoryES) {
        this.esClient = esClient;
        this.taskRepositoryES = taskRepositoryES;
    }

    @Override
    protected void performWritingTerminatedUserSession(TerminatedUserSessionDto sessionDto) throws IOException {
        this.esClient.index(OptimizeIndexRequestBuilderES.of(b -> b.optimizeIndex(this.esClient, "terminated-user-session").id(sessionDto.getId()).refresh(Refresh.True).document((Object)sessionDto)));
    }

    @Override
    protected void performDeleteTerminatedUserSessionOlderThan(OffsetDateTime timestamp) {
        Query filterQuery = Query.of(b -> b.bool(bb -> bb.filter(f -> f.range(r -> r.field("terminationTimestamp").lt(JsonData.of((Object)timestamp)).format("yyyy-MM-dd'T'HH:mm:ss.SSSZ")))));
        this.taskRepositoryES.tryDeleteByQueryRequest(filterQuery, String.format("terminated user sessions with timestamp older than %s", timestamp), true, "terminated-user-session");
    }
}

