/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.writer;

import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.InlineScript;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.Result;
import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.ScriptLanguage;
import co.elastic.clients.elasticsearch._types.query_dsl.ChildScoreMode;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.DeleteResponse;
import co.elastic.clients.elasticsearch.core.IndexResponse;
import co.elastic.clients.elasticsearch.core.UpdateResponse;
import co.elastic.clients.json.JsonData;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.RoleType;
import io.camunda.optimize.dto.optimize.query.collection.CollectionDefinitionDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionDefinitionUpdateDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionRoleRequestDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionRoleUpdateRequestDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionScopeEntryDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionScopeEntryUpdateDto;
import io.camunda.optimize.rest.exceptions.NotFoundException;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeDeleteRequestBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeIndexRequestBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeUpdateRequestBuilderES;
import io.camunda.optimize.service.db.es.writer.ElasticsearchWriterUtil;
import io.camunda.optimize.service.db.repository.es.TaskRepositoryES;
import io.camunda.optimize.service.db.schema.index.CollectionIndex;
import io.camunda.optimize.service.db.writer.CollectionWriter;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.exceptions.conflict.OptimizeCollectionConflictException;
import io.camunda.optimize.service.exceptions.conflict.OptimizeConflictException;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class CollectionWriterES
implements CollectionWriter {
    private static final Logger LOG = LoggerFactory.getLogger(CollectionWriterES.class);
    private final OptimizeElasticsearchClient esClient;
    private final ObjectMapper objectMapper;
    private final DateTimeFormatter formatter;
    private final TaskRepositoryES taskRepositoryES;

    public CollectionWriterES(OptimizeElasticsearchClient esClient, ObjectMapper objectMapper, DateTimeFormatter formatter, TaskRepositoryES taskRepositoryES) {
        this.esClient = esClient;
        this.objectMapper = objectMapper;
        this.formatter = formatter;
        this.taskRepositoryES = taskRepositoryES;
    }

    @Override
    public void updateCollection(CollectionDefinitionUpdateDto collection, String id) {
        LOG.debug("Updating collection with id [{}] in Elasticsearch", (Object)id);
        try {
            UpdateResponse updateResponse = this.esClient.update(new OptimizeUpdateRequestBuilderES().optimizeIndex(this.esClient, new String[]{"collection"}).id(id).doc((Object)collection).refresh(Refresh.True).retryOnConflict(Integer.valueOf(5)).build(), CollectionDefinitionUpdateDto.class);
            if (!updateResponse.shards().failures().isEmpty()) {
                LOG.error("Was not able to update collection with id [{}] and name [{}].", (Object)id, (Object)collection.getName());
                throw new OptimizeRuntimeException("Was not able to update collection!");
            }
        }
        catch (IOException e) {
            String errorMessage = String.format("Was not able to update collection with id [%s] and name [%s].", id, collection.getName());
            LOG.error(errorMessage, (Throwable)e);
            throw new OptimizeRuntimeException(errorMessage, (Throwable)e);
        }
        catch (ElasticsearchException e) {
            String errorMessage = String.format("Was not able to update collection with id [%s] and name [%s]. Collection does not exist!", id, collection.getName());
            LOG.error(errorMessage, (Throwable)e);
            throw new NotFoundException(errorMessage, (Throwable)e);
        }
    }

    @Override
    public void deleteCollection(String collectionId) {
        DeleteResponse deleteResponse;
        LOG.debug("Deleting collection with id [{}]", (Object)collectionId);
        try {
            deleteResponse = this.esClient.delete(OptimizeDeleteRequestBuilderES.of(d -> d.optimizeIndex(this.esClient, "collection").id(collectionId).refresh(Refresh.True)));
        }
        catch (IOException e) {
            String reason = String.format("Could not delete collection with id [%s]. ", collectionId);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        if (!deleteResponse.result().equals((Object)Result.Deleted)) {
            String message = String.format("Could not delete collection with id [%s]. Collection does not exist. Maybe it was already deleted by someone else?", collectionId);
            LOG.error(message);
            throw new NotFoundException(message);
        }
    }

    @Override
    public void addScopeEntriesToCollection(String userId, String collectionId, List<CollectionScopeEntryDto> scopeUpdates) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("scopeEntriesToUpdate", scopeUpdates);
            params.put("lastModifier", userId);
            params.put("lastModified", this.formatter.format(LocalDateUtil.getCurrentDateTime()));
            Script updateEntityScript = ElasticsearchWriterUtil.createDefaultScriptWithSpecificDtoParams("Map newScopes = ctx._source.data.scope.stream()\n  .collect(Collectors.toMap(s -> s.id, Function.identity()));\nparams.scopeEntriesToUpdate\n  .forEach(newScope -> {\n     newScopes.computeIfPresent(newScope.id, (key, oldScope) -> {\n       newScope.tenants = Stream.concat(oldScope.tenants.stream(), newScope.tenants.stream())\n        .distinct()\n        .collect(Collectors.toList());\n       return newScope;\n     });\n     newScopes.putIfAbsent(newScope.id, newScope);\n  });\nctx._source.data.scope = newScopes.values();\nctx._source.lastModifier = params.lastModifier;\nctx._source.lastModified = params.lastModified;\n", params);
            UpdateResponse<?> updateResponse = this.executeUpdateRequest(collectionId, updateEntityScript, "Was not able to update collection with id [%s].");
            if (updateResponse.result().equals((Object)Result.NotFound)) {
                String message = String.format("Was not able to add scope entries to collection with id [%s]. Collection does not exist!", collectionId);
                LOG.error(message);
                throw new NotFoundException(message);
            }
        }
        catch (IOException e) {
            String errorMessage = String.format("Wasn't able to add scope entries to collection with id [%s].", collectionId);
            LOG.error(errorMessage, (Throwable)e);
            throw new OptimizeRuntimeException(errorMessage, (Throwable)e);
        }
    }

    @Override
    public void deleteScopeEntryFromAllCollections(String scopeEntryId) {
        String updateItem = String.format("collection scope entry with ID [%s].", scopeEntryId);
        LOG.info("Removing {} from all collections.", (Object)updateItem);
        Script removeScopeEntryFromCollectionsScript = Script.of(s -> s.inline(i -> ((InlineScript.Builder)i.lang(ScriptLanguage.Painless).params(Map.of("scopeEntryIdToRemove", JsonData.of((Object)scopeEntryId)))).source("def scopes = ctx._source.data.scope;\nif(scopes != null) {\n   scopes.removeIf(scope -> scope.id.equals(params.scopeEntryIdToRemove));\n}\n")));
        Query query = Query.of(q -> q.nested(n -> n.path(CollectionIndex.DATA).scoreMode(ChildScoreMode.None).query(Query.of(qq -> qq.nested(nn -> nn.path(String.join((CharSequence)".", CollectionIndex.DATA, CollectionIndex.SCOPE)).scoreMode(ChildScoreMode.None).query(qqq -> qqq.term(t -> t.field(String.join((CharSequence)".", CollectionIndex.DATA, CollectionIndex.SCOPE, CollectionScopeEntryDto.Fields.id.name())).value(scopeEntryId))))))));
        this.taskRepositoryES.tryUpdateByQueryRequest(updateItem, removeScopeEntryFromCollectionsScript, query, "collection");
    }

    @Override
    public void updateScopeEntity(String collectionId, CollectionScopeEntryUpdateDto scopeEntry, String userId, String scopeEntryId) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("entryDto", scopeEntry);
            params.put("entryId", scopeEntryId);
            params.put("lastModifier", userId);
            params.put("lastModified", this.formatter.format(LocalDateUtil.getCurrentDateTime()));
            Script updateEntityScript = ElasticsearchWriterUtil.createDefaultScriptWithSpecificDtoParams("def optionalEntry = ctx._source.data.scope.stream()\n  .filter(s -> s.id.equals(params.entryId))\n  .findFirst();\nif (optionalEntry.isPresent()) {\n  def entry = optionalEntry.get();\n  entry.tenants = params.entryDto.tenants;\n  ctx._source.lastModifier = params.lastModifier;\n  ctx._source.lastModified = params.lastModified;\n} else {\n  throw new Exception('Cannot find scope entry.');\n}\n", params);
            this.executeUpdateRequest(collectionId, updateEntityScript, "Was not able to update collection with id [%s].");
        }
        catch (IOException e) {
            String errorMessage = String.format("Was not able to update collection with id [%s].", collectionId);
            LOG.error(errorMessage, (Throwable)e);
            throw new OptimizeRuntimeException(errorMessage, (Throwable)e);
        }
        catch (ElasticsearchException e) {
            String errorMessage = String.format("Was not able to update scope entry with id [%s] on collection with id [%s]. Collection or scope Entry does not exist!", scopeEntryId, collectionId);
            LOG.error(errorMessage, (Throwable)e);
            throw new NotFoundException(errorMessage, (Throwable)e);
        }
    }

    @Override
    public void removeScopeEntries(String collectionId, List<String> scopeEntryIds, String userId) throws NotFoundException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ids", scopeEntryIds);
        params.put("lastModifier", userId);
        params.put("lastModified", this.formatter.format(LocalDateUtil.getCurrentDateTime()));
        Script updateEntityScript = ElasticsearchWriterUtil.createDefaultScriptWithPrimitiveParams("for (id in params.ids) {\n  ctx._source.data.scope.removeIf(scope -> scope.id.equals(id));\n}\nctx._source.lastModifier = params.lastModifier;\nctx._source.lastModified = params.lastModified;\n", params);
        try {
            this.executeUpdateRequest(collectionId, updateEntityScript, "Was not able to update collection with id [%s].");
        }
        catch (IOException e) {
            String errorMessage = String.format("The scope with ids %s could not be removed from the collection %s.", scopeEntryIds, collectionId);
            LOG.error(errorMessage, (Throwable)e);
            throw new OptimizeRuntimeException(errorMessage, (Throwable)e);
        }
    }

    @Override
    public void removeScopeEntry(String collectionId, String scopeEntryId, String userId) throws NotFoundException {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("id", scopeEntryId);
            params.put("lastModifier", userId);
            params.put("lastModified", this.formatter.format(LocalDateUtil.getCurrentDateTime()));
            Script updateEntityScript = ElasticsearchWriterUtil.createDefaultScriptWithPrimitiveParams("boolean removed = ctx._source.data.scope.removeIf(scope -> scope.id.equals(params.id));\nif (removed) {\n  ctx._source.lastModifier = params.lastModifier;\n  ctx._source.lastModified = params.lastModified;\n} else {\n  ctx.op = \"none\";\n}\n", params);
            UpdateResponse<?> updateResponse = this.executeUpdateRequest(collectionId, updateEntityScript, "Was not able to update collection with id [%s].");
            if (updateResponse.result().equals((Object)Result.NoOp)) {
                String message = String.format("Scope entry for id [%s] doesn't exist.", scopeEntryId);
                LOG.warn(message);
                throw new NotFoundException(message);
            }
        }
        catch (IOException e) {
            String errorMessage = String.format("Was not able to update collection with id [%s].", collectionId);
            LOG.error(errorMessage, (Throwable)e);
            throw new OptimizeRuntimeException(errorMessage, (Throwable)e);
        }
    }

    @Override
    public void addRoleToCollection(String collectionId, List<CollectionRoleRequestDto> rolesToAdd, String userId) {
        LOG.debug("Adding roles {} to collection with id [{}] in Elasticsearch.", rolesToAdd, (Object)collectionId);
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("rolesToAdd", rolesToAdd);
            params.put("lastModifier", userId);
            params.put("lastModified", this.formatter.format(LocalDateUtil.getCurrentDateTime()));
            Script addEntityScript = ElasticsearchWriterUtil.createDefaultScriptWithSpecificDtoParams("def newRoles = new ArrayList();\nfor (roleToAdd in params.rolesToAdd) {\n    boolean exists = ctx._source.data.roles.stream()\n       .anyMatch(existingRole -> existingRole.id.equals(roleToAdd.id));\n    if (!exists){\n      newRoles.add(roleToAdd);\n    }\n}\nif (newRoles.size() == params.rolesToAdd.size()) {\n    ctx._source.data.roles.addAll(newRoles);\n    ctx._source.lastModifier = params.lastModifier;\n    ctx._source.lastModified = params.lastModified;\n} else {\n    ctx.op = \"none\";\n}\n", params);
            UpdateResponse<?> updateResponse = this.executeUpdateRequest(collectionId, addEntityScript, "Was not able to update collection with id [%s].");
            if (updateResponse.result().equals((Object)Result.NoOp)) {
                String message = String.format("One of the roles %s already exists in collection [%s].", rolesToAdd, collectionId);
                LOG.warn(message);
                throw new OptimizeCollectionConflictException(message);
            }
        }
        catch (IOException e) {
            String errorMessage = String.format("Was not able to update collection with id [%s].", collectionId);
            LOG.error(errorMessage, (Throwable)e);
            throw new OptimizeRuntimeException(errorMessage, (Throwable)e);
        }
        catch (ElasticsearchException e) {
            String errorMessage = String.format("Was not able to update collection with id [%s]. Collection does not exist!", collectionId);
            LOG.error(errorMessage, (Throwable)e);
            throw new NotFoundException(errorMessage, (Throwable)e);
        }
    }

    @Override
    public void updateRoleInCollection(String collectionId, String roleEntryId, CollectionRoleUpdateRequestDto roleUpdateDto, String userId) throws OptimizeConflictException {
        LOG.debug("Updating the role [{}] in collection with id [{}] in Elasticsearch.", (Object)roleEntryId, (Object)collectionId);
        try {
            Map<String, String> params = this.constructParamsForRoleUpdateScript(roleEntryId, userId);
            params.put("role", roleUpdateDto.getRole().toString());
            Script addEntityScript = ElasticsearchWriterUtil.createDefaultScriptWithPrimitiveParams("def optionalExistingEntry = ctx._source.data.roles.stream()\n.filter(dto -> dto.id.equals(params.roleEntryId))\n.findFirst();\nif(optionalExistingEntry.isPresent()){\n   def existingEntry = optionalExistingEntry.get();\n   def moreThanOneManagerPresent = ctx._source.data.roles.stream()\n   .filter(dto -> params.managerRole.equals(dto.role))\n   .limit(2)\n   .count()\n    == 2;\nif (!moreThanOneManagerPresent && params.managerRole.equals(existingEntry.role)) {\n// updating of last manager is not allowed\n   ctx.op = \"none\";\n} else {\n   existingEntry.role = params.role;\n   ctx._source.lastModifier = params.lastModifier;\n   ctx._source.lastModified = params.lastModified;\n}\n} else {\nthrow new Exception('Cannot find role.');\n}\n", params);
            UpdateResponse<?> updateResponse = this.executeUpdateRequest(collectionId, addEntityScript, "Was not able to update collection with id [%s].");
            if (updateResponse.result().equals((Object)Result.NoOp)) {
                String message = String.format("Cannot assign lower privileged role to last [%s] of collection [%s].", RoleType.MANAGER, collectionId);
                LOG.warn(message);
                throw new OptimizeCollectionConflictException(message);
            }
        }
        catch (IOException e) {
            String errorMessage = String.format("Was not able to update collection with id [%s].", collectionId);
            LOG.error(errorMessage, (Throwable)e);
            throw new OptimizeRuntimeException(errorMessage, (Throwable)e);
        }
        catch (ElasticsearchException e) {
            String errorMessage = String.format("Was not able to update role with id [%s] on collection with id [%s]. Collection or role does not exist!", roleEntryId, collectionId);
            LOG.error(errorMessage, (Throwable)e);
            throw new NotFoundException(errorMessage, (Throwable)e);
        }
    }

    @Override
    public void removeRoleFromCollectionUnlessIsLastManager(String collectionId, String roleEntryId, String userId) throws OptimizeConflictException {
        Map<String, String> params = this.constructParamsForRoleUpdateScript(roleEntryId, userId);
        this.removeRoleFromCollectionUnlessIsLastManager(collectionId, roleEntryId, params);
    }

    @Override
    public void persistCollection(String id, CollectionDefinitionDto collectionDefinitionDto) {
        try {
            IndexResponse indexResponse = this.esClient.index(OptimizeIndexRequestBuilderES.of(i -> i.optimizeIndex(this.esClient, "collection").id(id).document((Object)collectionDefinitionDto).refresh(Refresh.True)));
            if (!indexResponse.result().equals((Object)Result.Created)) {
                String message = "Could not write collection to Elasticsearch. ";
                LOG.error("Could not write collection to Elasticsearch. ");
                throw new OptimizeRuntimeException("Could not write collection to Elasticsearch. ");
            }
        }
        catch (IOException e) {
            String errorMessage = "Could not create collection.";
            LOG.error("Could not create collection.", (Throwable)e);
            throw new OptimizeRuntimeException("Could not create collection.", (Throwable)e);
        }
        LOG.debug("Collection with id [{}] has successfully been created.", (Object)id);
    }

    private UpdateResponse<?> executeUpdateRequest(String collectionId, Script updateEntityScript, String errorMessage) throws IOException {
        UpdateResponse updateResponse = this.esClient.update(new OptimizeUpdateRequestBuilderES().optimizeIndex(this.esClient, new String[]{"collection"}).id(collectionId).script(updateEntityScript).refresh(Refresh.True).retryOnConflict(Integer.valueOf(5)).build(), Object.class);
        if (!updateResponse.shards().failures().isEmpty()) {
            String message = String.format(errorMessage, collectionId);
            LOG.error(message, (Object)collectionId);
            throw new OptimizeRuntimeException(message);
        }
        return updateResponse;
    }

    private void removeRoleFromCollectionUnlessIsLastManager(String collectionId, String roleEntryId, Map<String, String> params) throws OptimizeConflictException {
        LOG.debug("Deleting the role [{}] in collection with id [{}] in Elasticsearch.", (Object)roleEntryId, (Object)collectionId);
        try {
            Script addEntityScript = ElasticsearchWriterUtil.createDefaultScriptWithPrimitiveParams("def optionalExistingEntry = ctx._source.data.roles.stream()\n.filter(dto -> dto.id.equals(params.roleEntryId))\n.findFirst();\nif(optionalExistingEntry.isPresent()){\n    def existingEntry = optionalExistingEntry.get();\n    def moreThanOneManagerPresent = ctx._source.data.roles.stream()\n    .filter(dto -> params.managerRole.equals(dto.role))\n    .limit(2)\n    .count()\n     == 2;\n    if (!moreThanOneManagerPresent && params.managerRole.equals(existingEntry.role)) {\n        // deletion of last manager is not allowed\n        ctx.op = \"none\";\n    } else {\n        ctx._source.data.roles.removeIf(entry -> entry.id.equals(params.roleEntryId));\n    if (params.containsKey(\"lastModifier\")) {\n        ctx._source.lastModifier = params.lastModifier;\n    }\n    if (params.containsKey(\"lastModified\")) {\n        ctx._source.lastModified = params.lastModified;\n    }\n}\n} else {\n   throw new Exception('Cannot find role.');\n}\n", params);
            UpdateResponse<?> updateResponse = this.executeUpdateRequest(collectionId, addEntityScript, "Was not able to delete role from collection with id [%s].");
            if (updateResponse.result() == Result.NoOp) {
                String message = String.format("Cannot delete last [%s] of collection [%s].", RoleType.MANAGER, collectionId);
                LOG.warn(message);
                throw new OptimizeCollectionConflictException(message);
            }
        }
        catch (IOException e) {
            String errorMessage = String.format("Was not able to update collection with id [%s].", collectionId);
            LOG.error(errorMessage, (Throwable)e);
            throw new OptimizeRuntimeException(errorMessage, (Throwable)e);
        }
        catch (ElasticsearchException e) {
            String errorMessage = String.format("Was not able to update role with id [%s] on collection with id [%s]. Collection or role does not exist!", roleEntryId, collectionId);
            LOG.error(errorMessage, (Throwable)e);
            throw new NotFoundException(errorMessage, (Throwable)e);
        }
    }

    private Map<String, String> constructParamsForRoleUpdateScript(String roleEntryId, String userId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("roleEntryId", roleEntryId);
        params.put("managerRole", RoleType.MANAGER.toString());
        if (userId != null) {
            params.put("lastModifier", userId);
            params.put("lastModified", this.formatter.format(LocalDateUtil.getCurrentDateTime()));
        }
        return params;
    }
}

