/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.service;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.service.db.es.report.context.VariableAggregationContextES;
import io.camunda.optimize.service.db.es.report.interpreter.util.NumberHistogramAggregationUtilES;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import io.camunda.optimize.service.db.report.interpreter.service.AbstractNumberVariableAggregationService;
import io.camunda.optimize.service.util.RoundingUtil;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class NumberVariableAggregationServiceES
extends AbstractNumberVariableAggregationService {
    public Optional<Map<String, Aggregation.Builder.ContainerBuilder>> createNumberVariableAggregation(VariableAggregationContextES context) {
        if (context.getVariableRangeMinMaxStats().isEmpty()) {
            return Optional.empty();
        }
        Optional<Double> min = this.getBaselineForNumberVariableAggregation(context);
        if (min.isEmpty()) {
            return Optional.empty();
        }
        double intervalSize = this.getIntervalSize(context, min.get());
        double max = context.getMaxVariableValue();
        String digitFormat = VariableType.DOUBLE.equals((Object)context.getVariableType()) ? "0.00" : "0";
        Aggregation.Builder.ContainerBuilder histogramAggregation = NumberHistogramAggregationUtilES.generateHistogramWithField((String)"numberVariableHistogram", (double)intervalSize, (double)min.get(), (double)max, (String)context.getNestedVariableValueFieldLabel(), (String)digitFormat, context.getSubAggregations());
        return Optional.of(Map.of("numberVariableHistogram", histogramAggregation));
    }

    private Double getIntervalSize(VariableAggregationContextES context, Double baseline) {
        double maxVariableValue = context.getMaxVariableValue();
        boolean customBucketsActive = context.getCustomBucketDto().isActive();
        Double intervalSize = context.getCustomBucketDto().getBucketSize();
        if (!customBucketsActive || intervalSize == null || intervalSize <= 0.0) {
            intervalSize = Math.abs(maxVariableValue - baseline) / 79.0;
            intervalSize = intervalSize == 0.0 ? 1.0 : RoundingUtil.roundUpToNearestPowerOfTen(intervalSize);
        }
        if (!VariableType.DOUBLE.equals((Object)context.getVariableType())) {
            intervalSize = Math.ceil(intervalSize);
        }
        return intervalSize;
    }

    Optional<Double> getBaselineForNumberVariableAggregation(VariableAggregationContextES context) {
        Optional<Double> baselineForSingleReport;
        Optional<MinMaxStatDto> combinedMinMaxStats = context.getCombinedRangeMinMaxStats();
        Optional<Double> optional = baselineForSingleReport = context.getCustomBucketDto().isActive() ? Optional.ofNullable(context.getCustomBucketDto().getBaseline()) : Optional.empty();
        if (combinedMinMaxStats.isEmpty() && baselineForSingleReport.isPresent()) {
            if ((Double)baselineForSingleReport.get() > context.getVariableRangeMinMaxStats().getMax()) {
                return Optional.empty();
            }
            return baselineForSingleReport;
        }
        return Optional.of(RoundingUtil.roundDownToNearestPowerOfTen(combinedMinMaxStats.orElse(context.getVariableRangeMinMaxStats()).getMin()));
    }
}

