/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.util;

import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationBuilders;
import co.elastic.clients.elasticsearch._types.aggregations.NestedAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.ScriptedMetricAggregate;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.ChildScoreMode;
import co.elastic.clients.json.JsonData;
import com.google.common.collect.ImmutableMap;
import io.camunda.optimize.dto.optimize.ReportConstants;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.AggregationDto;
import io.camunda.optimize.service.db.report.interpreter.util.AbstractProcessPartQueryUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.StringSubstitutor;

public final class ProcessPartQueryUtilES
extends AbstractProcessPartQueryUtil {
    private ProcessPartQueryUtilES() {
    }

    public static Map<String, Aggregate> getProcessPartAggregations(Map<String, Aggregate> aggs) {
        return aggs.get("nestedAggregation").nested().aggregations();
    }

    public static Double getProcessPartAggregationResult(Map<String, Aggregate> aggs, AggregationDto aggregationType) {
        NestedAggregate nested = aggs.get("nestedAggregation").nested();
        ScriptedMetricAggregate scriptedMetric = ((Aggregate)nested.aggregations().get(ProcessPartQueryUtilES.getScriptAggregationName(aggregationType))).scriptedMetric();
        try {
            return (Double)scriptedMetric.value().to(Double.class);
        }
        catch (IllegalStateException i) {
            return ReportConstants.NO_DATA_AVAILABLE_RESULT;
        }
    }

    public static BoolQuery.Builder addProcessPartQuery(BoolQuery.Builder boolQueryBuilder, String startFlowNodeId, String endFlowNodeId) {
        String termPath = "flowNodeInstances.flowNodeId";
        boolQueryBuilder.must(m -> m.nested(n -> n.path("flowNodeInstances").scoreMode(ChildScoreMode.None).query(q -> q.term(t -> t.field("flowNodeInstances.flowNodeId").value(startFlowNodeId)))));
        boolQueryBuilder.must(m -> m.nested(n -> n.path("flowNodeInstances").scoreMode(ChildScoreMode.None).query(q -> q.term(t -> t.field("flowNodeInstances.flowNodeId").value(endFlowNodeId)))));
        return boolQueryBuilder;
    }

    public static Map<String, Aggregation.Builder.ContainerBuilder> createProcessPartAggregation(String startFlowNodeId, String endFlowNodeId, List<AggregationDto> aggregationTypes) {
        Aggregation.Builder.ContainerBuilder nestedFlowNodeAggregation = new Aggregation.Builder().nested(n -> n.path("flowNodeInstances"));
        aggregationTypes.forEach(aggregationType -> {
            HashMap<String, JsonData> params = new HashMap<String, JsonData>();
            params.put("startFlowNodeId", JsonData.of((Object)startFlowNodeId));
            params.put("endFlowNodeId", JsonData.of((Object)endFlowNodeId));
            params.put("aggregationType", JsonData.of((Object)aggregationType.getType().getId()));
            String scriptAggregationName = ProcessPartQueryUtilES.getScriptAggregationName(aggregationType);
            Aggregation findStartAndEndDatesForEvents = AggregationBuilders.scriptedMetric(s -> s.initScript(ProcessPartQueryUtilES.createInitScript()).mapScript(ProcessPartQueryUtilES.createMapScript()).combineScript(ProcessPartQueryUtilES.createCombineScript()).reduceScript(ProcessPartQueryUtilES.getReduceScript()).params(params));
            nestedFlowNodeAggregation.aggregations(scriptAggregationName, findStartAndEndDatesForEvents);
        });
        return Map.of("nestedAggregation", nestedFlowNodeAggregation);
    }

    private static Script createInitScript() {
        return Script.of(s -> s.inline(i -> i.source("state.procInstIdToStartDates = new HashMap();state.procInstIdToEndDates = new HashMap();")));
    }

    private static Script createMapScript() {
        StringSubstitutor substitutor = new StringSubstitutor((Map)ImmutableMap.builder().put((Object)"flowNodeProcessInstanceIdField", (Object)"flowNodeInstances.processInstanceId").put((Object)"flowNodeIdField", (Object)"flowNodeInstances.flowNodeId").put((Object)"flowNodeStartDateField", (Object)"flowNodeInstances.startDate").put((Object)"flowNodeEndDateField", (Object)"flowNodeInstances.endDate").build());
        return Script.of(s -> s.inline(i -> i.source(substitutor.replace("def processInstanceId = doc['${flowNodeProcessInstanceIdField}'].value;if(doc['${flowNodeIdField}'].value == params.startFlowNodeId && doc['${flowNodeStartDateField}'].size() != 0 && doc['${flowNodeStartDateField}'].value != null && doc['${flowNodeStartDateField}'].value.toInstant().toEpochMilli() != 0) {long startDateInMillis = doc['${flowNodeStartDateField}'].value.toInstant().toEpochMilli();state.procInstIdToStartDates.putIfAbsent(processInstanceId, new ArrayList());state.procInstIdToStartDates.get(processInstanceId).add(startDateInMillis);} else if(doc['${flowNodeIdField}'].value == params.endFlowNodeId && doc['${flowNodeEndDateField}'].size() != 0 && doc['${flowNodeEndDateField}'].value != null && doc['${flowNodeEndDateField}'].value.toInstant().toEpochMilli() != 0) {long endDateInMillis = doc['${flowNodeEndDateField}'].value.toInstant().toEpochMilli();state.procInstIdToEndDates.putIfAbsent(processInstanceId, new ArrayList());state.procInstIdToEndDates.get(processInstanceId).add(endDateInMillis);}"))));
    }

    private static Script createCombineScript() {
        return Script.of(s -> s.inline(i -> i.source("double sum = 0.0;long count = 0;double min = Double.MAX_VALUE;double max = Double.MIN_VALUE;for (procInstIdToStartDatesEntry in state.procInstIdToStartDates.entrySet()) {  def endDates = state.procInstIdToEndDates.getOrDefault(procInstIdToStartDatesEntry.getKey(), new ArrayList());def startDates = procInstIdToStartDatesEntry.getValue();if (!startDates.isEmpty() && !endDates.isEmpty()) {long minStartDate = startDates.stream().min(Long::compareTo).get(); List endDatesLargerMinStartDate = endDates.stream().filter(e -> e >= minStartDate).collect(Collectors.toList());if (!endDatesLargerMinStartDate.isEmpty()) {long closestEndDate = endDatesLargerMinStartDate.stream().min(Comparator.comparingDouble(v -> Math.abs(v - minStartDate))).get();double duration = closestEndDate - minStartDate;min = duration < min? duration : min;max = duration > max? duration : max;sum += duration;count += 1;}}}Map result = new HashMap();result.put('aggregationType', params.aggregationType);result.put('sum', sum);result.put('count', count);result.put('min', min);result.put('max', max);return result;")));
    }

    private static Script getReduceScript() {
        return Script.of(s -> s.inline(i -> i.source("if (states == null || states.isEmpty()) {return null;}double sum = 0; long count = 0; double min = Double.MAX_VALUE;double max = Double.MIN_VALUE;def aggregationType = 'avg';for (a in states) { if (a != null) {sum += a.get('sum');count += a.get('count');min = a.get('min') < min? a.get('min') : min;max = a.get('max') > max? a.get('max') : max;}}if (count == 0) {return null;}if (params.aggregationType == 'avg') {return sum / count;} else if (params.aggregationType == 'min') {return min;} else if (params.aggregationType == 'max') {return max;} else if (params.aggregationType == 'sum') {return sum;} else {Debug.explain('Aggregation type ' + params.aggregationType + ' is not supported!');}")));
    }
}

