/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.util;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import java.util.Map;
import java.util.Optional;

public final class FilterLimitedAggregationUtilES {
    public static final String FILTER_LIMITED_AGGREGATION = "filterLimitedAggregation";

    private FilterLimitedAggregationUtilES() {
    }

    public static Map<String, Aggregation.Builder.ContainerBuilder> wrapWithFilterLimitedParentAggregation(Query limitFilterQuery, Map<String, Aggregation.Builder.ContainerBuilder> subAggregationsToLimit) {
        return FilterLimitedAggregationUtilES.wrapWithFilterLimitedParentAggregation(FILTER_LIMITED_AGGREGATION, limitFilterQuery, subAggregationsToLimit);
    }

    public static Map<String, Aggregation.Builder.ContainerBuilder> wrapWithFilterLimitedParentAggregation(String filterParentAggregationName, Query limitFilterQuery, Map<String, Aggregation.Builder.ContainerBuilder> subAggregationsToLimit) {
        Aggregation.Builder.ContainerBuilder builder = new Aggregation.Builder().filter(limitFilterQuery);
        subAggregationsToLimit.forEach((k, v) -> builder.aggregations(k, a -> v));
        return Map.of(filterParentAggregationName, builder);
    }

    public static Optional<Map<String, Aggregate>> unwrapFilterLimitedAggregations(Map<String, Aggregate> aggregations) {
        return FilterLimitedAggregationUtilES.unwrapFilterLimitedAggregations(FILTER_LIMITED_AGGREGATION, aggregations);
    }

    public static Optional<Map<String, Aggregate>> unwrapFilterLimitedAggregations(String filterParentAggregationName, Map<String, Aggregate> aggregations) {
        return Optional.ofNullable(aggregations.get(filterParentAggregationName)).map(a -> a.filter().aggregations());
    }
}

