/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.util;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import com.google.common.collect.ImmutableList;
import io.camunda.optimize.service.db.schema.index.AbstractInstanceIndex;
import io.camunda.optimize.service.util.DefinitionVersionHandlingUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;

public final class DefinitionQueryUtilES {
    private DefinitionQueryUtilES() {
    }

    public static BoolQuery createDefinitionQuery(String definitionKey, List<String> tenantIds, AbstractInstanceIndex type) {
        return DefinitionQueryUtilES.createDefinitionQuery(definitionKey, (List<String>)ImmutableList.of((Object)"all"), tenantIds, type, s -> "").build();
    }

    public static Query createDefinitionQuery(Map<String, Set<String>> definitionKeyToTenantsMap, String definitionKeyFieldName, String tenantKeyFieldName) {
        return Query.of(bb -> bb.bool(b -> {
            b.minimumShouldMatch("1");
            definitionKeyToTenantsMap.forEach((definitionKey, tenantIds) -> b.should(s -> s.bool(bol -> bol.must(m -> m.term(t -> t.field(definitionKeyFieldName).value(FieldValue.of((String)definitionKey)))).must(DefinitionQueryUtilES.createTenantIdQuery(tenantKeyFieldName, new ArrayList<String>((Collection<String>)tenantIds)), new Query[0]))));
            return b;
        }));
    }

    public static BoolQuery.Builder createDefinitionQuery(String definitionKey, List<String> definitionVersions, List<String> tenantIds, AbstractInstanceIndex<?> type, UnaryOperator<String> getLatestVersionToKey) {
        BoolQuery.Builder bb = new BoolQuery.Builder();
        bb.must(m -> m.term(t -> t.field(type.getDefinitionKeyFieldName()).value(FieldValue.of((String)definitionKey)))).must(DefinitionQueryUtilES.createTenantIdQuery(type.getTenantIdFieldName(), tenantIds), new Query[0]);
        if (DefinitionVersionHandlingUtil.isDefinitionVersionSetToLatest(definitionVersions)) {
            bb.must(m -> m.terms(t -> t.field(type.getDefinitionVersionFieldName()).terms(tt -> tt.value(List.of(FieldValue.of((String)((String)getLatestVersionToKey.apply(definitionKey))))))));
        } else if (!DefinitionVersionHandlingUtil.isDefinitionVersionSetToAll(definitionVersions)) {
            bb.must(m -> m.terms(t -> t.field(type.getDefinitionVersionFieldName()).terms(tt -> tt.value(definitionVersions.stream().map(FieldValue::of).toList()))));
        } else if (definitionVersions.isEmpty()) {
            bb.mustNot(m -> m.matchAll(a -> a));
        }
        return bb;
    }

    public static Query createTenantIdQuery(String tenantField, List<String> tenantIds) {
        AtomicBoolean includeNotDefinedTenant = new AtomicBoolean(false);
        List<String> tenantIdTerms = tenantIds.stream().peek(id -> {
            if (id == null) {
                includeNotDefinedTenant.set(true);
            }
        }).filter(Objects::nonNull).toList();
        BoolQuery tenantQueryBuilder = BoolQuery.of(b -> {
            b.minimumShouldMatch("1");
            if (!tenantIdTerms.isEmpty()) {
                b.should(s -> s.terms(t -> t.field(tenantField).terms(tt -> tt.value(tenantIdTerms.stream().map(FieldValue::of).toList()))));
            }
            if (includeNotDefinedTenant.get()) {
                b.should(s -> s.bool(bb -> bb.mustNot(m -> m.exists(e -> e.field(tenantField)))));
            }
            if (tenantIdTerms.isEmpty() && !includeNotDefinedTenant.get()) {
                b.mustNot(m -> m.matchAll(a -> a));
            }
            return b;
        });
        return Query.of(b -> b.bool(tenantQueryBuilder));
    }
}

