/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.groupby.process.usertask;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.SingleBucketAggregateBase;
import co.elastic.clients.elasticsearch._types.aggregations.StringTermsBucket;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.sorting.ReportSortingDto;
import io.camunda.optimize.dto.optimize.query.sorting.SortOrder;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.es.report.interpreter.distributedby.process.ProcessDistributedByInterpreterFacadeES;
import io.camunda.optimize.service.db.es.report.interpreter.groupby.process.usertask.AbstractGroupByUserTaskInterpreterES;
import io.camunda.optimize.service.db.es.report.interpreter.view.process.ProcessViewInterpreterFacadeES;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.interpreter.groupby.usertask.ProcessGroupByUserTaskInterpreterHelper;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class ProcessGroupByUserTaskInterpreterES
extends AbstractGroupByUserTaskInterpreterES {
    private static final String USER_TASK_ID_TERMS_AGGREGATION = "userTaskIds";
    private final ConfigurationService configurationService;
    private final DefinitionService definitionService;
    private final ProcessDistributedByInterpreterFacadeES distributedByInterpreter;
    private final ProcessViewInterpreterFacadeES viewInterpreter;
    private final ProcessGroupByUserTaskInterpreterHelper helper;

    public ProcessGroupByUserTaskInterpreterES(ConfigurationService configurationService, DefinitionService definitionService, ProcessDistributedByInterpreterFacadeES distributedByInterpreter, ProcessViewInterpreterFacadeES viewInterpreter, ProcessGroupByUserTaskInterpreterHelper helper) {
        this.configurationService = configurationService;
        this.definitionService = definitionService;
        this.distributedByInterpreter = distributedByInterpreter;
        this.viewInterpreter = viewInterpreter;
        this.helper = helper;
    }

    @Override
    public Set<ProcessGroupBy> getSupportedGroupBys() {
        return Set.of(ProcessGroupBy.PROCESS_GROUP_BY_USER_TASK);
    }

    @Override
    public Map<String, Aggregation.Builder.ContainerBuilder> createAggregation(BoolQuery boolQuery, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        Aggregation aggregation = Aggregation.of(a -> {
            Aggregation.Builder.ContainerBuilder terms = a.terms(t -> t.field("flowNodeInstances.flowNodeId").size(this.configurationService.getElasticSearchConfiguration().getAggregationBucketLimit()));
            this.distributedByInterpreter.createAggregations(context, boolQuery).forEach((k, v) -> terms.aggregations(k, v.build()));
            return terms;
        });
        return this.createFilteredUserTaskAggregation(context, boolQuery, USER_TASK_ID_TERMS_AGGREGATION, aggregation);
    }

    @Override
    public void addQueryResult(CompositeCommandResult compositeCommandResult, ResponseBody<?> response, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        this.getFilteredUserTaskAggregation(response).map(filteredFlowNodes -> ((Aggregate)filteredFlowNodes.aggregations().get(USER_TASK_ID_TERMS_AGGREGATION)).sterms()).ifPresent(userTasksAggregation -> {
            this.getUserTasksAggregation(response).map(SingleBucketAggregateBase::aggregations).ifPresent(userTaskSubAggregations -> this.distributedByInterpreter.enrichContextWithAllExpectedDistributedByKeys(context, (Map<String, Aggregate>)userTaskSubAggregations));
            Map<String, String> userTaskNames = this.getHelper().getUserTaskNames((ProcessReportDataDto)context.getReportData());
            ArrayList<CompositeCommandResult.GroupByResult> groupedData = new ArrayList<CompositeCommandResult.GroupByResult>();
            for (StringTermsBucket b : userTasksAggregation.buckets().array()) {
                String userTaskKey = b.key().stringValue();
                if (!userTaskNames.containsKey(userTaskKey)) continue;
                List<CompositeCommandResult.DistributedByResult> singleResult = this.distributedByInterpreter.retrieveResult(response, (Map<String, Aggregate>)b.aggregations(), context);
                String label = userTaskNames.get(userTaskKey);
                groupedData.add(CompositeCommandResult.GroupByResult.createGroupByResult(userTaskKey, label, singleResult));
                userTaskNames.remove(userTaskKey);
            }
            this.getHelper().addMissingGroupByResults(userTaskNames, groupedData, context, this.distributedByInterpreter);
            this.getHelper().removeHiddenModelElements(groupedData, context);
            compositeCommandResult.setGroupBySorting(context.getReportConfiguration().getSorting().orElseGet(() -> new ReportSortingDto(null, SortOrder.ASC)));
            compositeCommandResult.setGroups(groupedData);
        });
    }

    public ProcessDistributedByInterpreterFacadeES getDistributedByInterpreter() {
        return this.distributedByInterpreter;
    }

    public ProcessViewInterpreterFacadeES getViewInterpreter() {
        return this.viewInterpreter;
    }

    @Override
    public DefinitionService getDefinitionService() {
        return this.definitionService;
    }

    @Override
    public ProcessGroupByUserTaskInterpreterHelper getHelper() {
        return this.helper;
    }
}

