/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.groupby.process.usertask;

import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.UserTaskDurationTime;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.es.filter.util.ModelElementFilterQueryUtilES;
import io.camunda.optimize.service.db.es.report.interpreter.distributedby.process.ProcessDistributedByInterpreterFacadeES;
import io.camunda.optimize.service.db.es.report.interpreter.groupby.process.usertask.AbstractGroupByUserTaskInterpreterES;
import io.camunda.optimize.service.db.es.report.interpreter.util.DurationScriptUtilES;
import io.camunda.optimize.service.db.es.report.interpreter.view.process.ProcessViewInterpreterFacadeES;
import io.camunda.optimize.service.db.es.report.service.DurationAggregationServiceES;
import io.camunda.optimize.service.db.es.report.service.MinMaxStatsServiceES;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import io.camunda.optimize.service.db.report.interpreter.groupby.usertask.ProcessGroupByUserTaskInterpreterHelper;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class ProcessGroupByUserTaskDurationInterpreterES
extends AbstractGroupByUserTaskInterpreterES {
    private final MinMaxStatsServiceES minMaxStatsService;
    private final DurationAggregationServiceES durationAggregationService;
    private final DefinitionService definitionService;
    private final ProcessDistributedByInterpreterFacadeES distributedByInterpreter;
    private final ProcessViewInterpreterFacadeES viewInterpreter;
    private final ProcessGroupByUserTaskInterpreterHelper helper;

    public ProcessGroupByUserTaskDurationInterpreterES(MinMaxStatsServiceES minMaxStatsService, DurationAggregationServiceES durationAggregationService, DefinitionService definitionService, ProcessDistributedByInterpreterFacadeES distributedByInterpreter, ProcessViewInterpreterFacadeES viewInterpreter, ProcessGroupByUserTaskInterpreterHelper helper) {
        this.minMaxStatsService = minMaxStatsService;
        this.durationAggregationService = durationAggregationService;
        this.definitionService = definitionService;
        this.distributedByInterpreter = distributedByInterpreter;
        this.viewInterpreter = viewInterpreter;
        this.helper = helper;
    }

    @Override
    public Set<ProcessGroupBy> getSupportedGroupBys() {
        return Set.of(ProcessGroupBy.PROCESS_GROUP_BY_USER_TASK_DURATION);
    }

    @Override
    public Map<String, Aggregation.Builder.ContainerBuilder> createAggregation(BoolQuery boolQuery, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        UserTaskDurationTime userTaskDurationTime = this.getHelper().getUserTaskDurationTime(context);
        return this.durationAggregationService.createLimitedGroupByScriptedUserTaskDurationAggregation(boolQuery, context, this.getDurationScript(userTaskDurationTime), userTaskDurationTime).map(durationAggregation -> durationAggregation.entrySet().stream().map(e -> this.createFilteredUserTaskAggregation(context, boolQuery, (String)e.getKey(), ((Aggregation.Builder.ContainerBuilder)e.getValue()).build())).findFirst().get()).orElse(Map.of());
    }

    @Override
    public Optional<MinMaxStatDto> getMinMaxStats(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Query baseQuery) {
        return Optional.of(this.retrieveMinMaxDurationStats(context, baseQuery, this.getHelper().getUserTaskDurationTime(context)));
    }

    @Override
    public void addQueryResult(CompositeCommandResult compositeCommandResult, ResponseBody<?> response, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        compositeCommandResult.setGroupByKeyOfNumericType(true);
        compositeCommandResult.setDistributedByKeyOfNumericType(this.distributedByInterpreter.isKeyOfNumericType(context));
        this.getFilteredUserTaskAggregation(response).ifPresent(userFilteredFlowNodes -> {
            List<CompositeCommandResult.GroupByResult> durationHistogramData = this.durationAggregationService.mapGroupByDurationResults(response, userFilteredFlowNodes.aggregations(), context);
            compositeCommandResult.setGroups(durationHistogramData);
        });
    }

    public ProcessDistributedByInterpreterFacadeES getDistributedByInterpreter() {
        return this.distributedByInterpreter;
    }

    public ProcessViewInterpreterFacadeES getViewInterpreter() {
        return this.viewInterpreter;
    }

    private MinMaxStatDto retrieveMinMaxDurationStats(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Query baseQuery, UserTaskDurationTime userTaskDurationTime) {
        return this.minMaxStatsService.getScriptedMinMaxStats(baseQuery, this.getIndexNames(context), "flowNodeInstances", this.getDurationScript(userTaskDurationTime), Query.of(q -> q.bool(ModelElementFilterQueryUtilES.createUserTaskFlowNodeTypeFilter().build())));
    }

    private Script getDurationScript(UserTaskDurationTime userTaskDurationTime) {
        return DurationScriptUtilES.getUserTaskDurationScript(LocalDateUtil.getCurrentDateTime().toInstant().toEpochMilli(), "flowNodeInstances." + userTaskDurationTime.getDurationFieldName());
    }

    @Override
    public DefinitionService getDefinitionService() {
        return this.definitionService;
    }

    @Override
    public ProcessGroupByUserTaskInterpreterHelper getHelper() {
        return this.helper;
    }
}

