/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.groupby.process.date;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.FilterAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.NestedAggregate;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import io.camunda.optimize.dto.optimize.query.report.single.group.AggregateByDateUnit;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.group.value.DateGroupByValueDto;
import io.camunda.optimize.dto.optimize.query.sorting.ReportSortingDto;
import io.camunda.optimize.dto.optimize.query.sorting.SortOrder;
import io.camunda.optimize.service.db.es.report.context.DateAggregationContextES;
import io.camunda.optimize.service.db.es.report.interpreter.groupby.process.AbstractProcessGroupByInterpreterES;
import io.camunda.optimize.service.db.es.report.interpreter.util.FilterLimitedAggregationUtilES;
import io.camunda.optimize.service.db.es.report.service.DateAggregationServiceES;
import io.camunda.optimize.service.db.es.report.service.MinMaxStatsServiceES;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import io.camunda.optimize.service.db.report.context.DateAggregationContext;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProcessGroupByModelElementDateInterpreterES
extends AbstractProcessGroupByInterpreterES {
    private static final String ELEMENT_AGGREGATION = "elementAggregation";
    private static final String FILTERED_ELEMENTS_AGGREGATION = "filteredElements";
    private static final String MODEL_ELEMENT_TYPE_FILTER_AGGREGATION = "filteredElementsByType";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractProcessGroupByModelElementDateInterpreterES.class);

    protected abstract DateAggregationServiceES getDateAggregationService();

    protected abstract MinMaxStatsServiceES getMinMaxStatsService();

    @Override
    public Optional<MinMaxStatDto> getMinMaxStats(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Query baseQuery) {
        AggregateByDateUnit groupByDateUnit;
        if (context.getReportData().getGroupBy().getValue() instanceof DateGroupByValueDto && AggregateByDateUnit.AUTOMATIC.equals((Object)(groupByDateUnit = this.getGroupByDateUnit(context.getReportData())))) {
            return Optional.of(this.getMinMaxStatsService().getMinMaxDateRangeForNestedField(context, baseQuery, this.getIndexNames(context), this.getDateField(), this.getPathToElementField(), Query.of(q -> q.bool(this.getFilterBoolQueryBuilder(context).build()))));
        }
        return Optional.empty();
    }

    protected abstract String getPathToElementField();

    @Override
    public Map<String, Aggregation.Builder.ContainerBuilder> createAggregation(BoolQuery boolQuery, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        AggregateByDateUnit unit = this.getGroupByDateUnit(context.getReportData());
        MinMaxStatDto stats = this.getMinMaxStatsService().getMinMaxDateRangeForNestedField(context, Query.of(q -> q.bool(boolQuery)), this.getIndexNames(context), this.getDateField(), this.getPathToElementField(), Query.of(q -> q.bool(this.getFilterBoolQueryBuilder(context).build())));
        DateAggregationContext dateAggContext = ((DateAggregationContextES.DateAggregationContextESBuilder)((DateAggregationContext.DateAggregationContextBuilder)((DateAggregationContextES.DateAggregationContextESBuilder)((DateAggregationContextES.DateAggregationContextESBuilder)((DateAggregationContextES.DateAggregationContextESBuilder)((DateAggregationContextES.DateAggregationContextESBuilder)DateAggregationContextES.builder().aggregateByDateUnit(unit)).dateField(this.getDateField())).minMaxStats(stats)).timezone(context.getTimezone())).subAggregations(this.getDistributedByInterpreter().createAggregations(context, boolQuery))).filterContext(context.getFilterContext())).build();
        Optional<Map<String, Aggregation.Builder.ContainerBuilder>> bucketLimitedHistogramAggregation = this.getDateAggregationService().createModelElementDateAggregation((DateAggregationContextES)dateAggContext);
        if (bucketLimitedHistogramAggregation.isPresent()) {
            Map<String, Aggregation.Builder.ContainerBuilder> groupByFlowNodeDateAggregation = this.wrapInNestedElementAggregation(context, bucketLimitedHistogramAggregation.get(), this.getDistributedByInterpreter().createAggregations(context, boolQuery));
            return groupByFlowNodeDateAggregation;
        }
        return Map.of();
    }

    private Map<String, Aggregation.Builder.ContainerBuilder> wrapInNestedElementAggregation(ExecutionContext<ProcessReportDataDto, ?> context, Map<String, Aggregation.Builder.ContainerBuilder> aggregationToWrap, Map<String, Aggregation.Builder.ContainerBuilder> distributedBySubAggregations) {
        Aggregation.Builder.ContainerBuilder builder = new Aggregation.Builder().filter(this.getModelElementTypeFilterQuery()).aggregations(FILTERED_ELEMENTS_AGGREGATION, Aggregation.of(a -> a.filter(Query.of(q -> q.bool(this.getFilterBoolQueryBuilder(context).build()))).aggregations(aggregationToWrap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Aggregation.Builder.ContainerBuilder)e.getValue()).build())))));
        distributedBySubAggregations.forEach((k, v) -> builder.aggregations(k, v.build()));
        Aggregation.Builder.ContainerBuilder b = new Aggregation.Builder().nested(n -> n.path(this.getPathToElementField())).aggregations(MODEL_ELEMENT_TYPE_FILTER_AGGREGATION, builder.build());
        return Map.of(ELEMENT_AGGREGATION, b);
    }

    @Override
    public void addQueryResult(CompositeCommandResult result, ResponseBody<?> response, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        result.setGroups(this.processAggregations(response, context));
        result.setGroupBySorting(context.getReportConfiguration().getSorting().orElseGet(() -> new ReportSortingDto("key", SortOrder.ASC)));
    }

    private List<CompositeCommandResult.GroupByResult> processAggregations(ResponseBody<?> response, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        Map aggregations = response.aggregations();
        if (aggregations == null || aggregations.isEmpty()) {
            return Collections.emptyList();
        }
        NestedAggregate flowNodes = ((Aggregate)aggregations.get(ELEMENT_AGGREGATION)).nested();
        FilterAggregate filteredFlowNodesByType = ((Aggregate)flowNodes.aggregations().get(MODEL_ELEMENT_TYPE_FILTER_AGGREGATION)).filter();
        FilterAggregate filteredFlowNodes = ((Aggregate)filteredFlowNodesByType.aggregations().get(FILTERED_ELEMENTS_AGGREGATION)).filter();
        Optional<Map<String, Aggregate>> unwrappedLimitedAggregations = FilterLimitedAggregationUtilES.unwrapFilterLimitedAggregations(filteredFlowNodes.aggregations());
        this.getDistributedByInterpreter().enrichContextWithAllExpectedDistributedByKeys(context, filteredFlowNodesByType.aggregations());
        if (!unwrappedLimitedAggregations.isPresent()) {
            return Collections.emptyList();
        }
        Map<String, Map<String, Aggregate>> keyToAggregationMap = this.getDateAggregationService().mapDateAggregationsToKeyAggregationMap(unwrappedLimitedAggregations.get(), context.getTimezone());
        return this.mapKeyToAggMapToGroupByResults(keyToAggregationMap, response, context);
    }

    private List<CompositeCommandResult.GroupByResult> mapKeyToAggMapToGroupByResults(Map<String, Map<String, Aggregate>> keyToAggregationMap, ResponseBody<?> response, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return keyToAggregationMap.entrySet().stream().map(stringBucketEntry -> CompositeCommandResult.GroupByResult.createGroupByResult((String)stringBucketEntry.getKey(), this.getDistributedByInterpreter().retrieveResult(response, (Map)stringBucketEntry.getValue(), context))).collect(Collectors.toList());
    }

    private AggregateByDateUnit getGroupByDateUnit(ProcessReportDataDto processReportData) {
        return ((DateGroupByValueDto)processReportData.getGroupBy().getValue()).getUnit();
    }

    protected abstract String getDateField();

    protected abstract BoolQuery.Builder getFilterBoolQueryBuilder(ExecutionContext<ProcessReportDataDto, ?> var1);

    protected abstract Query getModelElementTypeFilterQuery();
}

