/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.reader;

import co.elastic.clients.elasticsearch.core.GetResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.SettingsDto;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeGetRequestBuilderES;
import io.camunda.optimize.service.db.reader.SettingsReader;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class SettingsReaderES
implements SettingsReader {
    private static final Logger LOG = LoggerFactory.getLogger(SettingsReaderES.class);
    private final OptimizeElasticsearchClient esClient;
    private final ObjectMapper objectMapper;
    private final ConfigurationService configurationService;

    public SettingsReaderES(OptimizeElasticsearchClient esClient, ObjectMapper objectMapper, ConfigurationService configurationService) {
        this.esClient = esClient;
        this.objectMapper = objectMapper;
        this.configurationService = configurationService;
    }

    @Override
    public Optional<SettingsDto> getSettings() {
        LOG.debug("Fetching Optimize Settings");
        SettingsDto result = null;
        try {
            GetResponse getResponse = this.esClient.get(OptimizeGetRequestBuilderES.of(g -> g.optimizeIndex(this.esClient, "settings").id("1")), SettingsDto.class);
            if (getResponse.found() && (result = (SettingsDto)getResponse.source()).getSharingEnabled().isEmpty()) {
                result.setSharingEnabled(Boolean.valueOf(this.configurationService.getSharingEnabled()));
            }
        }
        catch (IOException e) {
            String errorMessage = "There was an error while reading settings.";
            LOG.error("There was an error while reading settings.", (Throwable)e);
            throw new OptimizeRuntimeException("There was an error while reading settings.", (Throwable)e);
        }
        return Optional.ofNullable(result);
    }
}

