/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.reader;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.ScriptSortType;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.Buckets;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeAggregationSource;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeBucket;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeTermsAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.FiltersAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.FiltersAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.FiltersBucket;
import co.elastic.clients.elasticsearch._types.aggregations.StringTermsAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.StringTermsBucket;
import co.elastic.clients.elasticsearch._types.aggregations.TermsAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.TopHitsAggregate;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.TermsQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.TermsQueryField;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.elasticsearch.core.search.HitsMetadata;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.util.NamedValue;
import co.elastic.clients.util.ObjectBuilder;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.DefinitionOptimizeResponseDto;
import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.ProcessDefinitionOptimizeDto;
import io.camunda.optimize.dto.optimize.SimpleDefinitionDto;
import io.camunda.optimize.dto.optimize.query.definition.DefinitionWithTenantIdsDto;
import io.camunda.optimize.dto.optimize.query.definition.TenantIdWithDefinitionsDto;
import io.camunda.optimize.dto.optimize.rest.DefinitionVersionResponseDto;
import io.camunda.optimize.rest.exceptions.NotFoundException;
import io.camunda.optimize.service.db.es.ElasticsearchCompositeAggregationScroller;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeSearchRequestBuilderES;
import io.camunda.optimize.service.db.es.reader.ElasticsearchReaderUtil;
import io.camunda.optimize.service.db.es.schema.index.DecisionDefinitionIndexES;
import io.camunda.optimize.service.db.es.schema.index.ProcessDefinitionIndexES;
import io.camunda.optimize.service.db.es.writer.ElasticsearchWriterUtil;
import io.camunda.optimize.service.db.reader.DefinitionReader;
import io.camunda.optimize.service.db.schema.DefaultIndexMappingCreator;
import io.camunda.optimize.service.db.schema.IndexMappingCreator;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.DefinitionVersionHandlingUtil;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class DefinitionReaderES
implements DefinitionReader {
    private static final Logger LOG = LoggerFactory.getLogger(DefinitionReaderES.class);
    private final OptimizeElasticsearchClient esClient;
    private final ConfigurationService configurationService;
    private final ObjectMapper objectMapper;

    public DefinitionReaderES(OptimizeElasticsearchClient esClient, ConfigurationService configurationService, ObjectMapper objectMapper) {
        this.esClient = esClient;
        this.configurationService = configurationService;
        this.objectMapper = objectMapper;
    }

    @Override
    public Optional<DefinitionWithTenantIdsDto> getDefinitionWithAvailableTenants(DefinitionType type, String key) {
        return this.getDefinitionWithAvailableTenants(type, key, null, null);
    }

    @Override
    public Optional<DefinitionWithTenantIdsDto> getDefinitionWithAvailableTenants(DefinitionType type, String key, List<String> versions, Supplier<String> latestVersionSupplier) {
        if (type == null || key == null) {
            return Optional.empty();
        }
        Query.Builder builder = new Query.Builder();
        builder.bool(b -> {
            b.must(m -> m.term(t -> t.field("key").value(key))).must(m -> m.term(t -> t.field("deleted").value(false)));
            this.addVersionFilterToQuery(versions, latestVersionSupplier, (BoolQuery.Builder)b);
            return b;
        });
        return this.getDefinitionWithTenantIdsDtos(builder, type).stream().findFirst();
    }

    @Override
    public List<DefinitionWithTenantIdsDto> getFullyImportedDefinitionsWithTenantIds(DefinitionType type, Set<String> keys, Set<String> tenantIds) {
        Query.Builder builder = new Query.Builder();
        builder.bool(b -> {
            b.minimumShouldMatch("1").must(m -> m.term(t -> t.field("deleted").value(false))).should(s -> s.exists(e -> e.field("bpmn20Xml"))).should(s -> s.exists(e -> e.field("dmn10Xml")));
            if (!CollectionUtils.isEmpty((Collection)keys)) {
                b.filter(f -> f.terms(t -> t.field("key").terms(tt -> tt.value(keys.stream().map(FieldValue::of).toList()))));
            }
            this.addTenantIdFilter(tenantIds, (BoolQuery.Builder)b);
            return b;
        });
        return this.getDefinitionWithTenantIdsDtos(builder, type);
    }

    @Override
    public <T extends DefinitionOptimizeResponseDto> List<T> getFullyImportedDefinitions(DefinitionType type, boolean withXml) {
        return this.getDefinitions(type, true, withXml, false);
    }

    @Override
    public <T extends DefinitionOptimizeResponseDto> Optional<T> getFirstFullyImportedDefinitionFromTenantsIfAvailable(DefinitionType type, String definitionKey, List<String> definitionVersions, List<String> tenantIds) {
        String tenantId;
        if (definitionKey == null || definitionVersions == null || definitionVersions.isEmpty()) {
            return Optional.empty();
        }
        String mostRecentValidVersion = DefinitionVersionHandlingUtil.convertToLatestParticularVersion(definitionVersions, () -> this.getLatestVersionToKey(type, definitionKey));
        Optional definition = Optional.empty();
        Iterator<String> iterator = tenantIds.iterator();
        while (iterator.hasNext() && !(definition = this.getFullyImportedDefinition(type, definitionKey, mostRecentValidVersion, tenantId = iterator.next())).isPresent()) {
        }
        return definition;
    }

    @Override
    public <T extends DefinitionOptimizeResponseDto> List<T> getLatestFullyImportedDefinitionsFromTenantsIfAvailable(DefinitionType type, String definitionKey) {
        if (definitionKey == null) {
            return Collections.emptyList();
        }
        return this.getLatestFullyImportedDefinitionPerTenant(type, definitionKey);
    }

    @Override
    public Set<String> getDefinitionEngines(DefinitionType type, String definitionKey) {
        SearchResponse searchResponse;
        TermsAggregation termsAggregation = TermsAggregation.of(t -> t.field("dataSource.name").size(Integer.valueOf(1000)));
        SearchRequest searchRequest = OptimizeSearchRequestBuilderES.of(s -> s.optimizeIndex(this.esClient, new String[]{DefinitionType.PROCESS.equals((Object)type) ? "process-definition" : "decision-definition"}).query(q -> q.bool(b -> b.must(m -> m.term(t -> t.field(this.resolveDefinitionKeyFieldFromType(type)).value(definitionKey))).must(m -> m.term(t -> t.field("deleted").value(false))))).size(Integer.valueOf(0)).aggregations("engines", Aggregation.of(a -> a.terms(termsAggregation))));
        try {
            searchResponse = this.esClient.search(searchRequest, Object.class);
        }
        catch (IOException e) {
            String reason = String.format("Was not able to fetch engines for definition key [%s] and type [%s]", definitionKey, type);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        Buckets buckets = ((Aggregate)searchResponse.aggregations().get("engines")).sterms().buckets();
        if (buckets.isArray()) {
            return buckets.array().stream().map(b -> b.key().stringValue()).collect(Collectors.toSet());
        }
        return buckets.keyed().keySet();
    }

    @Override
    public Map<String, TenantIdWithDefinitionsDto> getDefinitionsGroupedByTenant() {
        Function<Map<String, FieldValue>, SearchRequest> aggregationRequestWithAfterKeys = map -> {
            TermsAggregation nameAggregation = TermsAggregation.of(b -> b.field("name").size(Integer.valueOf(1)));
            TermsAggregation enginesAggregation = TermsAggregation.of(b -> b.field("dataSource.name").size(Integer.valueOf(1000)));
            ArrayList<Map<String, CompositeAggregationSource>> keyAndTypeAndTenantSources = new ArrayList<Map<String, CompositeAggregationSource>>();
            keyAndTypeAndTenantSources.add(Map.of("tenants", CompositeAggregationSource.of(c -> c.terms(t -> (ObjectBuilder)((CompositeTermsAggregation.Builder)((CompositeTermsAggregation.Builder)t.field("tenantId")).missingBucket(Boolean.valueOf(true))).order(SortOrder.Asc)))));
            keyAndTypeAndTenantSources.add(Map.of("definitionKey", CompositeAggregationSource.of(c -> c.terms(t -> (ObjectBuilder)((CompositeTermsAggregation.Builder)((CompositeTermsAggregation.Builder)t.field("key")).missingBucket(Boolean.valueOf(false))).order(SortOrder.Asc)))));
            keyAndTypeAndTenantSources.add(Map.of("definitionType", CompositeAggregationSource.of(c -> c.terms(t -> (ObjectBuilder)((CompositeTermsAggregation.Builder)((CompositeTermsAggregation.Builder)t.field("_index")).missingBucket(Boolean.valueOf(false))).order(SortOrder.Asc)))));
            Aggregation keyAndTypeAndTenantAggregation = Aggregation.of(a -> a.composite(CompositeAggregation.of(b -> {
                b.sources(keyAndTypeAndTenantSources).size(this.configurationService.getElasticSearchConfiguration().getAggregationBucketLimit());
                if (map != null) {
                    b.after(map);
                }
                return b;
            })).aggregations("definitionName", Aggregation.of(a1 -> a1.terms(nameAggregation))).aggregations("engines", Aggregation.of(a1 -> a1.terms(enginesAggregation))));
            return OptimizeSearchRequestBuilderES.of(s -> s.optimizeIndex(this.esClient, ALL_DEFINITION_INDEXES).query(q -> q.term(t -> t.field("deleted").value(false))).aggregations("definitionKeyAndTypeAndTenant", keyAndTypeAndTenantAggregation).size(Integer.valueOf(0)));
        };
        HashMap<String, List> keyAndTypeAggBucketsByTenantId = new HashMap<String, List>();
        ElasticsearchCompositeAggregationScroller.create().setEsClient(this.esClient).setSearchRequest(aggregationRequestWithAfterKeys.apply(null)).setFunction(aggregationRequestWithAfterKeys).setPathToAggregation("definitionKeyAndTypeAndTenant").setCompositeBucketConsumer(bucket -> {
            String tenantId;
            FieldValue tenantIdFV = (FieldValue)bucket.key().get("tenants");
            String string = tenantId = tenantIdFV.isNull() ? null : tenantIdFV.stringValue();
            if (!keyAndTypeAggBucketsByTenantId.containsKey(tenantId)) {
                keyAndTypeAggBucketsByTenantId.put(tenantId, new ArrayList());
            }
            ((List)keyAndTypeAggBucketsByTenantId.get(tenantId)).add(bucket);
        }).consumeAllPages();
        HashMap<String, TenantIdWithDefinitionsDto> resultMap = new HashMap<String, TenantIdWithDefinitionsDto>();
        keyAndTypeAggBucketsByTenantId.forEach((key, value) -> {
            String tenantId = "null".equalsIgnoreCase((String)key) ? null : key;
            List<SimpleDefinitionDto> simpleDefinitionDtos = value.stream().map(parsedBucket -> {
                String indexAliasName = ((FieldValue)parsedBucket.key().get("definitionType")).stringValue();
                String definitionKey = ((FieldValue)parsedBucket.key().get("definitionKey")).stringValue();
                String definitionName = ((Aggregate)parsedBucket.aggregations().get("definitionName")).sterms().buckets().array().stream().findFirst().map(b -> b.key().stringValue()).orElse(null);
                StringTermsAggregate enginesResult = ((Aggregate)parsedBucket.aggregations().get("engines")).sterms();
                return new SimpleDefinitionDto(definitionKey, definitionName, this.resolveDefinitionTypeFromIndexAlias(indexAliasName), enginesResult.buckets().array().stream().map(b -> b.key().stringValue()).collect(Collectors.toSet()));
            }).toList();
            resultMap.put(tenantId, new TenantIdWithDefinitionsDto(tenantId, simpleDefinitionDtos));
        });
        return resultMap;
    }

    @Override
    public String getLatestVersionToKey(DefinitionType type, String key) {
        SearchResponse searchResponse;
        LOG.debug("Fetching latest [{}] definition for key [{}]", (Object)type, (Object)key);
        Script script = ElasticsearchWriterUtil.createDefaultScript("Integer.parseInt(doc['" + this.resolveVersionFieldFromType(type) + "'].value)");
        SearchRequest searchRequest = OptimizeSearchRequestBuilderES.of(s -> s.optimizeIndex(this.esClient, this.resolveIndexNameForType(type)).query(q -> q.bool(b -> b.must(m -> m.term(t -> t.field(this.resolveDefinitionKeyFieldFromType(type)).value(key))).must(m -> m.term(t -> t.field("deleted").value(false))))).sort(so -> so.script(ss -> ss.script(script).order(SortOrder.Desc).type(ScriptSortType.Number))).size(Integer.valueOf(1)));
        try {
            searchResponse = this.esClient.search(searchRequest, Map.class);
        }
        catch (IOException e) {
            String reason = String.format("Was not able to fetch latest [%s] definition for key [%s]", type, key);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        if (searchResponse.hits().hits().size() == 1) {
            Map sourceAsMap = (Map)((Hit)searchResponse.hits().hits().get(0)).source();
            if (sourceAsMap.containsKey(this.resolveVersionFieldFromType(type))) {
                return sourceAsMap.get(this.resolveVersionFieldFromType(type)).toString();
            }
        } else {
            throw new NotFoundException("Could not find latest version of definition with key: " + key);
        }
        throw new OptimizeRuntimeException("Unable to retrieve latest version for " + String.valueOf(type) + " definition key: " + key);
    }

    @Override
    public List<DefinitionVersionResponseDto> getDefinitionVersions(DefinitionType type, String key, Set<String> tenantIds) {
        SearchResponse searchResponse;
        BoolQuery.Builder filterQuery = new BoolQuery.Builder();
        filterQuery.filter(f -> f.term(t -> t.field("key").value(key))).filter(f -> f.term(t -> t.field("deleted").value(false)));
        this.addTenantIdFilter(tenantIds, filterQuery);
        TermsAggregation versionTagAggregation = TermsAggregation.of(t -> t.field("versionTag").size(Integer.valueOf(1)));
        Aggregation versionAggregation = Aggregation.of(a -> a.terms(TermsAggregation.of(t -> t.field("version").size(this.configurationService.getElasticSearchConfiguration().getAggregationBucketLimit()))).aggregations("versionTags", Aggregation.of(a1 -> a1.terms(versionTagAggregation))));
        SearchRequest searchRequest = OptimizeSearchRequestBuilderES.of(s -> s.optimizeIndex(this.esClient, this.resolveIndexNameForType(type)).query(Query.of(q -> q.bool(filterQuery.build()))).aggregations("versions", versionAggregation).size(Integer.valueOf(0)));
        try {
            searchResponse = this.esClient.search(searchRequest, DefinitionVersionResponseDto.class);
        }
        catch (IOException e) {
            String reason = String.format("Was not able to fetch [%s] definition versions with key [%s], tenantIds [%s]", type, key, tenantIds);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        return ((Aggregate)searchResponse.aggregations().get("versions")).sterms().buckets().array().stream().map(versionBucket -> {
            String version = versionBucket.key().stringValue();
            StringTermsAggregate versionTags = ((Aggregate)versionBucket.aggregations().get("versionTags")).sterms();
            String versionTag = versionTags.buckets().array().stream().findFirst().map(b -> b.key().stringValue()).orElse(null);
            return new DefinitionVersionResponseDto(version, versionTag);
        }).sorted(Comparator.comparing(DefinitionVersionResponseDto::getVersion).reversed()).collect(Collectors.toList());
    }

    @Override
    public <T extends DefinitionOptimizeResponseDto> List<T> getDefinitions(DefinitionType type, boolean fullyImported, boolean withXml, boolean includeDeleted) {
        return this.getDefinitions(type, Collections.emptySet(), fullyImported, withXml, includeDeleted);
    }

    @Override
    public <T extends DefinitionOptimizeResponseDto> List<T> getDefinitions(DefinitionType type, Set<String> definitionKeys, boolean fullyImported, boolean withXml, boolean includeDeleted) {
        String xmlField = this.resolveXmlFieldFromType(type);
        BoolQuery.Builder rootQuery = new BoolQuery.Builder();
        rootQuery.must(m -> {
            if (fullyImported) {
                return m.exists(e -> e.field(xmlField));
            }
            return m.matchAll(a -> a);
        });
        rootQuery.must(m -> m.matchAll(a -> a));
        if (!includeDeleted) {
            rootQuery.must(m -> m.term(t -> t.field("deleted").value(false)));
        }
        if (!definitionKeys.isEmpty()) {
            rootQuery.must(m -> m.terms(t -> t.field(this.resolveDefinitionKeyFieldFromType(type)).terms(tt -> tt.value(definitionKeys.stream().map(FieldValue::of).toList()))));
        }
        return this.getDefinitions(type, rootQuery, withXml);
    }

    public <T extends DefinitionOptimizeResponseDto> List<T> getDefinitions(DefinitionType type, BoolQuery.Builder filteredQuery, boolean withXml) {
        SearchResponse scrollResp;
        String xmlField = this.resolveXmlFieldFromType(type);
        List<String> fieldsToExclude = withXml ? null : List.of(xmlField);
        SearchRequest searchRequest = OptimizeSearchRequestBuilderES.of(s -> {
            s.optimizeIndex(this.esClient, this.resolveIndexNameForType(type)).query(Query.of(q -> q.bool(filteredQuery.build()))).size(Integer.valueOf(1000)).scroll(Time.of(t -> t.time(this.configurationService.getElasticSearchConfiguration().getScrollTimeoutInSeconds() + "s")));
            if (fieldsToExclude != null) {
                s.source(so -> so.filter(f -> f.excludes(fieldsToExclude)));
            }
            return s;
        });
        Class typeClass = this.resolveDefinitionClassFromType(type);
        try {
            scrollResp = this.esClient.search(searchRequest, typeClass);
        }
        catch (IOException e) {
            String errorMsg = String.format("Was not able to retrieve definitions of type %s", type);
            LOG.error(errorMsg, (Throwable)e);
            throw new OptimizeRuntimeException(errorMsg, (Throwable)e);
        }
        return ElasticsearchReaderUtil.retrieveAllScrollResults(scrollResp, typeClass, this.createMappingFunctionForDefinitionType(typeClass), this.esClient, (Integer)this.configurationService.getElasticSearchConfiguration().getScrollTimeoutInSeconds());
    }

    private void addVersionFilterToQuery(List<String> versions, Supplier<String> latestVersionSupplier, BoolQuery.Builder filterQuery) {
        if (!CollectionUtils.isEmpty(versions) && !DefinitionVersionHandlingUtil.isDefinitionVersionSetToAll(versions)) {
            filterQuery.filter(f -> f.terms(arg_0 -> DefinitionReaderES.lambda$addVersionFilterToQuery$85(versions, (Supplier)latestVersionSupplier, arg_0)));
        }
    }

    private <T extends DefinitionOptimizeResponseDto> Optional<T> getFullyImportedDefinition(DefinitionType type, String definitionKey, String definitionVersion, String tenantId) {
        SearchResponse searchResponse;
        if (definitionKey == null || definitionVersion == null) {
            return Optional.empty();
        }
        String validVersion = DefinitionVersionHandlingUtil.convertToLatestParticularVersion(definitionVersion, () -> this.getLatestVersionToKey(type, definitionKey));
        BoolQuery.Builder builder = new BoolQuery.Builder();
        builder.must(m -> m.term(t -> t.field(this.resolveDefinitionKeyFieldFromType(type)).value(definitionKey))).must(m -> m.term(t -> t.field(this.resolveVersionFieldFromType(type)).value(validVersion))).must(m -> m.term(t -> t.field("deleted").value(false))).must(m -> m.exists(e -> e.field(this.resolveXmlFieldFromType(type))));
        if (tenantId != null) {
            builder.must(m -> m.term(t -> t.field("tenantId").value(tenantId)));
        } else {
            builder.mustNot(m -> m.exists(e -> e.field("tenantId")));
        }
        SearchRequest searchRequest = OptimizeSearchRequestBuilderES.of(s -> s.optimizeIndex(this.esClient, this.resolveIndexNameForType(type)).query(Query.of(q -> q.bool(builder.build()))).size(Integer.valueOf(1)));
        Class typeClass = this.resolveDefinitionClassFromType(type);
        try {
            searchResponse = this.esClient.search(searchRequest, typeClass);
        }
        catch (IOException e) {
            String reason = String.format("Was not able to fetch [%s] definition with key [%s], version [%s] and tenantId [%s]", type, definitionKey, validVersion, tenantId);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        if (searchResponse.hits().total().value() == 0L) {
            LOG.debug("Could not find [{}] definition with key [{}], version [{}] and tenantId [{}]", new Object[]{type, definitionKey, validVersion, tenantId});
            return Optional.empty();
        }
        DefinitionOptimizeResponseDto definitionOptimizeDto = ElasticsearchReaderUtil.mapHits(searchResponse.hits(), 1, typeClass, this.createMappingFunctionForDefinitionType(typeClass)).stream().findFirst().orElse(null);
        return Optional.ofNullable(definitionOptimizeDto);
    }

    private <T extends DefinitionOptimizeResponseDto> List<T> getLatestFullyImportedDefinitionPerTenant(DefinitionType type, String key) {
        SearchResponse searchResponse;
        LOG.debug("Fetching latest fully imported [{}] definitions for key [{}] on each tenant", (Object)type, (Object)key);
        FiltersAggregation keyFilterAgg = FiltersAggregation.of(f -> f.filters(ff -> ff.array(List.of(Query.of(q -> q.bool(b -> b.must(m -> m.term(t -> t.field(this.resolveDefinitionKeyFieldFromType(type)).value(key))).must(m -> m.term(t -> t.field("deleted").value(false))).must(m -> m.exists(e -> e.field(this.resolveXmlFieldFromType(type))))))))));
        TermsAggregation tenantsAggregation = TermsAggregation.of(t -> t.field("tenantId").size(Integer.valueOf(1000)).missing("null"));
        Script numericVersionScript = ElasticsearchWriterUtil.createDefaultScript("Integer.parseInt(doc['" + this.resolveVersionFieldFromType(type) + "'].value)");
        Aggregation versionAggregation = Aggregation.of(a -> a.terms(t -> t.field("version").size(Integer.valueOf(1)).order(List.of(NamedValue.of((String)"versionForSorting", (Object)SortOrder.Desc)))).aggregations("versionForSorting", Aggregation.of(a1 -> a1.min(m -> (ObjectBuilder)m.script(numericVersionScript)))).aggregations("topHits", Aggregation.of(a2 -> a2.topHits(t -> t.size(Integer.valueOf(1))))));
        Aggregation definitionAgg = Aggregation.of(a -> a.filters(keyFilterAgg).aggregations("tenants", Aggregation.of(a1 -> a1.terms(tenantsAggregation).aggregations("versions", versionAggregation))));
        SearchRequest searchRequest = OptimizeSearchRequestBuilderES.of(s -> s.optimizeIndex(this.esClient, this.resolveIndexNameForType(type)).aggregations("definitionKeyFilter", definitionAgg).size(Integer.valueOf(0)));
        Class typeClass = this.resolveDefinitionClassFromType(type);
        try {
            searchResponse = this.esClient.search(searchRequest, typeClass);
        }
        catch (IOException e) {
            String reason = String.format("Was not able to fetch latest [%s] definitions for key [%s]", type, key);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        List<T> result = this.retrieveResultsFromLatestDefinitionPerTenant(type, searchResponse);
        if (result.isEmpty()) {
            LOG.debug("Could not find latest [{}] definitions with key [{}]", (Object)type, (Object)key);
        }
        return result;
    }

    private List<DefinitionWithTenantIdsDto> getDefinitionWithTenantIdsDtos(Query.Builder filterQuery, DefinitionType type) {
        TermsAggregation tenantsAggregation = TermsAggregation.of(b -> b.field("tenantId").size(Integer.valueOf(1000)).missing("null").order(List.of(NamedValue.of((String)"_key", (Object)SortOrder.Asc))));
        Aggregation nameAggregation = Aggregation.of(a -> a.terms(TermsAggregation.of(b -> b.field("name").size(Integer.valueOf(1)).order(NamedValue.of((String)"versionForSorting", (Object)SortOrder.Desc), new NamedValue[0]))).aggregations("versionForSorting", Aggregation.of(a1 -> a1.min(m -> (ObjectBuilder)m.script(ElasticsearchWriterUtil.createDefaultScript("Integer.parseInt(doc['version'].value)"))))));
        Aggregation enginesAggregation = Aggregation.of(a -> a.terms(t -> t.field("dataSource.name").minDocCount(Integer.valueOf(1)).size(Integer.valueOf(1000))));
        ArrayList<Map<String, CompositeAggregationSource>> keyAndTypeSources = new ArrayList<Map<String, CompositeAggregationSource>>();
        keyAndTypeSources.add(Map.of("definitionKey", CompositeAggregationSource.of(c -> c.terms(t -> (ObjectBuilder)((CompositeTermsAggregation.Builder)((CompositeTermsAggregation.Builder)t.field("key")).missingBucket(Boolean.valueOf(false))).order(SortOrder.Asc)))));
        keyAndTypeSources.add(Map.of("definitionType", CompositeAggregationSource.of(c -> c.terms(t -> (ObjectBuilder)((CompositeTermsAggregation.Builder)((CompositeTermsAggregation.Builder)t.field("_index")).missingBucket(Boolean.valueOf(false))).order(SortOrder.Asc)))));
        Supplier<CompositeAggregation.Builder> compositeSupplier = () -> {
            CompositeAggregation.Builder builder = new CompositeAggregation.Builder();
            builder.sources(keyAndTypeSources).size(this.configurationService.getElasticSearchConfiguration().getAggregationBucketLimit());
            return builder;
        };
        Function<CompositeAggregation.Builder, Aggregation.Builder.ContainerBuilder> keyAndTypeAggregation = b -> {
            Aggregation.Builder builder = new Aggregation.Builder();
            return builder.composite(b.build()).aggregations("tenants", Aggregation.of(a1 -> a1.terms(tenantsAggregation))).aggregations("definitionName", nameAggregation).aggregations("engines", enginesAggregation);
        };
        List<CompositeBucket> keyAndTypeAggBuckets = this.performSearchAndCollectAllKeyAndTypeBuckets(filterQuery, this.resolveIndexNameForType(type), keyAndTypeAggregation, compositeSupplier);
        return keyAndTypeAggBuckets.stream().map(keyAndTypeAgg -> {
            String indexAliasName = ((FieldValue)keyAndTypeAgg.key().get("definitionType")).stringValue();
            String definitionKey = ((FieldValue)keyAndTypeAgg.key().get("definitionKey")).stringValue();
            StringTermsAggregate tenantResult = ((Aggregate)keyAndTypeAgg.aggregations().get("tenants")).sterms();
            StringTermsAggregate nameResult = ((Aggregate)keyAndTypeAgg.aggregations().get("definitionName")).sterms();
            StringTermsAggregate enginesResult = ((Aggregate)keyAndTypeAgg.aggregations().get("engines")).sterms();
            return new DefinitionWithTenantIdsDto(definitionKey, nameResult.buckets().array().stream().findFirst().map(b -> b.key().stringValue()).orElse(null), this.resolveDefinitionTypeFromIndexAlias(indexAliasName), tenantResult.buckets().array().stream().map(b -> b.key().stringValue()).map(tenantId -> "null".equalsIgnoreCase((String)tenantId) ? null : tenantId).collect(Collectors.toList()), enginesResult.buckets().array().stream().map(b -> b.key().stringValue()).collect(Collectors.toSet()));
        }).toList();
    }

    private void addTenantIdFilter(Set<String> tenantIds, BoolQuery.Builder query) {
        if (!CollectionUtils.isEmpty(tenantIds)) {
            BoolQuery boolQuery = BoolQuery.of(b -> {
                Set nonNullValues;
                b.minimumShouldMatch("1");
                if (tenantIds.contains(null)) {
                    b.should(s -> s.bool(bb -> bb.mustNot(m -> m.exists(e -> e.field("tenantId")))));
                }
                if (!(nonNullValues = tenantIds.stream().filter(Objects::nonNull).collect(Collectors.toSet())).isEmpty()) {
                    b.should(s -> s.terms(t -> t.field("tenantId").terms(tt -> tt.value(nonNullValues.stream().map(FieldValue::of).toList()))));
                }
                return b;
            });
            query.filter(Query.of(q -> q.bool(boolQuery)), new Query[0]);
        }
    }

    private List<CompositeBucket> performSearchAndCollectAllKeyAndTypeBuckets(Query.Builder filterQuery, String[] definitionIndexNames, Function<CompositeAggregation.Builder, Aggregation.Builder.ContainerBuilder> keyAggregation, Supplier<CompositeAggregation.Builder> supplier) {
        Aggregation.Builder.ContainerBuilder build = keyAggregation.apply(supplier.get());
        Query query = filterQuery.build();
        SearchRequest searchRequest = OptimizeSearchRequestBuilderES.of(b -> b.optimizeIndex(this.esClient, definitionIndexNames).query(query).size(Integer.valueOf(0)).aggregations("definitionKeyAndType", a -> build));
        ArrayList<CompositeBucket> keyAndTypeAggBuckets = new ArrayList<CompositeBucket>();
        try {
            SearchResponse searchResponse = this.esClient.search(searchRequest, Object.class);
            CompositeAggregate keyAndTypeAggregationResult = ((Aggregate)searchResponse.aggregations().get("definitionKeyAndType")).composite();
            while (!keyAndTypeAggregationResult.buckets().array().isEmpty()) {
                keyAndTypeAggBuckets.addAll(keyAndTypeAggregationResult.buckets().array());
                CompositeAggregation.Builder after = supplier.get().after(keyAndTypeAggregationResult.afterKey());
                searchRequest = OptimizeSearchRequestBuilderES.of(s -> s.optimizeIndex(this.esClient, definitionIndexNames).query(query).size(Integer.valueOf(0)).aggregations("definitionKeyAndType", ((Aggregation.Builder.ContainerBuilder)keyAggregation.apply(after)).build()));
                searchResponse = this.esClient.search(searchRequest, Object.class);
                keyAndTypeAggregationResult = ((Aggregate)searchResponse.aggregations().get("definitionKeyAndType")).composite();
            }
        }
        catch (IOException e) {
            String reason = "Was not able to fetch definitions.";
            LOG.error("Was not able to fetch definitions.", (Throwable)e);
            throw new OptimizeRuntimeException("Was not able to fetch definitions.", (Throwable)e);
        }
        return keyAndTypeAggBuckets;
    }

    private <T extends DefinitionOptimizeResponseDto> List<T> retrieveResultsFromLatestDefinitionPerTenant(DefinitionType type, SearchResponse<T> searchResponse) {
        Class typeClass = this.resolveDefinitionClassFromType(type);
        ArrayList results = new ArrayList();
        FiltersAggregate filteredDefsAgg = ((Aggregate)searchResponse.aggregations().get("definitionKeyFilter")).filters();
        StringTermsAggregate tenantsAgg = ((Aggregate)((FiltersBucket)filteredDefsAgg.buckets().array().get(0)).aggregations().get("tenants")).sterms();
        for (StringTermsBucket tenantBucket : tenantsAgg.buckets().array()) {
            StringTermsAggregate versionsAgg = ((Aggregate)tenantBucket.aggregations().get("versions")).sterms();
            for (StringTermsBucket b : versionsAgg.buckets().array()) {
                TopHitsAggregate topHits = ((Aggregate)b.aggregations().get("topHits")).topHits();
                List<Hit> list = topHits.hits().hits().stream().map(r -> Hit.of(h -> h.id(r.id()).source(r.source()).index(r.index()))).toList();
                results.addAll(ElasticsearchReaderUtil.mapHits(HitsMetadata.of(h -> h.hits(list)), 1, typeClass, this.createMappingFunctionForDefinitionType(typeClass)));
            }
        }
        return results;
    }

    private <T extends DefinitionOptimizeResponseDto> Function<Hit<?>, T> createMappingFunctionForDefinitionType(Class<T> type) {
        return hit -> {
            DefinitionOptimizeResponseDto definitionDto = null;
            definitionDto = type.isInstance(hit.source()) ? (DefinitionOptimizeResponseDto)hit.source() : (DefinitionOptimizeResponseDto)this.objectMapper.convertValue(((List)((JsonData)hit.source()).to(List.class)).get(0), type);
            if (ProcessDefinitionOptimizeDto.class.equals((Object)type)) {
                ProcessDefinitionOptimizeDto processDefinition = (ProcessDefinitionOptimizeDto)definitionDto;
                processDefinition.setType(DefinitionType.PROCESS);
            } else {
                definitionDto.setType(DefinitionType.DECISION);
            }
            return definitionDto;
        };
    }

    private DefinitionType resolveDefinitionTypeFromIndexAlias(String indexName) {
        if (indexName.equals(this.getOptimizeIndexNameForIndex((DefaultIndexMappingCreator)new ProcessDefinitionIndexES()))) {
            return DefinitionType.PROCESS;
        }
        if (indexName.equals(this.getOptimizeIndexNameForIndex((DefaultIndexMappingCreator)new DecisionDefinitionIndexES()))) {
            return DefinitionType.DECISION;
        }
        throw new OptimizeRuntimeException("Unexpected definition index name: " + indexName);
    }

    private String getOptimizeIndexNameForIndex(DefaultIndexMappingCreator index) {
        return this.esClient.getIndexNameService().getOptimizeIndexNameWithVersion((IndexMappingCreator)index);
    }

    private static /* synthetic */ ObjectBuilder lambda$addVersionFilterToQuery$85(List versions, Supplier latestVersionSupplier, TermsQuery.Builder t) {
        return t.field("version").terms(arg_0 -> DefinitionReaderES.lambda$addVersionFilterToQuery$84(versions, (Supplier)latestVersionSupplier, arg_0));
    }

    private static /* synthetic */ ObjectBuilder lambda$addVersionFilterToQuery$84(List versions, Supplier latestVersionSupplier, TermsQueryField.Builder tt) {
        return tt.value(versions.stream().map(arg_0 -> DefinitionReaderES.lambda$addVersionFilterToQuery$83((Supplier)latestVersionSupplier, arg_0)).collect(Collectors.toList()));
    }

    private static /* synthetic */ FieldValue lambda$addVersionFilterToQuery$83(Supplier latestVersionSupplier, String version) {
        return FieldValue.of((String)DefinitionVersionHandlingUtil.convertToLatestParticularVersion(version, (Supplier<String>)latestVersionSupplier));
    }
}

