/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.reader;

import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch.core.GetRequest;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.query.collection.BaseCollectionDefinitionDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionDefinitionDto;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeGetRequestBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeSearchRequestBuilderES;
import io.camunda.optimize.service.db.es.reader.ElasticsearchReaderUtil;
import io.camunda.optimize.service.db.reader.CollectionReader;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class CollectionReaderES
implements CollectionReader {
    private static final Logger LOG = LoggerFactory.getLogger(CollectionReaderES.class);
    private final OptimizeElasticsearchClient esClient;
    private final ConfigurationService configurationService;
    private final ObjectMapper objectMapper;

    public CollectionReaderES(OptimizeElasticsearchClient esClient, ConfigurationService configurationService, ObjectMapper objectMapper) {
        this.esClient = esClient;
        this.configurationService = configurationService;
        this.objectMapper = objectMapper;
    }

    @Override
    public Optional<CollectionDefinitionDto> getCollection(String collectionId) {
        LOG.debug("Fetching collection with id [{}]", (Object)collectionId);
        GetRequest getRequest = OptimizeGetRequestBuilderES.of(b -> b.optimizeIndex(this.esClient, "collection").id(collectionId));
        try {
            return Optional.ofNullable((CollectionDefinitionDto)this.esClient.get(getRequest, CollectionDefinitionDto.class).source());
        }
        catch (IOException e) {
            String reason = String.format("Could not fetch collection with id [%s]", collectionId);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
    }

    @Override
    public List<CollectionDefinitionDto> getAllCollections() {
        SearchResponse scrollResp;
        LOG.debug("Fetching all available collections");
        SearchRequest searchRequest = OptimizeSearchRequestBuilderES.of(b -> b.optimizeIndex(this.esClient, new String[]{"collection"}).query(q -> q.matchAll(m -> m)).sort(s -> s.field(f -> f.field(BaseCollectionDefinitionDto.Fields.name.name()).order(SortOrder.Asc))).size(Integer.valueOf(1000)).scroll(s -> s.time(this.configurationService.getElasticSearchConfiguration().getScrollTimeoutInSeconds() + "s")));
        try {
            scrollResp = this.esClient.search(searchRequest, CollectionDefinitionDto.class);
        }
        catch (IOException e) {
            LOG.error("Was not able to retrieve collections!", (Throwable)e);
            throw new OptimizeRuntimeException("Was not able to retrieve collections!", (Throwable)e);
        }
        return ElasticsearchReaderUtil.retrieveAllScrollResults(scrollResp, CollectionDefinitionDto.class, this.objectMapper, this.esClient, (Integer)this.configurationService.getElasticSearchConfiguration().getScrollTimeoutInSeconds());
    }
}

