/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.reader;

import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.ShardFailure;
import co.elastic.clients.elasticsearch.snapshot.GetRepositoryRequest;
import co.elastic.clients.elasticsearch.snapshot.GetSnapshotRequest;
import co.elastic.clients.elasticsearch.snapshot.GetSnapshotResponse;
import co.elastic.clients.elasticsearch.snapshot.SnapshotInfo;
import io.camunda.optimize.dto.optimize.rest.SnapshotInfoDto;
import io.camunda.optimize.dto.optimize.rest.SnapshotState;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.reader.AbstractBackupReader;
import io.camunda.optimize.service.exceptions.OptimizeConfigurationException;
import io.camunda.optimize.service.exceptions.OptimizeElasticsearchConnectionException;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.exceptions.OptimizeSnapshotRepositoryNotFoundException;
import io.camunda.optimize.service.util.SnapshotUtil;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class BackupReaderES
extends AbstractBackupReader {
    private static final Logger LOG = LoggerFactory.getLogger(BackupReaderES.class);
    private final OptimizeElasticsearchClient esClient;
    private final ConfigurationService configurationService;

    public BackupReaderES(OptimizeElasticsearchClient esClient, ConfigurationService configurationService) {
        this.esClient = esClient;
        this.configurationService = configurationService;
    }

    @Override
    protected String getSnapshotRepositoryName() {
        return this.configurationService.getElasticSearchConfiguration().getSnapshotRepositoryName();
    }

    @Override
    protected void validateRepositoryExistsOrFail() {
        String repositoryName = this.getRepositoryName();
        if (StringUtils.isEmpty((CharSequence)repositoryName)) {
            String reason = "Cannot trigger backup because no Elasticsearch snapshot repository name found in Optimize configuration.";
            LOG.error("Cannot trigger backup because no Elasticsearch snapshot repository name found in Optimize configuration.");
            throw new OptimizeConfigurationException("Cannot trigger backup because no Elasticsearch snapshot repository name found in Optimize configuration.");
        }
        GetRepositoryRequest getRepositoriesRequest = GetRepositoryRequest.of(b -> b.name(repositoryName, new String[0]));
        try {
            this.esClient.verifyRepositoryExists(getRepositoriesRequest);
        }
        catch (ElasticsearchException e) {
            if (StringUtils.contains((CharSequence)e.getMessage(), (CharSequence)"repository_missing_exception")) {
                String reason = String.format("No repository with name [%s] could be found.", repositoryName);
                LOG.error(reason, (Throwable)e);
                throw new OptimizeSnapshotRepositoryNotFoundException(reason, e);
            }
            String reason = String.format("Error while retrieving repository with name [%s] due to an ElasticsearchException.", repositoryName);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        catch (IOException e) {
            String reason = String.format("Encountered an error connecting to Elasticsearch while retrieving repository with name [%s].", repositoryName);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeElasticsearchConnectionException(reason, e);
        }
    }

    @Override
    public Map<Long, List<SnapshotInfoDto>> getAllOptimizeSnapshotsByBackupId() {
        return this.getAllOptimizeSnapshots().stream().map(BackupReaderES::toSnapshotInfoDto).collect(Collectors.groupingBy(snapshotInfo -> SnapshotUtil.getBackupIdFromSnapshotName(snapshotInfo.getSnapshotName())));
    }

    @Override
    public List<SnapshotInfoDto> getOptimizeSnapshotsForBackupId(Long backupId) {
        return this.getOptimizeSnapshots(SnapshotUtil.getAllWildcardedSnapshotNamesForBackupId(backupId)).stream().map(BackupReaderES::toSnapshotInfoDto).toList();
    }

    private static SnapshotInfoDto toSnapshotInfoDto(SnapshotInfo snapshotInfo) {
        long startTimeMillis = snapshotInfo.startTimeInMillis();
        List<String> shardFailures = snapshotInfo.shards().failures().stream().map(ShardFailure::toString).toList();
        return new SnapshotInfoDto(snapshotInfo.snapshot(), SnapshotState.valueOf((String)snapshotInfo.state()), OffsetDateTime.ofInstant(Instant.ofEpochMilli(startTimeMillis), ZoneId.systemDefault()), shardFailures);
    }

    private List<SnapshotInfo> getAllOptimizeSnapshots() {
        return this.getOptimizeSnapshots(SnapshotUtil.getAllWildcardedSnapshotNamesForWildcardedBackupId());
    }

    private List<SnapshotInfo> getOptimizeSnapshots(String[] snapshots) {
        GetSnapshotResponse response;
        GetSnapshotRequest snapshotsStatusRequest = GetSnapshotRequest.of(b -> b.repository(this.getRepositoryName()).snapshot(Arrays.stream(snapshots).toList()));
        try {
            response = this.esClient.getSnapshots(snapshotsStatusRequest);
        }
        catch (ElasticsearchException e) {
            if (StringUtils.contains((CharSequence)e.getMessage(), (CharSequence)"snapshot_missing_exception")) {
                return Collections.emptyList();
            }
            String reason = String.format("Could not retrieve snapshots with names [%s] due to an ElasticsearchException.", String.join((CharSequence)", ", snapshots));
            LOG.error(reason);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        catch (IOException e) {
            String reason = String.format("Encountered an error connecting to Elasticsearch while retrieving snapshots with names [%s].", String.join((CharSequence)", ", snapshots));
            LOG.error(reason, (Throwable)e);
            throw new OptimizeElasticsearchConnectionException(reason, e);
        }
        return response.snapshots();
    }

    private String getRepositoryName() {
        return this.configurationService.getElasticSearchConfiguration().getSnapshotRepositoryName();
    }
}

