/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.filter.util;

import co.elastic.clients.elasticsearch._types.aggregations.DateHistogramAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.ExtendedBounds;
import co.elastic.clients.elasticsearch._types.aggregations.FieldDateMath;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.json.JsonData;
import io.camunda.optimize.dto.optimize.query.report.single.decision.filter.EvaluationDateFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.DateFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.InstanceEndDateFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.InstanceStartDateFilterDto;
import io.camunda.optimize.service.db.es.filter.DecisionQueryFilterEnhancerES;
import io.camunda.optimize.service.db.es.filter.ProcessQueryFilterEnhancerES;
import io.camunda.optimize.service.db.es.filter.QueryFilterES;
import io.camunda.optimize.service.db.es.report.context.DateAggregationContextES;
import io.camunda.optimize.service.db.filter.FilterContext;
import io.camunda.optimize.service.db.report.filter.util.DateHistogramFilterUtil;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;

public final class DateHistogramFilterUtilES {
    private DateHistogramFilterUtilES() {
    }

    public static BoolQuery.Builder createModelElementDateHistogramLimitingFilterFor(DateAggregationContextES context, DateTimeFormatter dateTimeFormatter) {
        BoolQuery.Builder queryDate = new BoolQuery.Builder();
        queryDate.filter(f -> f.range(r -> r.field(context.getDateField()).gte(JsonData.of((Object)dateTimeFormatter.format(context.getEarliestDate()))).lte(JsonData.of((Object)dateTimeFormatter.format(context.getLatestDate()))).format("yyyy-MM-dd'T'HH:mm:ss.SSSZ")));
        return queryDate;
    }

    public static BoolQuery.Builder extendBoundsAndCreateDecisionDateHistogramLimitingFilterFor(DateHistogramAggregation.Builder dateHistogramAggregation, DateAggregationContextES context, DateTimeFormatter dateFormatter) {
        DecisionQueryFilterEnhancerES queryFilterEnhancer = context.getDecisionQueryFilterEnhancer();
        List<DateFilterDataDto<?>> evaluationDateFilter = queryFilterEnhancer.extractFilters(context.getDecisionFilters(), EvaluationDateFilterDto.class);
        BoolQuery.Builder limitFilterQuery = DateHistogramFilterUtilES.createFilterBoolQueryBuilder(evaluationDateFilter, queryFilterEnhancer.getEvaluationDateQueryFilter(), context.getFilterContext());
        if (!evaluationDateFilter.isEmpty()) {
            DateHistogramFilterUtilES.getExtendedBoundsFromDateFilters(evaluationDateFilter, dateFormatter, context).ifPresent(arg_0 -> ((DateHistogramAggregation.Builder)dateHistogramAggregation).extendedBounds(arg_0));
        }
        return limitFilterQuery;
    }

    public static BoolQuery.Builder extendBoundsAndCreateProcessDateHistogramLimitingFilterFor(DateHistogramAggregation.Builder dateHistogramAggregation, DateAggregationContextES context, DateTimeFormatter dateTimeFormatter) {
        if (context.isStartDateAggregation()) {
            return DateHistogramFilterUtilES.extendBoundsAndCreateProcessStartDateHistogramLimitingFilterFor(dateHistogramAggregation, context, dateTimeFormatter);
        }
        return DateHistogramFilterUtilES.extendBoundsAndCreateProcessEndDateHistogramLimitingFilterFor(dateHistogramAggregation, context, dateTimeFormatter);
    }

    private static BoolQuery.Builder extendBoundsAndCreateProcessStartDateHistogramLimitingFilterFor(DateHistogramAggregation.Builder dateHistogramAggregation, DateAggregationContextES context, DateTimeFormatter dateTimeFormatter) {
        BoolQuery.Builder limitFilterQuery;
        ProcessQueryFilterEnhancerES queryFilterEnhancer = context.getProcessQueryFilterEnhancer();
        List<DateFilterDataDto<?>> startDateFilters = queryFilterEnhancer.extractInstanceFilters(context.getProcessFilters(), InstanceStartDateFilterDto.class);
        List<DateFilterDataDto<?>> endDateFilters = queryFilterEnhancer.extractInstanceFilters(context.getProcessFilters(), InstanceEndDateFilterDto.class);
        if (!endDateFilters.isEmpty() && startDateFilters.isEmpty()) {
            limitFilterQuery = DateHistogramFilterUtilES.createFilterBoolQueryBuilder(endDateFilters, queryFilterEnhancer.getInstanceEndDateQueryFilter(), context.getFilterContext());
        } else {
            if (!startDateFilters.isEmpty()) {
                DateHistogramFilterUtilES.getExtendedBoundsFromDateFilters(startDateFilters, dateTimeFormatter, context).ifPresent(arg_0 -> ((DateHistogramAggregation.Builder)dateHistogramAggregation).extendedBounds(arg_0));
            }
            limitFilterQuery = DateHistogramFilterUtilES.createFilterBoolQueryBuilder(startDateFilters, queryFilterEnhancer.getInstanceStartDateQueryFilter(), context.getFilterContext());
        }
        return limitFilterQuery;
    }

    private static BoolQuery.Builder extendBoundsAndCreateProcessEndDateHistogramLimitingFilterFor(DateHistogramAggregation.Builder dateHistogramAggregation, DateAggregationContextES context, DateTimeFormatter dateTimeFormatter) {
        BoolQuery.Builder limitFilterQuery;
        ProcessQueryFilterEnhancerES queryFilterEnhancer = context.getProcessQueryFilterEnhancer();
        List<DateFilterDataDto<?>> startDateFilters = queryFilterEnhancer.extractInstanceFilters(context.getProcessFilters(), InstanceStartDateFilterDto.class);
        List<DateFilterDataDto<?>> endDateFilters = queryFilterEnhancer.extractInstanceFilters(context.getProcessFilters(), InstanceEndDateFilterDto.class);
        if (endDateFilters.isEmpty() && !startDateFilters.isEmpty()) {
            limitFilterQuery = DateHistogramFilterUtilES.createFilterBoolQueryBuilder(startDateFilters, queryFilterEnhancer.getInstanceStartDateQueryFilter(), context.getFilterContext());
        } else {
            if (!endDateFilters.isEmpty()) {
                DateHistogramFilterUtilES.getExtendedBoundsFromDateFilters(endDateFilters, dateTimeFormatter, context).ifPresent(arg_0 -> ((DateHistogramAggregation.Builder)dateHistogramAggregation).extendedBounds(arg_0));
            }
            limitFilterQuery = DateHistogramFilterUtilES.createFilterBoolQueryBuilder(endDateFilters, queryFilterEnhancer.getInstanceEndDateQueryFilter(), context.getFilterContext());
        }
        return limitFilterQuery;
    }

    public static BoolQuery.Builder createFilterBoolQueryBuilder(List<DateFilterDataDto<?>> filters, QueryFilterES<DateFilterDataDto<?>> queryFilter, FilterContext filterContext) {
        BoolQuery.Builder limitFilterQuery = new BoolQuery.Builder();
        queryFilter.addFilters(limitFilterQuery, filters, filterContext);
        return limitFilterQuery;
    }

    private static Optional<ExtendedBounds<FieldDateMath>> getExtendedBoundsFromDateFilters(List<DateFilterDataDto<?>> dateFilters, DateTimeFormatter dateFormatter, DateAggregationContextES context) {
        Optional<OffsetDateTime> filterStart = DateHistogramFilterUtil.getMinDateFilterOffsetDateTime(dateFilters);
        OffsetDateTime filterEnd = DateHistogramFilterUtil.getMaxDateFilterOffsetDateTime(dateFilters);
        return filterStart.map(start -> ExtendedBounds.of(e -> e.min((Object)FieldDateMath.of(f -> f.value(Double.valueOf(start.atZoneSameInstant(context.getTimezone()).toInstant().toEpochMilli())))).max((Object)FieldDateMath.of(f -> f.value(Double.valueOf(filterEnd.atZoneSameInstant(context.getTimezone()).toInstant().toEpochMilli()))))));
    }
}

